/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.server.model.impl;

import io.selendroid.standalone.server.model.EmulatorPortFinder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultPortFinder
implements EmulatorPortFinder {
    private List<Integer> availablePorts = new ArrayList<Integer>();
    private List<Integer> portsInUse = new ArrayList<Integer>();
    private Integer minPort;
    private Integer maxPort;

    public DefaultPortFinder(Integer minPort, Integer maxPort) {
        this.minPort = minPort;
        this.maxPort = maxPort;
        for (int i = minPort.intValue(); i <= maxPort; ++i) {
            if (!this.isEvenNumber(i)) continue;
            this.availablePorts.add(i);
        }
    }

    @Override
    public synchronized Integer next() {
        if (this.availablePorts.isEmpty()) {
            return null;
        }
        Collections.sort(this.availablePorts);
        Integer port = this.availablePorts.get(0);
        this.portsInUse.add(port);
        this.availablePorts.remove(port);
        return port;
    }

    @Override
    public synchronized void release(Integer port) {
        if (port != null) {
            this.portsInUse.remove(port);
            if (port >= this.minPort && port <= this.maxPort && this.isEvenNumber(port)) {
                this.availablePorts.add(port);
            }
        }
    }

    private boolean isEvenNumber(Integer port) {
        if (port == null) {
            return false;
        }
        return port % 2 == 0;
    }
}

