/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.server.util;

import io.selendroid.standalone.SelendroidConfiguration;
import io.selendroid.standalone.exceptions.AndroidSdkException;
import io.selendroid.standalone.server.model.SelendroidStandaloneDriver;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.logging.Logger;

public class FolderMonitor
implements Runnable {
    private static final Logger log = Logger.getLogger(FolderMonitor.class.getName());
    private SelendroidConfiguration selendroidConfiguration;
    private SelendroidStandaloneDriver selendroidStandaloneDriver;
    private WatchService folderWatcher;
    private final Object stoppedLock;
    private boolean stopped;
    private Thread thread;

    public FolderMonitor(SelendroidStandaloneDriver selendroidStandaloneDriver, SelendroidConfiguration selendroidConfiguration) throws IOException {
        this.selendroidStandaloneDriver = selendroidStandaloneDriver;
        this.selendroidConfiguration = selendroidConfiguration;
        this.stoppedLock = new Object();
        this.stopped = false;
        this.init();
        this.folderWatcher = FileSystems.getDefault().newWatchService();
        Path watchedFolder = Paths.get(selendroidConfiguration.getAppFolderToMonitor(), new String[0]);
        try {
            watchedFolder.register(this.folderWatcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        }
        catch (NoSuchFileException e) {
            this.stop();
            log.warning("invalid location: " + new File(selendroidConfiguration.getAppFolderToMonitor()).getAbsolutePath());
        }
    }

    private void init() {
        File[] listOfFiles = new File(this.selendroidConfiguration.getAppFolderToMonitor()).listFiles();
        if (listOfFiles == null) {
            return;
        }
        for (File file : listOfFiles) {
            if (this.isResigned(file)) {
                file.delete();
                continue;
            }
            if (!this.isApp(file)) continue;
            this.addApplication(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.stoppedLock;
        synchronized (object) {
            while (!this.stopped) {
                this.checkForChanges();
                try {
                    this.stoppedLock.wait(1000L, 0);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void checkForChanges() {
        WatchKey key = this.folderWatcher.poll();
        if (key != null) {
            for (WatchEvent<?> watchEvent : key.pollEvents()) {
                Path filePath = (Path)watchEvent.context();
                WatchEvent.Kind<?> kind = watchEvent.kind();
                log.fine(kind + " : " + filePath);
                this.handleFileChange(kind, new File(this.selendroidConfiguration.getAppFolderToMonitor(), filePath.getFileName().toString()));
            }
            boolean valid = key.reset();
            if (!valid) {
                log.warning("Cannot monitor this folder anymore. Has it been deleted?");
                this.stop();
            }
        }
    }

    private void handleFileChange(WatchEvent.Kind kind, File file) {
        if (kind.equals(StandardWatchEventKinds.ENTRY_CREATE)) {
            if (this.isApp(file) && !this.isResigned(file)) {
                log.info("New app found! " + file.getName());
                this.addToAppStore(file);
            }
        } else if (kind.equals(StandardWatchEventKinds.ENTRY_MODIFY)) {
            log.info("App modified - no handler implemented!");
        } else if (kind.equals(StandardWatchEventKinds.ENTRY_DELETE)) {
            log.info("App deleted - no handler implemented!");
        }
    }

    private void addApplication(File file) {
        if (this.isApp(file) && !this.isResigned(file)) {
            String app = file.getAbsolutePath();
            this.selendroidConfiguration.addSupportedApp(app);
            log.info("File added to supported list:\n\t" + app);
        }
    }

    private void addToAppStore(File file) {
        if (this.isApp(file)) {
            String app = file.getAbsolutePath();
            try {
                this.selendroidStandaloneDriver.addToAppsStore(file);
                log.info("File added to app store:\n\t" + app);
            }
            catch (AndroidSdkException e) {
                log.info("An error occurred while accessing the details of'" + file.getName() + "'. ");
            }
        }
    }

    private boolean isApp(File file) {
        if (file != null) {
            return file.getAbsolutePath().endsWith(".apk");
        }
        return false;
    }

    private boolean isResigned(File file) {
        return this.isApp(file) && file.getAbsolutePath().contains("resigned");
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
        log.info("The Folder Monitor has been started with '" + this.selendroidConfiguration.getAppFolderToMonitor() + "'. New apps in this folder will be avalilable for testing immediately.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.stoppedLock;
        synchronized (object) {
            this.stopped = true;
        }
        try {
            if (this.thread != null) {
                this.thread.join();
                this.thread = null;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

