/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.standalone.server.util;

import io.netty.handler.codec.http.HttpMethod;
import io.selendroid.server.common.exceptions.SelendroidException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpClientUtil {
    private static final Logger log = Logger.getLogger(HttpClientUtil.class.getName());

    public static HttpClient getHttpClient() {
        return new DefaultHttpClient();
    }

    public static HttpResponse executeRequestWithPayload(String uri, int port, HttpMethod method, String payload) throws Exception {
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest(method.name(), uri);
        request.setEntity((HttpEntity)new StringEntity(payload, "UTF-8"));
        return HttpClientUtil.getHttpClient().execute(new HttpHost("localhost", port), (HttpRequest)request);
    }

    public static JSONObject parseJsonResponse(HttpResponse response) throws Exception {
        String r = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
        try {
            return new JSONObject(r);
        }
        catch (JSONException e) {
            log.severe("Failed to parse json response: " + r);
            throw e;
        }
    }

    public static HttpResponse executeRequest(String url, HttpMethod method) throws Exception {
        HttpGet request;
        if (HttpMethod.GET.equals((Object)method)) {
            request = new HttpGet(url);
        } else if (HttpMethod.POST.equals((Object)method)) {
            request = new HttpPost(url);
        } else if (HttpMethod.DELETE.equals((Object)method)) {
            request = new HttpDelete(url);
        } else {
            throw new RuntimeException("Provided HttpMethod not supported: " + method);
        }
        return HttpClientUtil.getHttpClient().execute((HttpUriRequest)request);
    }

    public static boolean isServerStarted(int port) {
        HttpResponse response;
        try {
            response = HttpClientUtil.executeRequest("http://localhost:" + port + "/wd/hub/sessions", HttpMethod.GET);
        }
        catch (Exception e) {
            return false;
        }
        try {
            JSONObject result = HttpClientUtil.parseJsonResponse(response);
            return result.getInt("status") == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void waitForServer(int port, long timeout, TimeUnit timeoutUnit) {
        long end = System.currentTimeMillis() + timeoutUnit.toMillis(timeout);
        while (!HttpClientUtil.isServerStarted(port)) {
            if (System.currentTimeMillis() > end) {
                throw new SelendroidException(String.format("Selendroid standalone server failed to start within %d %s", new Object[]{timeout, timeoutUnit}));
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

