/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.okhttp;

import io.sentry.Hint;
import io.sentry.IScopes;
import io.sentry.SentryEvent;
import io.sentry.exception.ExceptionMechanismException;
import io.sentry.exception.SentryHttpClientException;
import io.sentry.protocol.Mechanism;
import io.sentry.protocol.Request;
import io.sentry.util.HttpUtils;
import io.sentry.util.UrlUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ&\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J'\u0010\u0011\u001a\u00020\u0004*\u0004\u0018\u00010\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00040\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lio/sentry/okhttp/SentryOkHttpUtils;", "", "()V", "captureClientError", "", "scopes", "Lio/sentry/IScopes;", "request", "Lokhttp3/Request;", "response", "Lokhttp3/Response;", "captureClientError$sentry_okhttp", "getHeaders", "", "", "requestHeaders", "Lokhttp3/Headers;", "ifHasValidLength", "", "fn", "Lkotlin/Function1;", "(Ljava/lang/Long;Lkotlin/jvm/functions/Function1;)V", "sentry-okhttp"})
public final class SentryOkHttpUtils {
    @NotNull
    public static final SentryOkHttpUtils INSTANCE = new SentryOkHttpUtils();

    private SentryOkHttpUtils() {
    }

    public final void captureClientError$sentry_okhttp(@NotNull IScopes scopes, @NotNull okhttp3.Request request, @NotNull Response response) {
        io.sentry.protocol.Response response2;
        Request request2;
        Mechanism mechanism;
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        UrlUtils.UrlDetails urlDetails = UrlUtils.parse((String)request.url().toString());
        Intrinsics.checkNotNullExpressionValue((Object)urlDetails, (String)"parse(...)");
        UrlUtils.UrlDetails urlDetails2 = urlDetails;
        Mechanism $this$captureClientError_u24lambda_u240 = mechanism = new Mechanism();
        boolean bl = false;
        $this$captureClientError_u24lambda_u240.setType("SentryOkHttpInterceptor");
        Mechanism mechanism2 = mechanism;
        SentryHttpClientException exception = new SentryHttpClientException("HTTP Client Error with status code: " + response.code());
        ExceptionMechanismException mechanismException = new ExceptionMechanismException(mechanism2, (Throwable)exception, Thread.currentThread(), true);
        SentryEvent event = new SentryEvent((Throwable)mechanismException);
        Hint hint = new Hint();
        hint.set("okHttp:request", (Object)request);
        hint.set("okHttp:response", (Object)response);
        Request $this$captureClientError_u24lambda_u241 = request2 = new Request();
        boolean bl2 = false;
        urlDetails2.applyToRequest($this$captureClientError_u24lambda_u241);
        $this$captureClientError_u24lambda_u241.setCookies(scopes.getOptions().isSendDefaultPii() ? request.headers().get("Cookie") : null);
        $this$captureClientError_u24lambda_u241.setMethod(request.method());
        $this$captureClientError_u24lambda_u241.setHeaders(INSTANCE.getHeaders(scopes, request.headers()));
        RequestBody requestBody = request.body();
        INSTANCE.ifHasValidLength(requestBody != null ? Long.valueOf(requestBody.contentLength()) : null, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>($this$captureClientError_u24lambda_u241){
            final /* synthetic */ Request $this_apply;
            {
                this.$this_apply = $receiver;
                super(1);
            }

            public final void invoke(long it) {
                this.$this_apply.setBodySize(Long.valueOf(it));
            }
        }));
        Request sentryRequest2 = request2;
        io.sentry.protocol.Response $this$captureClientError_u24lambda_u242 = response2 = new io.sentry.protocol.Response();
        boolean bl3 = false;
        $this$captureClientError_u24lambda_u242.setCookies(scopes.getOptions().isSendDefaultPii() ? response.headers().get("Set-Cookie") : null);
        $this$captureClientError_u24lambda_u242.setHeaders(INSTANCE.getHeaders(scopes, response.headers()));
        $this$captureClientError_u24lambda_u242.setStatusCode(Integer.valueOf(response.code()));
        ResponseBody responseBody = response.body();
        INSTANCE.ifHasValidLength(responseBody != null ? Long.valueOf(responseBody.contentLength()) : null, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>($this$captureClientError_u24lambda_u242){
            final /* synthetic */ io.sentry.protocol.Response $this_apply;
            {
                this.$this_apply = $receiver;
                super(1);
            }

            public final void invoke(long it) {
                this.$this_apply.setBodySize(Long.valueOf(it));
            }
        }));
        io.sentry.protocol.Response sentryResponse2 = response2;
        event.setRequest(sentryRequest2);
        event.getContexts().setResponse(sentryResponse2);
        scopes.captureEvent(event, hint);
    }

    private final void ifHasValidLength(Long $this$ifHasValidLength, Function1<? super Long, Unit> fn) {
        if ($this$ifHasValidLength != null) {
            long l = -1L;
            if ($this$ifHasValidLength != l) {
                fn.invoke((Object)$this$ifHasValidLength);
            }
        }
    }

    private final Map<String, String> getHeaders(IScopes scopes, Headers requestHeaders) {
        if (!scopes.getOptions().isSendDefaultPii()) {
            return null;
        }
        Map headers = new LinkedHashMap();
        int n = requestHeaders.size();
        for (int i = 0; i < n; ++i) {
            String name = requestHeaders.name(i);
            if (HttpUtils.containsSensitiveHeader((String)name)) continue;
            String value = requestHeaders.value(i);
            headers.put(name, value);
        }
        return headers;
    }
}

