/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.foundation.ssl;

import com.netflix.config.ConcurrentCompositeConfiguration;
import io.servicecomb.foundation.ssl.SSLOption;

public interface SSLOptionFactory {
    public static SSLOptionFactory createSSLOptionFactory(String tag, ConcurrentCompositeConfiguration configSource) {
        String name = SSLOption.getStringProperty(configSource, null, "ssl." + tag + ".sslOptionFactory", "ssl.sslOptionFactory");
        return SSLOptionFactory.createSSLOptionFactory(name);
    }

    public static SSLOptionFactory createSSLOptionFactory(String className) {
        if (className != null && !className.isEmpty()) {
            try {
                return (SSLOptionFactory)Class.forName(className).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                return null;
            }
        }
        return null;
    }

    public SSLOption createSSLOption();
}

