/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.jdbc.adapter;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.shardingsphere.core.constant.ConnectionMode;
import io.shardingsphere.core.constant.transaction.TransactionOperationType;
import io.shardingsphere.core.constant.transaction.TransactionType;
import io.shardingsphere.core.event.ShardingEventBusInstance;
import io.shardingsphere.core.event.transaction.xa.XATransactionEvent;
import io.shardingsphere.core.hint.HintManagerHolder;
import io.shardingsphere.core.routing.router.masterslave.MasterVisitedManager;
import io.shardingsphere.shardingjdbc.jdbc.adapter.executor.ForceExecuteCallback;
import io.shardingsphere.shardingjdbc.jdbc.adapter.executor.ForceExecuteTemplate;
import io.shardingsphere.shardingjdbc.jdbc.unsupported.AbstractUnsupportedOperationConnection;
import io.shardingsphere.shardingjdbc.transaction.TransactionTypeHolder;
import io.shardingsphere.spi.root.RootInvokeHook;
import io.shardingsphere.spi.root.SPIRootInvokeHook;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public abstract class AbstractConnectionAdapter
extends AbstractUnsupportedOperationConnection {
    private final Multimap<String, Connection> cachedConnections = HashMultimap.create();
    private boolean autoCommit = true;
    private boolean readOnly = true;
    private boolean closed;
    private int transactionIsolation = 1;
    private final ForceExecuteTemplate<Connection> forceExecuteTemplate = new ForceExecuteTemplate();
    private final ForceExecuteTemplate<Map.Entry<String, Connection>> forceExecuteTemplateForClose = new ForceExecuteTemplate();
    private final RootInvokeHook rootInvokeHook = new SPIRootInvokeHook();

    protected AbstractConnectionAdapter() {
        this.rootInvokeHook.start();
    }

    public final Connection getConnection(String dataSourceName) throws SQLException {
        return this.getConnections(ConnectionMode.MEMORY_STRICTLY, dataSourceName, 1).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Connection> getConnections(ConnectionMode connectionMode, String dataSourceName, int connectionSize) throws SQLException {
        List<Connection> result;
        Collection connections;
        DataSource dataSource = this.getDataSourceMap().get(dataSourceName);
        Preconditions.checkState((null != dataSource ? 1 : 0) != 0, (String)"Missing the data source name: '%s'", (Object[])new Object[]{dataSourceName});
        Multimap<String, Connection> multimap = this.cachedConnections;
        synchronized (multimap) {
            connections = this.cachedConnections.get((Object)dataSourceName);
        }
        if (connections.size() >= connectionSize) {
            result = new ArrayList(connections).subList(0, connectionSize);
        } else {
            if (!connections.isEmpty()) {
                result = new ArrayList(connectionSize);
                result.addAll(connections);
                List<Connection> newConnections = this.createConnections(connectionMode, dataSource, connectionSize - connections.size());
                result.addAll(newConnections);
                Multimap<String, Connection> multimap2 = this.cachedConnections;
                synchronized (multimap2) {
                    this.cachedConnections.putAll((Object)dataSourceName, newConnections);
                }
            }
            result = new ArrayList<Connection>(this.createConnections(connectionMode, dataSource, connectionSize));
            Multimap<String, Connection> multimap3 = this.cachedConnections;
            synchronized (multimap3) {
                this.cachedConnections.putAll((Object)dataSourceName, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Connection> createConnections(ConnectionMode connectionMode, DataSource dataSource, int connectionSize) throws SQLException {
        if (1 == connectionSize) {
            return Collections.singletonList(this.createConnection(dataSource));
        }
        if (ConnectionMode.CONNECTION_STRICTLY == connectionMode) {
            return this.createConnections(dataSource, connectionSize);
        }
        DataSource dataSource2 = dataSource;
        synchronized (dataSource2) {
            return this.createConnections(dataSource, connectionSize);
        }
    }

    private List<Connection> createConnections(DataSource dataSource, int connectionSize) throws SQLException {
        ArrayList<Connection> result = new ArrayList<Connection>(connectionSize);
        for (int i = 0; i < connectionSize; ++i) {
            result.add(this.createConnection(dataSource));
        }
        return result;
    }

    private Connection createConnection(DataSource dataSource) throws SQLException {
        Connection result = dataSource.getConnection();
        this.replayMethodsInvocation(result);
        return result;
    }

    protected abstract Map<String, DataSource> getDataSourceMap();

    protected final void removeCache(Connection connection) {
        this.cachedConnections.values().remove(connection);
    }

    @Override
    public final boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public final void setAutoCommit(final boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
        if (TransactionType.LOCAL == TransactionTypeHolder.get()) {
            this.recordMethodInvocation(Connection.class, "setAutoCommit", new Class[]{Boolean.TYPE}, new Object[]{autoCommit});
            this.forceExecuteTemplate.execute(this.cachedConnections.values(), new ForceExecuteCallback<Connection>(){

                @Override
                public void execute(Connection connection) throws SQLException {
                    connection.setAutoCommit(autoCommit);
                }
            });
        } else if (TransactionType.XA == TransactionTypeHolder.get()) {
            ShardingEventBusInstance.getInstance().post((Object)new XATransactionEvent(TransactionOperationType.BEGIN));
        }
    }

    @Override
    public final void commit() throws SQLException {
        if (TransactionType.LOCAL == TransactionTypeHolder.get()) {
            this.forceExecuteTemplate.execute(this.cachedConnections.values(), new ForceExecuteCallback<Connection>(){

                @Override
                public void execute(Connection connection) throws SQLException {
                    connection.commit();
                }
            });
        } else if (TransactionType.XA == TransactionTypeHolder.get()) {
            ShardingEventBusInstance.getInstance().post((Object)new XATransactionEvent(TransactionOperationType.COMMIT));
        }
    }

    @Override
    public final void rollback() throws SQLException {
        if (TransactionType.LOCAL == TransactionTypeHolder.get()) {
            this.forceExecuteTemplate.execute(this.cachedConnections.values(), new ForceExecuteCallback<Connection>(){

                @Override
                public void execute(Connection connection) throws SQLException {
                    connection.rollback();
                }
            });
        } else if (TransactionType.XA == TransactionTypeHolder.get()) {
            ShardingEventBusInstance.getInstance().post((Object)new XATransactionEvent(TransactionOperationType.ROLLBACK));
        }
    }

    @Override
    public final void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        HintManagerHolder.clear();
        MasterVisitedManager.clear();
        TransactionTypeHolder.clear();
        int connectionSize = this.cachedConnections.size();
        try {
            this.forceExecuteTemplateForClose.execute(this.cachedConnections.entries(), new ForceExecuteCallback<Map.Entry<String, Connection>>(){

                @Override
                public void execute(Map.Entry<String, Connection> cachedConnections) throws SQLException {
                    cachedConnections.getValue().close();
                }
            });
        }
        finally {
            this.rootInvokeHook.finish(connectionSize);
        }
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public final boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public final void setReadOnly(final boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
        this.recordMethodInvocation(Connection.class, "setReadOnly", new Class[]{Boolean.TYPE}, new Object[]{readOnly});
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), new ForceExecuteCallback<Connection>(){

            @Override
            public void execute(Connection connection) throws SQLException {
                connection.setReadOnly(readOnly);
            }
        });
    }

    @Override
    public final int getTransactionIsolation() throws SQLException {
        if (this.cachedConnections.values().isEmpty()) {
            return this.transactionIsolation;
        }
        return ((Connection)this.cachedConnections.values().iterator().next()).getTransactionIsolation();
    }

    @Override
    public final void setTransactionIsolation(final int level) throws SQLException {
        this.transactionIsolation = level;
        this.recordMethodInvocation(Connection.class, "setTransactionIsolation", new Class[]{Integer.TYPE}, new Object[]{level});
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), new ForceExecuteCallback<Connection>(){

            @Override
            public void execute(Connection connection) throws SQLException {
                connection.setTransactionIsolation(level);
            }
        });
    }

    @Override
    public final SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public final int getHoldability() {
        return 2;
    }

    @Override
    public final void setHoldability(int holdability) {
    }
}

