/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.jdbc.core.datasource;

import com.google.common.base.Preconditions;
import io.shardingsphere.api.ConfigMapContext;
import io.shardingsphere.core.constant.properties.ShardingProperties;
import io.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import io.shardingsphere.core.executor.ShardingExecuteEngine;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.shardingjdbc.jdbc.adapter.AbstractDataSourceAdapter;
import io.shardingsphere.shardingjdbc.jdbc.core.ShardingContext;
import io.shardingsphere.shardingjdbc.jdbc.core.connection.ShardingConnection;
import io.shardingsphere.shardingjdbc.jdbc.core.datasource.MasterSlaveDataSource;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class ShardingDataSource
extends AbstractDataSourceAdapter
implements AutoCloseable {
    private final Map<String, DataSource> dataSourceMap;
    private final ShardingContext shardingContext;
    private final ShardingProperties shardingProperties;

    public ShardingDataSource(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule) throws SQLException {
        this(dataSourceMap, shardingRule, new ConcurrentHashMap<String, Object>(), new Properties());
    }

    public ShardingDataSource(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule, Map<String, Object> configMap, Properties props) throws SQLException {
        super(dataSourceMap.values());
        this.checkDataSourceType(dataSourceMap);
        if (!configMap.isEmpty()) {
            ConfigMapContext.getInstance().getShardingConfig().putAll(configMap);
        }
        this.dataSourceMap = dataSourceMap;
        this.shardingProperties = new ShardingProperties(null == props ? new Properties() : props);
        this.shardingContext = this.getShardingContext(shardingRule);
    }

    public ShardingDataSource(Map<String, DataSource> dataSourceMap, ShardingContext shardingContext, ShardingProperties shardingProperties) throws SQLException {
        super(dataSourceMap.values());
        this.dataSourceMap = dataSourceMap;
        this.shardingContext = shardingContext;
        this.shardingProperties = shardingProperties;
    }

    private void checkDataSourceType(Map<String, DataSource> dataSourceMap) {
        for (DataSource each : dataSourceMap.values()) {
            Preconditions.checkArgument((!(each instanceof MasterSlaveDataSource) ? 1 : 0) != 0, (Object)"Initialized data sources can not be master-slave data sources.");
        }
    }

    private ShardingContext getShardingContext(ShardingRule shardingRule) throws SQLException {
        int executorSize = (Integer)this.shardingProperties.getValue(ShardingPropertiesConstant.EXECUTOR_SIZE);
        int maxConnectionsSizePerQuery = (Integer)this.shardingProperties.getValue(ShardingPropertiesConstant.MAX_CONNECTIONS_SIZE_PER_QUERY);
        boolean showSQL = (Boolean)this.shardingProperties.getValue(ShardingPropertiesConstant.SQL_SHOW);
        return new ShardingContext(this.dataSourceMap, shardingRule, this.getDatabaseType(), new ShardingExecuteEngine(executorSize), maxConnectionsSizePerQuery, showSQL);
    }

    @Override
    public final ShardingConnection getConnection() {
        return new ShardingConnection(this.dataSourceMap, this.shardingContext);
    }

    @Override
    public final void close() {
        this.closeOriginalDataSources();
        this.shardingContext.close();
    }

    private void closeOriginalDataSources() {
        for (DataSource each : this.dataSourceMap.values()) {
            try {
                each.getClass().getDeclaredMethod("close", new Class[0]).invoke((Object)each, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {}
        }
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public ShardingContext getShardingContext() {
        return this.shardingContext;
    }

    public ShardingProperties getShardingProperties() {
        return this.shardingProperties;
    }
}

