/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.api.yaml;

import io.shardingsphere.core.api.MasterSlaveDataSourceFactory;
import io.shardingsphere.core.yaml.masterslave.YamlMasterSlaveConfiguration;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;

public final class YamlMasterSlaveDataSourceFactory {
    public static DataSource createDataSource(File yamlFile) throws SQLException, IOException {
        YamlMasterSlaveConfiguration config = YamlMasterSlaveConfiguration.unmarshal((File)yamlFile);
        return MasterSlaveDataSourceFactory.createDataSource(config.getDataSources(), config.getMasterSlaveRule().getMasterSlaveRuleConfiguration(), config.getMasterSlaveRule().getConfigMap(), config.getMasterSlaveRule().getProps());
    }

    public static DataSource createDataSource(byte[] yamlBytes) throws SQLException, IOException {
        YamlMasterSlaveConfiguration config = YamlMasterSlaveConfiguration.unmarshal((byte[])yamlBytes);
        return MasterSlaveDataSourceFactory.createDataSource(config.getDataSources(), config.getMasterSlaveRule().getMasterSlaveRuleConfiguration(), config.getMasterSlaveRule().getConfigMap(), config.getMasterSlaveRule().getProps());
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, File yamlFile) throws SQLException, IOException {
        YamlMasterSlaveConfiguration config = YamlMasterSlaveConfiguration.unmarshal((File)yamlFile);
        return MasterSlaveDataSourceFactory.createDataSource(dataSourceMap, config.getMasterSlaveRule().getMasterSlaveRuleConfiguration(), config.getMasterSlaveRule().getConfigMap(), config.getMasterSlaveRule().getProps());
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, byte[] yamlBytes) throws SQLException, IOException {
        YamlMasterSlaveConfiguration config = YamlMasterSlaveConfiguration.unmarshal((byte[])yamlBytes);
        return MasterSlaveDataSourceFactory.createDataSource(dataSourceMap, config.getMasterSlaveRule().getMasterSlaveRuleConfiguration(), config.getMasterSlaveRule().getConfigMap(), config.getMasterSlaveRule().getProps());
    }

    private YamlMasterSlaveDataSourceFactory() {
    }
}

