/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.batch;

import io.shardingsphere.core.executor.sql.SQLExecuteUnit;
import io.shardingsphere.core.routing.RouteUnit;
import java.beans.ConstructorProperties;
import java.sql.PreparedStatement;
import java.util.LinkedHashMap;
import java.util.Map;

public final class BatchPreparedStatementExecuteUnit
implements SQLExecuteUnit {
    private final RouteUnit routeUnit;
    private final PreparedStatement statement;
    private final Map<Integer, Integer> jdbcAndActualAddBatchCallTimesMap = new LinkedHashMap<Integer, Integer>();
    private int actualCallAddBatchTimes;

    public void mapAddBatchCount(int jdbcAddBatchTimes) {
        this.jdbcAndActualAddBatchCallTimesMap.put(jdbcAddBatchTimes, this.actualCallAddBatchTimes++);
    }

    @ConstructorProperties(value={"routeUnit", "statement"})
    public BatchPreparedStatementExecuteUnit(RouteUnit routeUnit, PreparedStatement statement) {
        this.routeUnit = routeUnit;
        this.statement = statement;
    }

    public RouteUnit getRouteUnit() {
        return this.routeUnit;
    }

    public PreparedStatement getStatement() {
        return this.statement;
    }

    public Map<Integer, Integer> getJdbcAndActualAddBatchCallTimesMap() {
        return this.jdbcAndActualAddBatchCallTimesMap;
    }
}

