/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.prepared;

import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.executor.sql.SQLExecuteUnit;
import io.shardingsphere.core.executor.sql.execute.SQLExecuteCallback;
import io.shardingsphere.core.executor.sql.execute.threadlocal.ExecutorDataMap;
import io.shardingsphere.core.executor.sql.execute.threadlocal.ExecutorExceptionHandler;
import java.beans.ConstructorProperties;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public abstract class PreparedStatementExecutor {
    private final SQLType sqlType;

    public List<ResultSet> executeQuery() throws SQLException {
        boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        Map dataMap = ExecutorDataMap.getDataMap();
        SQLExecuteCallback<ResultSet> executeCallback = new SQLExecuteCallback<ResultSet>(this.sqlType, isExceptionThrown, dataMap){

            protected ResultSet executeSQL(SQLExecuteUnit sqlExecuteUnit) throws SQLException {
                return ((PreparedStatement)sqlExecuteUnit.getStatement()).executeQuery();
            }
        };
        return this.executeCallback(executeCallback);
    }

    public int executeUpdate() throws SQLException {
        boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        Map dataMap = ExecutorDataMap.getDataMap();
        SQLExecuteCallback<Integer> executeCallback = new SQLExecuteCallback<Integer>(this.sqlType, isExceptionThrown, dataMap){

            protected Integer executeSQL(SQLExecuteUnit sqlExecuteUnit) throws SQLException {
                return ((PreparedStatement)sqlExecuteUnit.getStatement()).executeUpdate();
            }
        };
        List<Integer> results = this.executeCallback(executeCallback);
        return this.accumulate(results);
    }

    private int accumulate(List<Integer> results) {
        int result = 0;
        for (Integer each : results) {
            result += null == each ? 0 : each;
        }
        return result;
    }

    public boolean execute() throws SQLException {
        Map dataMap;
        boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        SQLExecuteCallback<Boolean> executeCallback = new SQLExecuteCallback<Boolean>(this.sqlType, isExceptionThrown, dataMap = ExecutorDataMap.getDataMap()){

            protected Boolean executeSQL(SQLExecuteUnit sqlExecuteUnit) throws SQLException {
                return ((PreparedStatement)sqlExecuteUnit.getStatement()).execute();
            }
        };
        List<Boolean> result = this.executeCallback(executeCallback);
        if (null == result || result.isEmpty() || null == result.get(0)) {
            return false;
        }
        return result.get(0);
    }

    protected abstract <T> List<T> executeCallback(SQLExecuteCallback<T> var1) throws SQLException;

    @ConstructorProperties(value={"sqlType"})
    public PreparedStatementExecutor(SQLType sqlType) {
        this.sqlType = sqlType;
    }
}

