/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.adapter;

import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.jdbc.adapter.invocation.SetParameterMethodInvocation;
import io.shardingsphere.core.jdbc.unsupported.AbstractUnsupportedOperationPreparedStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractShardingPreparedStatementAdapter
extends AbstractUnsupportedOperationPreparedStatement {
    private final List<SetParameterMethodInvocation> setParameterMethodInvocations = new LinkedList<SetParameterMethodInvocation>();
    private final List<Object> parameters = new ArrayList<Object>();

    @Override
    public final void setNull(int parameterIndex, int sqlType) {
        this.setParameter(parameterIndex, null);
    }

    @Override
    public final void setNull(int parameterIndex, int sqlType, String typeName) {
        this.setParameter(parameterIndex, null);
    }

    @Override
    public final void setBoolean(int parameterIndex, boolean x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setByte(int parameterIndex, byte x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setShort(int parameterIndex, short x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setInt(int parameterIndex, int x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setLong(int parameterIndex, long x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setFloat(int parameterIndex, float x) {
        this.setParameter(parameterIndex, Float.valueOf(x));
    }

    @Override
    public final void setDouble(int parameterIndex, double x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setString(int parameterIndex, String x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setBigDecimal(int parameterIndex, BigDecimal x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setDate(int parameterIndex, Date x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setDate(int parameterIndex, Date x, Calendar cal) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setTime(int parameterIndex, Time x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setTime(int parameterIndex, Time x, Calendar cal) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setTimestamp(int parameterIndex, Timestamp x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setBytes(int parameterIndex, byte[] x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setBlob(int parameterIndex, Blob x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setBlob(int parameterIndex, InputStream x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setBlob(int parameterIndex, InputStream x, long length) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setClob(int parameterIndex, Clob x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setClob(int parameterIndex, Reader x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setClob(int parameterIndex, Reader x, long length) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x, int length) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x, long length) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setUnicodeStream(int parameterIndex, InputStream x, int length) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setBinaryStream(int parameterIndex, InputStream x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setBinaryStream(int parameterIndex, InputStream x, int length) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setBinaryStream(int parameterIndex, InputStream x, long length) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setCharacterStream(int parameterIndex, Reader x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setCharacterStream(int parameterIndex, Reader x, int length) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setCharacterStream(int parameterIndex, Reader x, long length) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setURL(int parameterIndex, URL x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setSQLXML(int parameterIndex, SQLXML x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setObject(int parameterIndex, Object x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setObject(int parameterIndex, Object x, int targetSqlType) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) {
        this.setParameter(parameterIndex, x);
    }

    private void setParameter(int parameterIndex, Object value) {
        if (this.parameters.size() == parameterIndex - 1) {
            this.parameters.add(value);
            return;
        }
        for (int i = this.parameters.size(); i <= parameterIndex - 1; ++i) {
            this.parameters.add(null);
        }
        this.parameters.set(parameterIndex - 1, value);
    }

    private void recordSetParameter(String methodName, Class[] argumentTypes, Object ... arguments) {
        try {
            this.setParameterMethodInvocations.add(new SetParameterMethodInvocation(PreparedStatement.class.getMethod(methodName, argumentTypes), arguments, arguments[1]));
        }
        catch (NoSuchMethodException ex) {
            throw new ShardingException((Exception)ex);
        }
    }

    protected final void replaySetParameter(PreparedStatement preparedStatement, List<Object> parameters) {
        this.setParameterMethodInvocations.clear();
        this.addParameters(parameters);
        for (SetParameterMethodInvocation each : this.setParameterMethodInvocations) {
            each.invoke(preparedStatement);
        }
    }

    private void addParameters(List<Object> parameters) {
        for (int i = 0; i < parameters.size(); ++i) {
            this.recordSetParameter("setObject", new Class[]{Integer.TYPE, Object.class}, i + 1, parameters.get(i));
        }
    }

    @Override
    public final void clearParameters() {
        this.parameters.clear();
        this.setParameterMethodInvocations.clear();
    }

    public List<Object> getParameters() {
        return this.parameters;
    }
}

