/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.core.connection;

import io.shardingsphere.core.jdbc.adapter.AbstractConnectionAdapter;
import io.shardingsphere.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingsphere.core.jdbc.core.statement.MasterSlavePreparedStatement;
import io.shardingsphere.core.jdbc.core.statement.MasterSlaveStatement;
import java.beans.ConstructorProperties;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;

public final class MasterSlaveConnection
extends AbstractConnectionAdapter {
    private final MasterSlaveDataSource masterSlaveDataSource;

    @Override
    protected Map<String, DataSource> getDataSourceMap() {
        return this.masterSlaveDataSource.getDataSourceMap();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getConnection(this.masterSlaveDataSource.getMasterSlaveRule().getMasterDataSourceName()).getMetaData();
    }

    @Override
    public Statement createStatement() {
        return new MasterSlaveStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) {
        return new MasterSlaveStatement(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new MasterSlaveStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new MasterSlavePreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new MasterSlavePreparedStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new MasterSlavePreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new MasterSlavePreparedStatement(this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new MasterSlavePreparedStatement(this, sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new MasterSlavePreparedStatement(this, sql, columnNames);
    }

    @ConstructorProperties(value={"masterSlaveDataSource"})
    public MasterSlaveConnection(MasterSlaveDataSource masterSlaveDataSource) {
        this.masterSlaveDataSource = masterSlaveDataSource;
    }

    public MasterSlaveDataSource getMasterSlaveDataSource() {
        return this.masterSlaveDataSource;
    }
}

