/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.core.statement;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.ConnectionMode;
import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.event.ShardingEventBusInstance;
import io.shardingsphere.core.event.merger.MergeEvent;
import io.shardingsphere.core.event.routing.RoutingEvent;
import io.shardingsphere.core.executor.ShardingExecuteGroup;
import io.shardingsphere.core.executor.sql.SQLExecuteUnit;
import io.shardingsphere.core.executor.sql.execute.SQLExecuteTemplate;
import io.shardingsphere.core.executor.sql.execute.result.MemoryQueryResult;
import io.shardingsphere.core.executor.sql.execute.result.StreamQueryResult;
import io.shardingsphere.core.executor.sql.prepare.SQLExecutePrepareCallback;
import io.shardingsphere.core.executor.sql.prepare.SQLExecutePrepareTemplate;
import io.shardingsphere.core.executor.statement.ConnectionStrictlyStatementExecutor;
import io.shardingsphere.core.executor.statement.MemoryStrictlyStatementExecutor;
import io.shardingsphere.core.executor.statement.StatementExecuteUnit;
import io.shardingsphere.core.executor.statement.StatementExecutor;
import io.shardingsphere.core.jdbc.adapter.AbstractStatementAdapter;
import io.shardingsphere.core.jdbc.core.ShardingContext;
import io.shardingsphere.core.jdbc.core.connection.ShardingConnection;
import io.shardingsphere.core.jdbc.core.resultset.GeneratedKeysResultSet;
import io.shardingsphere.core.jdbc.core.resultset.ShardingResultSet;
import io.shardingsphere.core.jdbc.metadata.JDBCTableMetaDataConnectionManager;
import io.shardingsphere.core.merger.MergeEngine;
import io.shardingsphere.core.merger.MergeEngineFactory;
import io.shardingsphere.core.merger.MergedResult;
import io.shardingsphere.core.merger.QueryResult;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataConnectionManager;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataLoader;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dal.DALStatement;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.DQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.routing.RouteUnit;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.core.routing.StatementRoutingEngine;
import io.shardingsphere.core.routing.router.sharding.GeneratedKey;
import io.shardingsphere.core.rule.ShardingRule;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class ShardingStatement
extends AbstractStatementAdapter {
    private final ShardingConnection connection;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final int resultSetHoldability;
    private final Collection<Statement> routedStatements = new LinkedList<Statement>();
    private boolean returnGeneratedKeys;
    private SQLRouteResult routeResult;
    private ResultSet currentResultSet;

    public ShardingStatement(ShardingConnection connection) {
        this(connection, 1003, 1007, 1);
    }

    public ShardingStatement(ShardingConnection connection, int resultSetType, int resultSetConcurrency) {
        this(connection, resultSetType, resultSetConcurrency, 1);
    }

    public ShardingStatement(ShardingConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(Statement.class);
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        ShardingResultSet result;
        try {
            this.clearPrevious();
            this.sqlRoute(sql);
            List<ResultSet> resultSets = this.getStatementExecutor().executeQuery();
            MergeEngine mergeEngine = MergeEngineFactory.newInstance((ShardingRule)this.connection.getShardingDataSource().getShardingContext().getShardingRule(), this.getQueryResults(resultSets), (SQLStatement)this.routeResult.getSqlStatement(), (ShardingTableMetaData)this.connection.getShardingDataSource().getShardingContext().getMetaData().getTable());
            result = new ShardingResultSet(resultSets, this.merge(mergeEngine), this);
        }
        finally {
            this.currentResultSet = null;
        }
        this.currentResultSet = result;
        return result;
    }

    private List<QueryResult> getQueryResults(List<ResultSet> resultSets) throws SQLException {
        ArrayList<QueryResult> result = new ArrayList<QueryResult>(resultSets.size());
        for (ResultSet each : resultSets) {
            if (ConnectionMode.MEMORY_STRICTLY == this.connection.getShardingDataSource().getShardingContext().getConnectionMode()) {
                result.add((QueryResult)new StreamQueryResult(each));
                continue;
            }
            result.add((QueryResult)new MemoryQueryResult(each));
        }
        return result;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            this.clearPrevious();
            this.sqlRoute(sql);
            int n = this.getStatementExecutor().executeUpdate();
            return n;
        }
        finally {
            this.refreshTableMetaData();
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (1 == autoGeneratedKeys) {
            this.returnGeneratedKeys = true;
        }
        try {
            this.clearPrevious();
            this.sqlRoute(sql);
            int n = this.getStatementExecutor().executeUpdate(autoGeneratedKeys);
            return n;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            this.clearPrevious();
            this.sqlRoute(sql);
            int n = this.getStatementExecutor().executeUpdate(columnIndexes);
            return n;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            this.clearPrevious();
            this.sqlRoute(sql);
            int n = this.getStatementExecutor().executeUpdate(columnNames);
            return n;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            this.clearPrevious();
            this.sqlRoute(sql);
            boolean bl = this.getStatementExecutor().execute();
            return bl;
        }
        finally {
            this.refreshTableMetaData();
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (1 == autoGeneratedKeys) {
            this.returnGeneratedKeys = true;
        }
        try {
            this.clearPrevious();
            this.sqlRoute(sql);
            boolean bl = this.getStatementExecutor().execute(autoGeneratedKeys);
            return bl;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            this.clearPrevious();
            this.sqlRoute(sql);
            boolean bl = this.getStatementExecutor().execute(columnIndexes);
            return bl;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            this.clearPrevious();
            this.sqlRoute(sql);
            boolean bl = this.getStatementExecutor().execute(columnNames);
            return bl;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    private StatementExecutor getStatementExecutor() throws SQLException {
        SQLExecuteTemplate sqlExecuteTemplate = new SQLExecuteTemplate(this.connection.getShardingDataSource().getShardingContext().getExecuteEngine());
        if (ConnectionMode.MEMORY_STRICTLY == this.connection.getShardingDataSource().getShardingContext().getConnectionMode()) {
            return new MemoryStrictlyStatementExecutor(this.routeResult.getSqlStatement().getType(), sqlExecuteTemplate, this.getExecuteUnitsForMemoryStrictly());
        }
        return new ConnectionStrictlyStatementExecutor(this.routeResult.getSqlStatement().getType(), sqlExecuteTemplate, this.getExecuteUnitsForConnectionStrictly());
    }

    private Collection<StatementExecuteUnit> getExecuteUnitsForMemoryStrictly() throws SQLException {
        LinkedList<StatementExecuteUnit> result = new LinkedList<StatementExecuteUnit>();
        for (RouteUnit each : this.routeResult.getRouteUnits()) {
            result.add(this.getStatementExecuteUnit(this.connection.getConnection(each.getDataSourceName()), each));
        }
        return result;
    }

    private Collection<ShardingExecuteGroup<StatementExecuteUnit>> getExecuteUnitsForConnectionStrictly() throws SQLException {
        SQLExecutePrepareTemplate sqlExecutePrepareTemplate = new SQLExecutePrepareTemplate(this.connection.getShardingDataSource().getShardingContext().getMaxConnectionsSizePerQuery());
        return sqlExecutePrepareTemplate.getExecuteUnitGroups(this.routeResult.getRouteUnits(), new SQLExecutePrepareCallback(){

            public Connection getConnection(String dataSourceName) throws SQLException {
                return ShardingStatement.this.connection.getConnection(dataSourceName);
            }

            public SQLExecuteUnit createSQLExecuteUnit(Connection connection, RouteUnit routeUnit) throws SQLException {
                return ShardingStatement.this.getStatementExecuteUnit(connection, routeUnit);
            }
        });
    }

    private StatementExecuteUnit getStatementExecuteUnit(Connection connection, RouteUnit routeUnit) throws SQLException {
        Statement statement = connection.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
        this.routedStatements.add(statement);
        this.replayMethodsInvocation(statement);
        return new StatementExecuteUnit(routeUnit, statement);
    }

    private void clearPrevious() throws SQLException {
        for (Statement each : this.routedStatements) {
            each.close();
        }
        this.routedStatements.clear();
    }

    private void sqlRoute(String sql) {
        ShardingContext shardingContext = this.connection.getShardingDataSource().getShardingContext();
        RoutingEvent event = new RoutingEvent(sql);
        ShardingEventBusInstance.getInstance().post((Object)event);
        try {
            this.routeResult = new StatementRoutingEngine(shardingContext.getShardingRule(), shardingContext.getMetaData().getTable(), shardingContext.getDatabaseType(), shardingContext.isShowSQL(), shardingContext.getMetaData().getDataSource()).route(sql);
        }
        catch (Exception ex) {
            event.setExecuteFailure(ex);
            ShardingEventBusInstance.getInstance().post((Object)event);
            throw ex;
        }
        event.setExecuteSuccess();
        ShardingEventBusInstance.getInstance().post((Object)event);
    }

    private void refreshTableMetaData() throws SQLException {
        if (null != this.routeResult && null != this.connection && SQLType.DDL == this.routeResult.getSqlStatement().getType() && !this.routeResult.getSqlStatement().getTables().isEmpty()) {
            String logicTableName = this.routeResult.getSqlStatement().getTables().getSingleTableName();
            TableMetaDataLoader tableMetaDataLoader = new TableMetaDataLoader(this.connection.getShardingDataSource().getShardingContext().getMetaData().getDataSource(), this.connection.getShardingDataSource().getShardingContext().getExecuteEngine(), (TableMetaDataConnectionManager)new JDBCTableMetaDataConnectionManager(this.connection.getShardingDataSource().getDataSourceMap()), this.connection.getShardingDataSource().getShardingContext().getMaxConnectionsSizePerQuery());
            this.connection.getShardingDataSource().getShardingContext().getMetaData().getTable().put(logicTableName, tableMetaDataLoader.load(logicTableName, this.connection.getShardingDataSource().getShardingContext().getShardingRule()));
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Optional<GeneratedKey> generatedKey = this.getGeneratedKey();
        if (this.returnGeneratedKeys && generatedKey.isPresent()) {
            return new GeneratedKeysResultSet(this.routeResult.getGeneratedKey().getGeneratedKeys().iterator(), ((GeneratedKey)generatedKey.get()).getColumn().getName(), this);
        }
        if (1 == this.getRoutedStatements().size()) {
            return this.getRoutedStatements().iterator().next().getGeneratedKeys();
        }
        return new GeneratedKeysResultSet();
    }

    private Optional<GeneratedKey> getGeneratedKey() {
        if (null != this.routeResult && this.routeResult.getSqlStatement() instanceof InsertStatement) {
            return Optional.fromNullable((Object)this.routeResult.getGeneratedKey());
        }
        return Optional.absent();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null != this.currentResultSet) {
            return this.currentResultSet;
        }
        if (1 == this.routedStatements.size() && this.routeResult.getSqlStatement() instanceof DQLStatement) {
            this.currentResultSet = this.routedStatements.iterator().next().getResultSet();
            return this.currentResultSet;
        }
        ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>(this.routedStatements.size());
        ArrayList<StreamQueryResult> queryResults = new ArrayList<StreamQueryResult>(this.routedStatements.size());
        for (Statement each : this.routedStatements) {
            ResultSet resultSet = each.getResultSet();
            resultSets.add(resultSet);
            queryResults.add(new StreamQueryResult(resultSet));
        }
        if (this.routeResult.getSqlStatement() instanceof SelectStatement || this.routeResult.getSqlStatement() instanceof DALStatement) {
            MergeEngine mergeEngine = MergeEngineFactory.newInstance((ShardingRule)this.connection.getShardingDataSource().getShardingContext().getShardingRule(), queryResults, (SQLStatement)this.routeResult.getSqlStatement(), (ShardingTableMetaData)this.connection.getShardingDataSource().getShardingContext().getMetaData().getTable());
            this.currentResultSet = new ShardingResultSet(resultSets, this.merge(mergeEngine), this);
        }
        return this.currentResultSet;
    }

    private MergedResult merge(MergeEngine mergeEngine) throws SQLException {
        MergeEvent event = new MergeEvent();
        try {
            ShardingEventBusInstance.getInstance().post((Object)event);
            MergedResult result = mergeEngine.merge();
            event.setExecuteSuccess();
            ShardingEventBusInstance.getInstance().post((Object)event);
            return result;
        }
        catch (Exception ex) {
            event.setExecuteFailure(ex);
            ShardingEventBusInstance.getInstance().post((Object)event);
            throw ex;
        }
    }

    @Override
    public ShardingConnection getConnection() {
        return this.connection;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public Collection<Statement> getRoutedStatements() {
        return this.routedStatements;
    }
}

