/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.aggregation;

import io.siddhi.core.aggregation.AggregationRuntime;
import io.siddhi.core.aggregation.IncrementalExecutor;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.Event;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.query.StoreQueryRuntime;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.IncrementalTimeConverterUtil;
import io.siddhi.core.util.parser.StoreQueryParser;
import io.siddhi.core.window.Window;
import io.siddhi.query.api.aggregation.TimePeriod;
import io.siddhi.query.api.execution.query.StoreQuery;
import io.siddhi.query.api.execution.query.input.store.InputStore;
import io.siddhi.query.api.execution.query.selection.Selector;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.condition.Compare;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RecreateInMemoryData {
    private final List<TimePeriod.Duration> incrementalDurations;
    private final Map<TimePeriod.Duration, Table> aggregationTables;
    private final Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap;
    private final Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMapForPartitions;
    private final SiddhiAppContext siddhiAppContext;
    private final StreamEventFactory streamEventFactory;
    private final Map<String, Table> tableMap;
    private final Map<String, Window> windowMap;
    private final Map<String, AggregationRuntime> aggregationMap;
    private final String shardId;

    public RecreateInMemoryData(List<TimePeriod.Duration> incrementalDurations, Map<TimePeriod.Duration, Table> aggregationTables, Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap, SiddhiAppContext siddhiAppContext, MetaStreamEvent metaStreamEvent, Map<String, Table> tableMap, Map<String, Window> windowMap, Map<String, AggregationRuntime> aggregationMap, String shardId, Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMapForPartitions) {
        this.incrementalDurations = incrementalDurations;
        this.aggregationTables = aggregationTables;
        this.incrementalExecutorMap = incrementalExecutorMap;
        this.siddhiAppContext = siddhiAppContext;
        this.streamEventFactory = new StreamEventFactory(metaStreamEvent);
        this.tableMap = tableMap;
        this.windowMap = windowMap;
        this.aggregationMap = aggregationMap;
        this.shardId = shardId;
        this.incrementalExecutorMapForPartitions = incrementalExecutorMapForPartitions;
    }

    public void recreateInMemoryData(boolean refreshReadingExecutors) {
        IncrementalExecutor rootExecutor = this.incrementalExecutorMap.get(this.incrementalDurations.get(0));
        if (rootExecutor.isProcessingExecutor() && rootExecutor.getNextEmitTime() != -1L && !refreshReadingExecutors) {
            return;
        }
        Long latestEventTimestamp = null;
        Table tableForMaxDuration = this.aggregationTables.get(this.incrementalDurations.get(this.incrementalDurations.size() - 1));
        StoreQuery storeQuery = this.shardId == null || refreshReadingExecutors ? StoreQuery.query().from((InputStore)InputStore.store((String)tableForMaxDuration.getTableDefinition().getId())).select(Selector.selector().orderBy(Expression.variable((String)"AGG_TIMESTAMP"))) : StoreQuery.query().from(InputStore.store((String)tableForMaxDuration.getTableDefinition().getId()).on(Expression.compare((Expression)Expression.variable((String)"SHARD_ID"), (Compare.Operator)Compare.Operator.EQUAL, (Expression)Expression.value((String)this.shardId)))).select(Selector.selector().orderBy(Expression.variable((String)"AGG_TIMESTAMP")));
        storeQuery.setType(StoreQuery.StoreQueryType.FIND);
        StoreQueryRuntime storeQueryRuntime = StoreQueryParser.parse(storeQuery, this.siddhiAppContext, this.tableMap, this.windowMap, this.aggregationMap);
        Event[] events = storeQueryRuntime.execute();
        if (events != null) {
            latestEventTimestamp = (Long)events[events.length - 1].getData(0);
        }
        for (int i = this.incrementalDurations.size() - 1; i > 0; --i) {
            TimePeriod.Duration recreateForDuration = this.incrementalDurations.get(i);
            IncrementalExecutor incrementalExecutor = refreshReadingExecutors ? this.incrementalExecutorMapForPartitions.get(recreateForDuration) : this.incrementalExecutorMap.get(recreateForDuration);
            incrementalExecutor.clearExecutor();
            Table recreateFromTable = this.aggregationTables.get(this.incrementalDurations.get(i - 1));
            storeQuery = this.shardId == null || refreshReadingExecutors ? StoreQuery.query().from((InputStore)InputStore.store((String)recreateFromTable.getTableDefinition().getId())).select(Selector.selector().orderBy(Expression.variable((String)"AGG_TIMESTAMP"))) : StoreQuery.query().from(InputStore.store((String)recreateFromTable.getTableDefinition().getId()).on(Expression.compare((Expression)Expression.variable((String)"SHARD_ID"), (Compare.Operator)Compare.Operator.EQUAL, (Expression)Expression.value((String)this.shardId)))).select(Selector.selector().orderBy(Expression.variable((String)"AGG_TIMESTAMP")));
            storeQuery.setType(StoreQuery.StoreQueryType.FIND);
            storeQueryRuntime = StoreQueryParser.parse(storeQuery, this.siddhiAppContext, this.tableMap, this.windowMap, this.aggregationMap);
            events = storeQueryRuntime.execute();
            if (events == null) continue;
            long referenceToNextLatestEvent = (Long)events[events.length - 1].getData(0);
            if (latestEventTimestamp != null) {
                ArrayList<Event> eventsNewerThanLatestEventOfRecreateForDuration = new ArrayList<Event>();
                for (Event event : events) {
                    long timeBucketForNextDuration = IncrementalTimeConverterUtil.getStartTimeOfAggregates((Long)event.getData(0), recreateForDuration);
                    if (timeBucketForNextDuration <= latestEventTimestamp) continue;
                    eventsNewerThanLatestEventOfRecreateForDuration.add(event);
                }
                events = eventsNewerThanLatestEventOfRecreateForDuration.toArray(new Event[eventsNewerThanLatestEventOfRecreateForDuration.size()]);
            }
            latestEventTimestamp = referenceToNextLatestEvent;
            ComplexEventChunk<StreamEvent> complexEventChunk = new ComplexEventChunk<StreamEvent>(false);
            for (Event event : events) {
                StreamEvent streamEvent = this.streamEventFactory.newInstance();
                streamEvent.setOutputData(event.getData());
                complexEventChunk.add(streamEvent);
            }
            incrementalExecutor.execute(complexEventChunk);
            if (i != 1) continue;
            TimePeriod.Duration rootDuration = this.incrementalDurations.get(0);
            IncrementalExecutor rootIncrementalExecutor = refreshReadingExecutors ? this.incrementalExecutorMapForPartitions.get(rootDuration) : this.incrementalExecutorMap.get(rootDuration);
            long emitTimeOfLatestEventInTable = IncrementalTimeConverterUtil.getNextEmitTime(latestEventTimestamp, rootDuration, null);
            rootIncrementalExecutor.setValuesForInMemoryRecreateFromTable(emitTimeOfLatestEventInTable);
        }
    }
}

