/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.config;

import com.lmax.disruptor.ExceptionHandler;
import io.siddhi.core.config.SiddhiContext;
import io.siddhi.core.function.Script;
import io.siddhi.core.util.IdGenerator;
import io.siddhi.core.util.Scheduler;
import io.siddhi.core.util.ThreadBarrier;
import io.siddhi.core.util.extension.holder.ExternalReferencedHolder;
import io.siddhi.core.util.snapshot.SnapshotService;
import io.siddhi.core.util.snapshot.state.EmptyStateHolder;
import io.siddhi.core.util.snapshot.state.SingleStateHolder;
import io.siddhi.core.util.snapshot.state.SingleSyncStateHolder;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.snapshot.state.StateHolder;
import io.siddhi.core.util.statistics.StatisticsManager;
import io.siddhi.core.util.timestamp.TimestampGenerator;
import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public class SiddhiAppContext {
    private SiddhiContext siddhiContext = null;
    private String name;
    private boolean playback;
    private boolean enforceOrder;
    private boolean statsEnabled = false;
    private StatisticsManager statisticsManager = null;
    private ExecutorService executorService;
    private ScheduledExecutorService scheduledExecutorService;
    private List<ExternalReferencedHolder> externalReferencedHolders = Collections.synchronizedList(new LinkedList());
    private SnapshotService snapshotService;
    private ThreadBarrier threadBarrier = null;
    private TimestampGenerator timestampGenerator = null;
    private IdGenerator idGenerator;
    private Map<String, Script> scriptFunctionMap = new HashMap<String, Script>();
    private ExceptionHandler<Object> disruptorExceptionHandler;
    private ExceptionListener runtimeExceptionListener;
    private int bufferSize;
    private String siddhiAppString;
    private List<String> includedMetrics;
    private boolean transportChannelCreationEnabled;
    private List<Scheduler> schedulerList = new ArrayList<Scheduler>();
    private static final ThreadLocal<String> GROUP_BY_KEY = new ThreadLocal();
    private static final ThreadLocal<String> PARTITION_KEY = new ThreadLocal();

    public static void startGroupByFlow(String key) {
        GROUP_BY_KEY.set(key);
    }

    public static void stopGroupByFlow() {
        GROUP_BY_KEY.set(null);
    }

    public static void startPartitionFlow(String key) {
        PARTITION_KEY.set(key);
    }

    public static void stopPartitionFlow() {
        PARTITION_KEY.set(null);
    }

    public static String getCurrentFlowId() {
        return PARTITION_KEY.get() + "--" + GROUP_BY_KEY.get();
    }

    public static String getPartitionFlowId() {
        return PARTITION_KEY.get();
    }

    public static String getGroupByFlowId() {
        return GROUP_BY_KEY.get();
    }

    public SiddhiContext getSiddhiContext() {
        return this.siddhiContext;
    }

    public void setSiddhiContext(SiddhiContext siddhiContext) {
        this.siddhiContext = siddhiContext;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPlayback() {
        return this.playback;
    }

    public void setPlayback(boolean playback) {
        this.playback = playback;
    }

    public boolean isEnforceOrder() {
        return this.enforceOrder;
    }

    public void setEnforceOrder(boolean enforceOrder) {
        this.enforceOrder = enforceOrder;
    }

    public boolean isStatsEnabled() {
        return this.statsEnabled;
    }

    public void setStatsEnabled(boolean statsEnabled) {
        this.statsEnabled = statsEnabled;
    }

    public StatisticsManager getStatisticsManager() {
        return this.statisticsManager;
    }

    public void setStatisticsManager(StatisticsManager statisticsManager) {
        this.statisticsManager = statisticsManager;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public void addEternalReferencedHolder(ExternalReferencedHolder externalReferencedHolder) {
        this.externalReferencedHolders.add(externalReferencedHolder);
    }

    public List<ExternalReferencedHolder> getExternalReferencedHolders() {
        return Collections.unmodifiableList(new ArrayList<ExternalReferencedHolder>(this.externalReferencedHolders));
    }

    public ThreadBarrier getThreadBarrier() {
        return this.threadBarrier;
    }

    public void setThreadBarrier(ThreadBarrier threadBarrier) {
        this.threadBarrier = threadBarrier;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public TimestampGenerator getTimestampGenerator() {
        return this.timestampGenerator;
    }

    public void setTimestampGenerator(TimestampGenerator timestampGenerator) {
        this.timestampGenerator = timestampGenerator;
    }

    public SnapshotService getSnapshotService() {
        return this.snapshotService;
    }

    public void setSnapshotService(SnapshotService snapshotService) {
        this.snapshotService = snapshotService;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public Script getScript(String name) {
        return this.scriptFunctionMap.get(name);
    }

    public boolean isFunctionExist(String name) {
        return this.scriptFunctionMap.get(name) != null;
    }

    public Map<String, Script> getScriptFunctionMap() {
        return this.scriptFunctionMap;
    }

    public ExceptionHandler<Object> getDisruptorExceptionHandler() {
        if (this.disruptorExceptionHandler != null) {
            return this.disruptorExceptionHandler;
        }
        return this.siddhiContext.getDefaultDisrupterExceptionHandler();
    }

    public void setDisruptorExceptionHandler(ExceptionHandler<Object> disruptorExceptionHandler) {
        this.disruptorExceptionHandler = disruptorExceptionHandler;
    }

    public ExceptionListener getRuntimeExceptionListener() {
        return this.runtimeExceptionListener;
    }

    public void setRuntimeExceptionListener(ExceptionListener runtimeExceptionListener) {
        this.runtimeExceptionListener = runtimeExceptionListener;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getSiddhiAppString() {
        return this.siddhiAppString;
    }

    public void setSiddhiAppString(String siddhiAppString) {
        this.siddhiAppString = siddhiAppString;
    }

    public List<String> getIncludedMetrics() {
        return this.includedMetrics;
    }

    public void setIncludedMetrics(List<String> includedMetrics) {
        this.includedMetrics = includedMetrics;
    }

    public boolean isTransportChannelCreationEnabled() {
        return this.transportChannelCreationEnabled;
    }

    public void setTransportChannelCreationEnabled(boolean transportChannelCreationEnabled) {
        this.transportChannelCreationEnabled = transportChannelCreationEnabled;
    }

    public void addScheduler(Scheduler scheduler) {
        this.schedulerList.add(scheduler);
    }

    public List<Scheduler> getSchedulerList() {
        return this.schedulerList;
    }

    public StateHolder generateStateHolder(String name, StateFactory stateFactory) {
        return this.generateStateHolder(name, stateFactory, false);
    }

    public StateHolder generateStateHolder(String name, StateFactory stateFactory, boolean unSafe) {
        if (stateFactory != null) {
            StateHolder stateHolder = unSafe ? new SingleStateHolder(stateFactory) : new SingleSyncStateHolder(stateFactory);
            if (SnapshotService.getSkipStateStorageThreadLocal().get() == null || !SnapshotService.getSkipStateStorageThreadLocal().get().booleanValue()) {
                Map<String, StateHolder> stateHolderMap = this.getSnapshotService().getStateHolderMap("null", "null");
                stateHolderMap.put(name + "-" + this.idGenerator.createNewId(), stateHolder);
            }
            return stateHolder;
        }
        return new EmptyStateHolder();
    }
}

