/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.event.stream.converter;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.Event;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import java.util.List;

public class FaultStreamEventConverter {
    private StreamEventFactory streamEventFactory;

    public FaultStreamEventConverter(StreamEventFactory streamEventFactory) {
        this.streamEventFactory = streamEventFactory;
    }

    public StreamEvent convert(Event event, Exception e) {
        StreamEvent newEvent = this.streamEventFactory.newInstance();
        this.convertEvent(event, newEvent, e);
        return newEvent;
    }

    public StreamEvent convert(long timestamp, Object[] data, Exception e) {
        StreamEvent newEvent = this.streamEventFactory.newInstance();
        this.convertData(timestamp, data, newEvent, e);
        return newEvent;
    }

    public StreamEvent convert(ComplexEvent complexEvents, Exception e) {
        StreamEvent firstEvent = this.streamEventFactory.newInstance();
        this.convertComplexEvent(complexEvents, firstEvent, e);
        StreamEvent currentEvent = firstEvent;
        for (complexEvents = complexEvents.getNext(); complexEvents != null; complexEvents = complexEvents.getNext()) {
            StreamEvent nextEvent = this.streamEventFactory.newInstance();
            this.convertComplexEvent(complexEvents, nextEvent, e);
            currentEvent.setNext(nextEvent);
            currentEvent = nextEvent;
        }
        return firstEvent;
    }

    public StreamEvent convert(Event[] events, Exception e) {
        StreamEvent firstEvent = this.streamEventFactory.newInstance();
        this.convertEvent(events[0], firstEvent, e);
        StreamEvent currentEvent = firstEvent;
        int eventsLength = events.length;
        for (int i = 1; i < eventsLength; ++i) {
            StreamEvent nextEvent = this.streamEventFactory.newInstance();
            this.convertEvent(events[i], nextEvent, e);
            currentEvent.setNext(nextEvent);
            currentEvent = nextEvent;
        }
        return firstEvent;
    }

    public StreamEvent convert(List<Event> events, Exception e) {
        StreamEvent firstEvent = this.streamEventFactory.newInstance();
        this.convertEvent(events.get(0), firstEvent, e);
        StreamEvent currentEvent = firstEvent;
        int eventsLength = events.size();
        for (int i = 1; i < eventsLength; ++i) {
            StreamEvent nextEvent = this.streamEventFactory.newInstance();
            this.convertEvent(events.get(i), nextEvent, e);
            currentEvent.setNext(nextEvent);
            currentEvent = nextEvent;
        }
        return firstEvent;
    }

    private void convertData(long timestamp, Object[] data, ComplexEvent.Type type, StreamEvent newEvent, Exception e) {
        System.arraycopy(data, 0, newEvent.getOutputData(), 0, data.length);
        newEvent.setOutputData(e, data.length);
        newEvent.setType(type);
        newEvent.setTimestamp(timestamp);
    }

    private void convertEvent(Event event, StreamEvent newEvent, Exception e) {
        this.convertData(event.getTimestamp(), event.getData(), event.isExpired() ? ComplexEvent.Type.EXPIRED : ComplexEvent.Type.CURRENT, newEvent, e);
    }

    private void convertComplexEvent(ComplexEvent complexEvent, StreamEvent newEvent, Exception e) {
        this.convertData(complexEvent.getTimestamp(), complexEvent.getOutputData(), complexEvent.getType(), newEvent, e);
    }

    private void convertData(long timeStamp, Object[] data, StreamEvent newEvent, Exception e) {
        this.convertData(timeStamp, data, ComplexEvent.Type.CURRENT, newEvent, e);
    }
}

