/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.callback;

import io.siddhi.core.debugger.SiddhiDebugger;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.event.stream.converter.StreamEventConverter;
import io.siddhi.core.query.output.callback.OutputCallback;
import io.siddhi.core.table.Table;
import io.siddhi.query.api.definition.StreamDefinition;

public class InsertIntoTableCallback
extends OutputCallback {
    private Table table;
    private StreamDefinition outputStreamDefinition;
    private boolean convertToStreamEvent;
    private StreamEventFactory streamEventFactory;
    private StreamEventConverter streamEventConverter;

    public InsertIntoTableCallback(Table table, StreamDefinition outputStreamDefinition, boolean convertToStreamEvent, StreamEventFactory streamEventFactory, StreamEventConverter streamEventConverter, String queryName) {
        super(queryName);
        this.table = table;
        this.outputStreamDefinition = outputStreamDefinition;
        this.convertToStreamEvent = convertToStreamEvent;
        this.streamEventFactory = streamEventFactory;
        this.streamEventConverter = streamEventConverter;
    }

    @Override
    public void send(ComplexEventChunk complexEventChunk, int noOfEvents) {
        if (this.getSiddhiDebugger() != null) {
            this.getSiddhiDebugger().checkBreakPoint(this.getQueryName(), SiddhiDebugger.QueryTerminal.OUT, (ComplexEvent)complexEventChunk.getFirst());
        }
        if (this.convertToStreamEvent) {
            ComplexEventChunk<StreamEvent> streamEventChunk = new ComplexEventChunk<StreamEvent>(complexEventChunk.isBatch());
            complexEventChunk.reset();
            while (complexEventChunk.hasNext()) {
                Object complexEvent = complexEventChunk.next();
                StreamEvent borrowEvent = this.streamEventFactory.newInstance();
                this.streamEventConverter.convertData(complexEvent.getTimestamp(), complexEvent.getOutputData(), complexEvent.getType(), borrowEvent);
                streamEventChunk.add(borrowEvent);
            }
            this.table.addEvents(streamEventChunk, noOfEvents);
        } else {
            this.table.addEvents(complexEventChunk, noOfEvents);
        }
    }

    public StreamDefinition getOutputStreamDefinition() {
        return this.outputStreamDefinition;
    }
}

