/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.GroupedComplexEvent;
import io.siddhi.core.event.state.populater.StateEventPopulator;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.executor.condition.ConditionExpressionExecutor;
import io.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.selector.GroupByKeyGenerator;
import io.siddhi.core.query.selector.OrderByEventComparator;
import io.siddhi.core.query.selector.attribute.processor.AttributeProcessor;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.execution.query.selection.Selector;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class QuerySelector
implements Processor {
    private static final Logger log = Logger.getLogger(QuerySelector.class);
    private Selector selector;
    private SiddhiQueryContext siddhiQueryContext;
    private boolean currentOn = false;
    private boolean expiredOn = false;
    private boolean containsAggregator = false;
    private OutputRateLimiter outputRateLimiter;
    private List<AttributeProcessor> attributeProcessorList;
    private ConditionExpressionExecutor havingConditionExecutor = null;
    private boolean isGroupBy = false;
    private GroupByKeyGenerator groupByKeyGenerator;
    private boolean isOrderBy = false;
    private OrderByEventComparator orderByEventComparator;
    private String id;
    private StateEventPopulator eventPopulator;
    private boolean batchingEnabled = true;
    private long limit = -1L;
    private long offset = -1L;

    public QuerySelector(String id, Selector selector, boolean currentOn, boolean expiredOn, SiddhiQueryContext siddhiQueryContext) {
        this.id = id;
        this.currentOn = currentOn;
        this.expiredOn = expiredOn;
        this.selector = selector;
        this.siddhiQueryContext = siddhiQueryContext;
    }

    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("event is processed by selector " + this.id + this));
        }
        ComplexEventChunk outputComplexEventChunk = null;
        outputComplexEventChunk = complexEventChunk.isBatch() && this.batchingEnabled ? (this.isGroupBy ? this.processInBatchGroupBy(complexEventChunk) : (this.containsAggregator ? this.processInBatchNoGroupBy(complexEventChunk) : this.processNoGroupBy(complexEventChunk))) : (this.isGroupBy ? this.processGroupBy(complexEventChunk) : this.processNoGroupBy(complexEventChunk));
        if (outputComplexEventChunk != null) {
            this.outputRateLimiter.process(outputComplexEventChunk);
        }
    }

    public ComplexEventChunk execute(ComplexEventChunk complexEventChunk) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("event is executed by selector " + this.id + this));
        }
        if (complexEventChunk.isBatch() && this.batchingEnabled) {
            if (this.isGroupBy) {
                return this.processInBatchGroupBy(complexEventChunk);
            }
            if (this.containsAggregator) {
                return this.processInBatchNoGroupBy(complexEventChunk);
            }
            return this.processNoGroupBy(complexEventChunk);
        }
        if (this.isGroupBy) {
            return this.processGroupBy(complexEventChunk);
        }
        return this.processNoGroupBy(complexEventChunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private ComplexEventChunk processNoGroupBy(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        QuerySelector querySelector = this;
        // MONITORENTER : querySelector
        block7: while (complexEventChunk.hasNext()) {
            Object event = complexEventChunk.next();
            switch (event.getType()) {
                case CURRENT: 
                case EXPIRED: {
                    this.eventPopulator.populateStateEvent((ComplexEvent)event);
                    for (AttributeProcessor attributeProcessor : this.attributeProcessorList) {
                        attributeProcessor.process((ComplexEvent)event);
                    }
                    if ((event.getType() == ComplexEvent.Type.CURRENT && this.currentOn || event.getType() == ComplexEvent.Type.EXPIRED && this.expiredOn) && (this.havingConditionExecutor == null || this.havingConditionExecutor.execute((ComplexEvent)event).booleanValue())) break;
                    complexEventChunk.remove();
                    break;
                }
                case RESET: {
                    for (AttributeProcessor attributeProcessor : this.attributeProcessorList) {
                        attributeProcessor.process((ComplexEvent)event);
                    }
                    continue block7;
                }
                case TIMER: {
                    complexEventChunk.remove();
                    continue block7;
                }
            }
        }
        // MONITOREXIT : querySelector
        if (this.isOrderBy) {
            this.orderEventChunk(complexEventChunk);
        }
        if (this.offset != -1L) {
            this.offsetEventChunk(complexEventChunk);
        }
        if (this.limit != -1L) {
            this.limitEventChunk(complexEventChunk);
        }
        complexEventChunk.reset();
        if (!complexEventChunk.hasNext()) return null;
        return complexEventChunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComplexEventChunk<ComplexEvent> processGroupBy(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        ComplexEventChunk<ComplexEvent> currentComplexEventChunk = new ComplexEventChunk<ComplexEvent>(complexEventChunk.isBatch());
        QuerySelector querySelector = this;
        synchronized (querySelector) {
            int limitCount = 0;
            block11: while (complexEventChunk.hasNext()) {
                Object event = complexEventChunk.next();
                switch (event.getType()) {
                    case CURRENT: 
                    case EXPIRED: {
                        this.eventPopulator.populateStateEvent((ComplexEvent)event);
                        String groupByKey = this.groupByKeyGenerator.constructEventKey((ComplexEvent)event);
                        SiddhiAppContext.startGroupByFlow(groupByKey);
                        try {
                            for (AttributeProcessor attributeProcessor : this.attributeProcessorList) {
                                attributeProcessor.process((ComplexEvent)event);
                            }
                            if ((event.getType() != ComplexEvent.Type.CURRENT || !this.currentOn) && (event.getType() != ComplexEvent.Type.EXPIRED || !this.expiredOn) || this.havingConditionExecutor != null && !this.havingConditionExecutor.execute((ComplexEvent)event).booleanValue()) continue block11;
                            complexEventChunk.remove();
                            if (this.limit == -1L) {
                                currentComplexEventChunk.add(new GroupedComplexEvent(groupByKey, (ComplexEvent)event));
                                continue block11;
                            }
                            if ((long)limitCount >= this.limit) continue block11;
                            currentComplexEventChunk.add(new GroupedComplexEvent(groupByKey, (ComplexEvent)event));
                            ++limitCount;
                            continue block11;
                        }
                        finally {
                            SiddhiAppContext.stopGroupByFlow();
                            continue block11;
                        }
                    }
                    case TIMER: {
                        break;
                    }
                    case RESET: {
                        for (AttributeProcessor attributeProcessor : this.attributeProcessorList) {
                            attributeProcessor.process((ComplexEvent)event);
                        }
                        break;
                    }
                }
            }
        }
        if (this.isOrderBy) {
            this.orderEventChunk(complexEventChunk);
        }
        if (this.offset != -1L) {
            this.offsetEventChunk(complexEventChunk);
        }
        if (this.limit != -1L) {
            this.limitEventChunk(complexEventChunk);
        }
        currentComplexEventChunk.reset();
        if (currentComplexEventChunk.hasNext()) {
            return currentComplexEventChunk;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComplexEventChunk processInBatchNoGroupBy(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        Object lastEvent = null;
        QuerySelector querySelector = this;
        synchronized (querySelector) {
            while (complexEventChunk.hasNext()) {
                Object event = complexEventChunk.next();
                switch (event.getType()) {
                    case CURRENT: 
                    case EXPIRED: {
                        this.eventPopulator.populateStateEvent((ComplexEvent)event);
                        for (AttributeProcessor attributeProcessor : this.attributeProcessorList) {
                            attributeProcessor.process((ComplexEvent)event);
                        }
                        if (this.havingConditionExecutor != null && !this.havingConditionExecutor.execute((ComplexEvent)event).booleanValue() || (event.getType() != ComplexEvent.Type.CURRENT || !this.currentOn) && (event.getType() != ComplexEvent.Type.EXPIRED || !this.expiredOn)) break;
                        complexEventChunk.remove();
                        lastEvent = event;
                        break;
                    }
                    case TIMER: {
                        break;
                    }
                    case RESET: {
                        for (AttributeProcessor attributeProcessor : this.attributeProcessorList) {
                            attributeProcessor.process((ComplexEvent)event);
                        }
                        break;
                    }
                }
            }
        }
        if (lastEvent != null) {
            complexEventChunk.clear();
            if (!(this.offset != -1L && this.offset != 0L || this.limit != -1L && this.limit <= 0L)) {
                complexEventChunk.add(lastEvent);
            }
            return complexEventChunk;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComplexEventChunk processInBatchGroupBy(ComplexEventChunk complexEventChunk) {
        LinkedHashMap<String, Object> groupedEvents = new LinkedHashMap<String, Object>();
        complexEventChunk.reset();
        QuerySelector querySelector = this;
        synchronized (querySelector) {
            block11: while (complexEventChunk.hasNext()) {
                Object object = complexEventChunk.next();
                switch (object.getType()) {
                    case CURRENT: 
                    case EXPIRED: {
                        this.eventPopulator.populateStateEvent((ComplexEvent)object);
                        String groupByKey = this.groupByKeyGenerator.constructEventKey((ComplexEvent)object);
                        SiddhiAppContext.startGroupByFlow(groupByKey);
                        try {
                            for (AttributeProcessor attributeProcessor : this.attributeProcessorList) {
                                attributeProcessor.process((ComplexEvent)object);
                            }
                            if (this.havingConditionExecutor != null && !this.havingConditionExecutor.execute((ComplexEvent)object).booleanValue() || (object.getType() != ComplexEvent.Type.CURRENT || !this.currentOn) && (object.getType() != ComplexEvent.Type.EXPIRED || !this.expiredOn)) continue block11;
                            complexEventChunk.remove();
                            groupedEvents.put(groupByKey, object);
                            continue block11;
                        }
                        finally {
                            SiddhiAppContext.stopGroupByFlow();
                            continue block11;
                        }
                    }
                    case TIMER: {
                        break;
                    }
                    case RESET: {
                        for (AttributeProcessor attributeProcessor : this.attributeProcessorList) {
                            attributeProcessor.process((ComplexEvent)object);
                        }
                        break;
                    }
                }
            }
        }
        if (groupedEvents.size() != 0) {
            complexEventChunk.clear();
            for (Map.Entry entry : groupedEvents.entrySet()) {
                complexEventChunk.add(new GroupedComplexEvent((String)entry.getKey(), (ComplexEvent)entry.getValue()));
            }
            if (this.isOrderBy) {
                this.orderEventChunk(complexEventChunk);
            }
            if (this.offset != -1L) {
                this.offsetEventChunk(complexEventChunk);
            }
            if (this.limit != -1L) {
                this.limitEventChunk(complexEventChunk);
            }
            complexEventChunk.reset();
            return complexEventChunk;
        }
        return null;
    }

    @Override
    public Processor getNextProcessor() {
        return null;
    }

    @Override
    public void setNextProcessor(Processor processor) {
    }

    public void setNextProcessor(OutputRateLimiter outputRateLimiter) {
        if (this.outputRateLimiter != null) {
            throw new SiddhiAppCreationException("outputRateLimiter is already assigned");
        }
        this.outputRateLimiter = outputRateLimiter;
    }

    @Override
    public void setToLast(Processor processor) {
        if (this.getNextProcessor() == null) {
            this.setNextProcessor(processor);
        } else {
            this.getNextProcessor().setToLast(processor);
        }
    }

    public List<AttributeProcessor> getAttributeProcessorList() {
        return this.attributeProcessorList;
    }

    public void setAttributeProcessorList(List<AttributeProcessor> attributeProcessorList, boolean containsAggregator) {
        this.attributeProcessorList = attributeProcessorList;
        this.containsAggregator = this.containsAggregator || containsAggregator;
    }

    public void setGroupByKeyGenerator(GroupByKeyGenerator groupByKeyGenerator) {
        this.isGroupBy = true;
        this.groupByKeyGenerator = groupByKeyGenerator;
    }

    public void setOrderByEventComparator(OrderByEventComparator orderByEventComparator) {
        this.isOrderBy = true;
        this.orderByEventComparator = orderByEventComparator;
    }

    public void setHavingConditionExecutor(ConditionExpressionExecutor havingConditionExecutor, boolean containsAggregator) {
        this.havingConditionExecutor = havingConditionExecutor;
        this.containsAggregator = this.containsAggregator || containsAggregator;
    }

    public void setBatchingEnabled(boolean batchingEnabled) {
        this.batchingEnabled = batchingEnabled;
    }

    public void setEventPopulator(StateEventPopulator eventPopulator) {
        this.eventPopulator = eventPopulator;
    }

    public void setLimit(long limit) {
        if (limit < 0L) {
            throw new SiddhiAppCreationException("'limit' cannot have negative value, but found '" + limit + "'", (SiddhiElement)this.selector, this.siddhiQueryContext.getSiddhiAppContext());
        }
        this.limit = limit;
    }

    public void setOffset(long offset) {
        if (offset < 0L) {
            throw new SiddhiAppCreationException("'offset' cannot have negative value, but found '" + offset + "'", (SiddhiElement)this.selector, this.siddhiQueryContext.getSiddhiAppContext());
        }
        this.offset = offset;
    }

    private void orderEventChunk(ComplexEventChunk complexEventChunk) {
        ComplexEventChunk<ComplexEvent> orderingComplexEventChunk = new ComplexEventChunk<ComplexEvent>(complexEventChunk.isBatch());
        ArrayList<Object> eventList = new ArrayList<Object>();
        ComplexEvent.Type currentEventType = null;
        complexEventChunk.reset();
        if (complexEventChunk.getFirst() != null) {
            currentEventType = complexEventChunk.getFirst().getType();
            while (complexEventChunk.hasNext()) {
                Object event = complexEventChunk.next();
                complexEventChunk.remove();
                if (currentEventType == event.getType()) {
                    eventList.add(event);
                    continue;
                }
                currentEventType = event.getType();
                eventList.sort(this.orderByEventComparator);
                for (ComplexEvent complexEvent : eventList) {
                    orderingComplexEventChunk.add(complexEvent);
                }
                eventList.clear();
                eventList.add(event);
            }
            eventList.sort(this.orderByEventComparator);
            for (ComplexEvent complexEvent : eventList) {
                orderingComplexEventChunk.add(complexEvent);
            }
            complexEventChunk.clear();
            complexEventChunk.add(orderingComplexEventChunk.getFirst());
        }
    }

    private void limitEventChunk(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        int limitCount = 0;
        while (complexEventChunk.hasNext()) {
            Object event = complexEventChunk.next();
            if (event.getType() != ComplexEvent.Type.CURRENT && event.getType() != ComplexEvent.Type.EXPIRED) continue;
            if (this.limit > (long)limitCount && event.getType() == ComplexEvent.Type.CURRENT && this.currentOn || event.getType() == ComplexEvent.Type.EXPIRED && this.expiredOn) {
                ++limitCount;
                continue;
            }
            complexEventChunk.remove();
        }
    }

    private void offsetEventChunk(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        int offsetCount = 0;
        while (complexEventChunk.hasNext()) {
            Object event = complexEventChunk.next();
            if (event.getType() != ComplexEvent.Type.CURRENT && event.getType() != ComplexEvent.Type.EXPIRED) continue;
            if (this.offset <= (long)offsetCount) break;
            if (event.getType() == ComplexEvent.Type.CURRENT && this.currentOn || event.getType() == ComplexEvent.Type.EXPIRED && this.expiredOn) {
                ++offsetCount;
            }
            complexEventChunk.remove();
        }
    }
}

