/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.aggregator;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregatorExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import java.util.HashMap;
import java.util.Map;

@Extension(name="count", namespace="", description="Returns the count of all the events.", parameters={}, returnAttributes={@ReturnAttribute(description="Returns the event count as a long.", type={DataType.LONG})}, examples={@Example(syntax="from fooStream#window.timeBatch(10 sec)\nselect count() as count\ninsert into barStream;", description="This will return the count of all the events for time batch in 10 seconds.")})
public class CountAttributeAggregatorExecutor
extends AttributeAggregatorExecutor<AggregatorState> {
    private static Attribute.Type type = Attribute.Type.LONG;

    @Override
    protected StateFactory<AggregatorState> init(ExpressionExecutor[] attributeExpressionExecutors, ProcessingMode processingMode, boolean outputExpectsExpiredEvents, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        return () -> new AggregatorState();
    }

    @Override
    public Attribute.Type getReturnType() {
        return type;
    }

    @Override
    public Object processAdd(Object data, AggregatorState state) {
        state.count++;
        return state.count;
    }

    @Override
    public Object processAdd(Object[] data, AggregatorState state) {
        state.count++;
        return state.count;
    }

    @Override
    public Object processRemove(Object data, AggregatorState state) {
        state.count--;
        return state.count;
    }

    @Override
    public Object processRemove(Object[] data, AggregatorState state) {
        state.count--;
        return state.count;
    }

    @Override
    public Object reset(AggregatorState state) {
        state.count = 0L;
        return state.count;
    }

    class AggregatorState
    extends State {
        private long count = 0L;

        AggregatorState() {
        }

        @Override
        public boolean canDestroy() {
            return this.count == 0L;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("Count", this.count);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.count = (Long)state.get("Count");
        }
    }
}

