/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util;

import io.siddhi.core.SiddhiAppRuntime;
import io.siddhi.core.aggregation.AggregationRuntime;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.partition.PartitionRuntime;
import io.siddhi.core.query.QueryRuntime;
import io.siddhi.core.query.input.ProcessStreamReceiver;
import io.siddhi.core.query.input.stream.StreamRuntime;
import io.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import io.siddhi.core.query.output.callback.InsertIntoStreamCallback;
import io.siddhi.core.query.output.callback.InsertIntoWindowCallback;
import io.siddhi.core.query.output.callback.OutputCallback;
import io.siddhi.core.stream.StreamJunction;
import io.siddhi.core.stream.input.InputManager;
import io.siddhi.core.stream.input.source.Source;
import io.siddhi.core.stream.output.sink.Sink;
import io.siddhi.core.table.Table;
import io.siddhi.core.trigger.Trigger;
import io.siddhi.core.util.ExceptionUtil;
import io.siddhi.core.util.lock.LockSynchronizer;
import io.siddhi.core.util.parser.AggregationParser;
import io.siddhi.core.util.parser.helper.DefinitionParserHelper;
import io.siddhi.core.window.Window;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.AggregationDefinition;
import io.siddhi.query.api.definition.FunctionDefinition;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.definition.TableDefinition;
import io.siddhi.query.api.definition.TriggerDefinition;
import io.siddhi.query.api.definition.WindowDefinition;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SiddhiAppRuntimeBuilder {
    private ConcurrentMap<String, AbstractDefinition> streamDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private ConcurrentMap<String, AbstractDefinition> tableDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private ConcurrentMap<String, AbstractDefinition> windowDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private ConcurrentMap<String, AbstractDefinition> aggregationDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private ConcurrentMap<String, TriggerDefinition> triggerDefinitionMap = new ConcurrentHashMap<String, TriggerDefinition>();
    private Map<String, QueryRuntime> queryProcessorMap = Collections.synchronizedMap(new LinkedHashMap());
    private ConcurrentMap<String, StreamJunction> streamJunctionMap = new ConcurrentHashMap<String, StreamJunction>();
    private ConcurrentMap<String, List<Source>> sourceMap = new ConcurrentHashMap<String, List<Source>>();
    private ConcurrentMap<String, List<Sink>> sinkMap = new ConcurrentHashMap<String, List<Sink>>();
    private ConcurrentMap<String, Table> tableMap = new ConcurrentHashMap<String, Table>();
    private ConcurrentMap<String, Window> windowMap = new ConcurrentHashMap<String, Window>();
    private ConcurrentMap<String, AggregationRuntime> aggregationMap = new ConcurrentHashMap<String, AggregationRuntime>();
    private ConcurrentMap<String, Trigger> triggerMap = new ConcurrentHashMap<String, Trigger>();
    private ConcurrentMap<String, PartitionRuntime> partitionMap = new ConcurrentHashMap<String, PartitionRuntime>();
    private ConcurrentMap<String, SiddhiAppRuntime> siddhiAppRuntimeMap = null;
    private SiddhiAppContext siddhiAppContext;
    private InputManager inputManager;
    private LockSynchronizer lockSynchronizer = new LockSynchronizer();

    public SiddhiAppRuntimeBuilder(SiddhiAppContext siddhiAppContext) {
        this.siddhiAppContext = siddhiAppContext;
        this.inputManager = new InputManager(this.siddhiAppContext, this.streamDefinitionMap, this.streamJunctionMap);
    }

    public void defineStream(StreamDefinition streamDefinition) {
        DefinitionParserHelper.validateDefinition((AbstractDefinition)streamDefinition, this.streamDefinitionMap, this.tableDefinitionMap, this.windowDefinitionMap, this.aggregationDefinitionMap);
        AbstractDefinition currentDefinition = this.streamDefinitionMap.putIfAbsent(streamDefinition.getId(), (AbstractDefinition)streamDefinition);
        if (currentDefinition != null) {
            streamDefinition = (StreamDefinition)currentDefinition;
        }
        try {
            DefinitionParserHelper.addStreamJunction(streamDefinition, this.streamJunctionMap, this.siddhiAppContext);
        }
        catch (Throwable t) {
            ExceptionUtil.populateQueryContext(t, (SiddhiElement)streamDefinition, this.siddhiAppContext);
            throw t;
        }
        DefinitionParserHelper.addEventSource(streamDefinition, this.sourceMap, this.siddhiAppContext);
        DefinitionParserHelper.addEventSink(streamDefinition, this.sinkMap, this.siddhiAppContext);
    }

    public void defineTable(TableDefinition tableDefinition) {
        DefinitionParserHelper.validateDefinition((AbstractDefinition)tableDefinition, this.streamDefinitionMap, this.tableDefinitionMap, this.windowDefinitionMap, this.aggregationDefinitionMap);
        AbstractDefinition currentDefinition = this.tableDefinitionMap.putIfAbsent(tableDefinition.getId(), (AbstractDefinition)tableDefinition);
        if (currentDefinition != null) {
            tableDefinition = (TableDefinition)currentDefinition;
        }
        DefinitionParserHelper.addTable(tableDefinition, this.tableMap, this.siddhiAppContext);
    }

    public void defineWindow(WindowDefinition windowDefinition) {
        DefinitionParserHelper.validateDefinition((AbstractDefinition)windowDefinition, this.streamDefinitionMap, this.tableDefinitionMap, this.windowDefinitionMap, this.aggregationDefinitionMap);
        DefinitionParserHelper.addStreamJunction((StreamDefinition)windowDefinition, this.streamJunctionMap, this.siddhiAppContext);
        AbstractDefinition currentDefinition = this.windowDefinitionMap.putIfAbsent(windowDefinition.getId(), (AbstractDefinition)windowDefinition);
        if (currentDefinition != null) {
            windowDefinition = (WindowDefinition)currentDefinition;
        }
        DefinitionParserHelper.addWindow(windowDefinition, this.windowMap, this.siddhiAppContext);
    }

    public void defineTrigger(TriggerDefinition triggerDefinition) {
        DefinitionParserHelper.validateDefinition(triggerDefinition);
        TriggerDefinition currentDefinition = this.triggerDefinitionMap.putIfAbsent(triggerDefinition.getId(), triggerDefinition);
        if (currentDefinition != null) {
            triggerDefinition = currentDefinition;
        }
        DefinitionParserHelper.addEventTrigger(triggerDefinition, this.triggerMap, this.streamJunctionMap, this.siddhiAppContext);
    }

    public void defineAggregation(AggregationDefinition aggregationDefinition) {
        AggregationRuntime aggregationRuntime = AggregationParser.parse(aggregationDefinition, this.siddhiAppContext, this.streamDefinitionMap, this.tableDefinitionMap, this.windowDefinitionMap, this.aggregationDefinitionMap, this.tableMap, this.windowMap, this.aggregationMap, this);
        DefinitionParserHelper.validateDefinition((AbstractDefinition)aggregationDefinition, this.streamDefinitionMap, this.tableDefinitionMap, this.windowDefinitionMap, this.aggregationDefinitionMap);
        this.aggregationDefinitionMap.putIfAbsent(aggregationDefinition.getId(), (AbstractDefinition)aggregationDefinition);
        ProcessStreamReceiver processStreamReceiver = aggregationRuntime.getSingleStreamRuntime().getProcessStreamReceiver();
        ((StreamJunction)this.streamJunctionMap.get(processStreamReceiver.getStreamId())).subscribe(processStreamReceiver);
        this.aggregationMap.putIfAbsent(aggregationDefinition.getId(), aggregationRuntime);
    }

    public void addPartition(PartitionRuntime partitionRuntime) {
        this.partitionMap.put(partitionRuntime.getPartitionName(), partitionRuntime);
    }

    public String addQuery(QueryRuntime queryRuntime) {
        StreamJunction outputStreamJunction;
        StreamDefinition streamDefinition;
        QueryRuntime oldQueryRuntime = this.queryProcessorMap.put(queryRuntime.getQueryId(), queryRuntime);
        if (oldQueryRuntime != null) {
            throw new SiddhiAppCreationException("Multiple queries with name '" + queryRuntime.getQueryId() + "' defined in Siddhi App '" + this.siddhiAppContext.getName() + "'", queryRuntime.getQuery().getQueryContextStartIndex(), queryRuntime.getQuery().getQueryContextEndIndex());
        }
        StreamRuntime streamRuntime = queryRuntime.getStreamRuntime();
        for (SingleStreamRuntime singleStreamRuntime : streamRuntime.getSingleStreamRuntimes()) {
            ProcessStreamReceiver processStreamReceiver = singleStreamRuntime.getProcessStreamReceiver();
            if (!processStreamReceiver.toStream()) continue;
            StreamJunction streamJunction = (StreamJunction)this.streamJunctionMap.get(processStreamReceiver.getStreamId());
            if (streamJunction != null) {
                streamJunction.subscribe(processStreamReceiver);
                continue;
            }
            throw new SiddhiAppCreationException("Expecting a stream, but provided '" + processStreamReceiver.getStreamId() + "' is not a stream");
        }
        OutputCallback outputCallback = queryRuntime.getOutputCallback();
        if (outputCallback != null && outputCallback instanceof InsertIntoStreamCallback) {
            InsertIntoStreamCallback insertIntoStreamCallback = (InsertIntoStreamCallback)outputCallback;
            streamDefinition = insertIntoStreamCallback.getOutputStreamDefinition();
            this.streamDefinitionMap.putIfAbsent(streamDefinition.getId(), (AbstractDefinition)streamDefinition);
            DefinitionParserHelper.validateOutputStream(streamDefinition, (AbstractDefinition)this.streamDefinitionMap.get(streamDefinition.getId()));
            outputStreamJunction = (StreamJunction)this.streamJunctionMap.get(streamDefinition.getId());
            if (outputStreamJunction == null) {
                outputStreamJunction = new StreamJunction(streamDefinition, this.siddhiAppContext.getExecutorService(), this.siddhiAppContext.getBufferSize(), null, this.siddhiAppContext);
                this.streamJunctionMap.putIfAbsent(streamDefinition.getId(), outputStreamJunction);
            }
            insertIntoStreamCallback.init((StreamJunction)this.streamJunctionMap.get(insertIntoStreamCallback.getOutputStreamDefinition().getId()));
        } else if (outputCallback != null && outputCallback instanceof InsertIntoWindowCallback) {
            InsertIntoWindowCallback insertIntoWindowCallback = (InsertIntoWindowCallback)outputCallback;
            streamDefinition = insertIntoWindowCallback.getOutputStreamDefinition();
            this.windowDefinitionMap.putIfAbsent(streamDefinition.getId(), (AbstractDefinition)streamDefinition);
            DefinitionParserHelper.validateOutputStream(streamDefinition, (AbstractDefinition)this.windowDefinitionMap.get(streamDefinition.getId()));
            outputStreamJunction = (StreamJunction)this.streamJunctionMap.get(streamDefinition.getId());
            if (outputStreamJunction == null) {
                outputStreamJunction = new StreamJunction(streamDefinition, this.siddhiAppContext.getExecutorService(), this.siddhiAppContext.getBufferSize(), null, this.siddhiAppContext);
                this.streamJunctionMap.putIfAbsent(streamDefinition.getId(), outputStreamJunction);
            }
            insertIntoWindowCallback.getWindow().setPublisher(((StreamJunction)this.streamJunctionMap.get(insertIntoWindowCallback.getOutputStreamDefinition().getId())).constructPublisher());
        }
        return queryRuntime.getQueryId();
    }

    public void defineFunction(FunctionDefinition functionDefinition) {
        DefinitionParserHelper.addFunction(this.siddhiAppContext, functionDefinition);
    }

    public void setSiddhiAppRuntimeMap(ConcurrentMap<String, SiddhiAppRuntime> siddhiAppRuntimeMap) {
        this.siddhiAppRuntimeMap = siddhiAppRuntimeMap;
    }

    public ConcurrentMap<String, StreamJunction> getStreamJunctions() {
        return this.streamJunctionMap;
    }

    public ConcurrentMap<String, Table> getTableMap() {
        return this.tableMap;
    }

    public ConcurrentMap<String, Window> getWindowMap() {
        return this.windowMap;
    }

    public ConcurrentMap<String, AggregationRuntime> getAggregationMap() {
        return this.aggregationMap;
    }

    public ConcurrentMap<String, AbstractDefinition> getStreamDefinitionMap() {
        return this.streamDefinitionMap;
    }

    public ConcurrentMap<String, AbstractDefinition> getTableDefinitionMap() {
        return this.tableDefinitionMap;
    }

    public ConcurrentMap<String, List<Source>> getSourceMap() {
        return this.sourceMap;
    }

    public ConcurrentMap<String, List<Sink>> getSinkMap() {
        return this.sinkMap;
    }

    public ConcurrentMap<String, AbstractDefinition> getWindowDefinitionMap() {
        return this.windowDefinitionMap;
    }

    public ConcurrentMap<String, AbstractDefinition> getAggregationDefinitionMap() {
        return this.aggregationDefinitionMap;
    }

    public LockSynchronizer getLockSynchronizer() {
        return this.lockSynchronizer;
    }

    public SiddhiAppRuntime build() {
        return new SiddhiAppRuntime(this.streamDefinitionMap, this.tableDefinitionMap, this.windowDefinitionMap, this.aggregationDefinitionMap, this.inputManager, this.queryProcessorMap, this.streamJunctionMap, this.tableMap, this.windowMap, this.aggregationMap, this.sourceMap, this.sinkMap, this.partitionMap, this.siddhiAppContext, this.siddhiAppRuntimeMap);
    }
}

