/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.executor.function;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import org.apache.log4j.Logger;

@Extension(name="ifThenElse", namespace="", description="Evaluates the 'condition' parameter and returns value of the 'if.expression' parameter if the condition is true, or returns value of the 'else.expression' parameter if the condition is false. Here both 'if.expression' and 'else.expression' should be of the same type.", parameters={@Parameter(name="condition", description="This specifies the if then else condition value.", type={DataType.BOOL}), @Parameter(name="if.expression", description="This specifies the value to be returned if the value of the condition parameter is true.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING, DataType.BOOL, DataType.OBJECT}), @Parameter(name="else.expression", description="This specifies the value to be returned if the value of the condition parameter is false.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING, DataType.BOOL, DataType.OBJECT})}, returnAttributes={@ReturnAttribute(description="Returned type will be same as the 'if.expression' and 'else.expression' type.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING, DataType.BOOL, DataType.OBJECT})}, examples={@Example(syntax="@info(name = 'query1')\nfrom sensorEventStream\nselect sensorValue, ifThenElse(sensorValue>35,'High','Low') as status\ninsert into outputStream;", description="This will returns High if sensorValue = 50."), @Example(syntax="@info(name = 'query1')\nfrom sensorEventStream\nselect sensorValue, ifThenElse(voltage < 5, 0, 1) as status\ninsert into outputStream;", description="This will returns 1 if voltage= 12."), @Example(syntax="@info(name = 'query1')\nfrom userEventStream\nselect userName, ifThenElse(password == 'admin', true, false) as passwordState\ninsert into outputStream;", description="This will returns  passwordState as true if password = admin.")})
public class IfThenElseFunctionExecutor
extends FunctionExecutor {
    private static final Logger log = Logger.getLogger(IfThenElseFunctionExecutor.class);
    Attribute.Type returnType;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 3) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to ifThenElse() function, required only 3, but found " + attributeExpressionExecutors.length);
        }
        if (!attributeExpressionExecutors[0].getReturnType().equals((Object)Attribute.Type.BOOL)) {
            throw new SiddhiAppValidationException("Input type of if in ifThenElse function should be of type BOOL, but found " + attributeExpressionExecutors[0].getReturnType());
        }
        if (!attributeExpressionExecutors[1].getReturnType().equals((Object)attributeExpressionExecutors[2].getReturnType())) {
            throw new SiddhiAppValidationException("Input type of then in ifThenElse function and else in ifThenElse function should be of equivalent type. but found then type: " + attributeExpressionExecutors[1].getReturnType() + " and else type: " + attributeExpressionExecutors[2].getReturnType());
        }
        this.returnType = attributeExpressionExecutors[1].getReturnType();
        return null;
    }

    protected Object execute(Object[] data, State state) {
        if (Boolean.TRUE.equals(data[0])) {
            return data[1];
        }
        return data[2];
    }

    protected Object execute(Object data, State state) {
        return null;
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Object execute(ComplexEvent event) {
        try {
            Boolean condition = Boolean.TRUE.equals(this.attributeExpressionExecutors[0].execute(event));
            return this.execute(new Object[]{condition, condition != false ? this.attributeExpressionExecutors[1].execute(event) : null, condition == false ? this.attributeExpressionExecutors[2].execute(event) : null});
        }
        catch (Exception e) {
            throw new SiddhiAppRuntimeException(e.getMessage() + ". Exception on class '" + this.getClass().getName() + "'", e);
        }
    }
}

