/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.stream.output.sink;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.Event;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.stream.output.sink.OutputGroupDeterminer;
import io.siddhi.core.stream.output.sink.Sink;
import io.siddhi.core.stream.output.sink.SinkListener;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.statistics.LatencyTracker;
import io.siddhi.core.util.transport.DynamicOptions;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.core.util.transport.TemplateBuilder;
import io.siddhi.query.api.annotation.Element;
import io.siddhi.query.api.definition.StreamDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class SinkMapper {
    private String type;
    private SinkListener sinkListener;
    private OptionHolder optionHolder;
    private Map<String, TemplateBuilder> templateBuilderMap = null;
    private OutputGroupDeterminer groupDeterminer = null;
    private ThreadLocal<DynamicOptions> trpDynamicOptions = new ThreadLocal();
    private LatencyTracker mapperLatencyTracker;
    private SiddhiAppContext siddhiAppContext;

    public final void init(StreamDefinition streamDefinition, String type, OptionHolder mapOptionHolder, List<Element> unmappedPayloadList, Sink sink, ConfigReader mapperConfigReader, LatencyTracker mapperLatencyTracker, SiddhiAppContext siddhiAppContext) {
        this.mapperLatencyTracker = mapperLatencyTracker;
        this.siddhiAppContext = siddhiAppContext;
        sink.setTrpDynamicOptions(this.trpDynamicOptions);
        this.sinkListener = sink;
        this.optionHolder = mapOptionHolder;
        this.type = type;
        if (unmappedPayloadList != null && !unmappedPayloadList.isEmpty()) {
            this.templateBuilderMap = new HashMap<String, TemplateBuilder>();
            for (Element e : unmappedPayloadList) {
                TemplateBuilder templateBuilder = new TemplateBuilder(streamDefinition, e.getValue());
                if (this.templateBuilderMap.containsKey(e.getKey())) {
                    throw new SiddhiAppCreationException("Duplicate Keys, " + e.getKey() + ", in @payload() ");
                }
                this.templateBuilderMap.put(e.getKey(), templateBuilder);
            }
        }
        this.init(streamDefinition, mapOptionHolder, this.templateBuilderMap, mapperConfigReader, siddhiAppContext);
    }

    public abstract String[] getSupportedDynamicOptions();

    public abstract void init(StreamDefinition var1, OptionHolder var2, Map<String, TemplateBuilder> var3, ConfigReader var4, SiddhiAppContext var5);

    public abstract Class[] getOutputEventClasses();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void mapAndSend(Event[] events) {
        if (this.groupDeterminer != null) {
            LinkedHashMap<String, ArrayList> eventMap = new LinkedHashMap<String, ArrayList>();
            for (Event event : events) {
                String key = this.groupDeterminer.decideGroup(event);
                ArrayList eventList = eventMap.computeIfAbsent(key, k -> new ArrayList());
                eventList.add(event);
            }
            for (ArrayList eventList : eventMap.values()) {
                try {
                    this.trpDynamicOptions.set(new DynamicOptions((Event)eventList.get(0)));
                    if (this.mapperLatencyTracker != null && this.siddhiAppContext.isStatsEnabled()) {
                        this.mapperLatencyTracker.markIn();
                    }
                    this.mapAndSend(eventList.toArray(new Event[eventList.size()]), this.optionHolder, this.templateBuilderMap, this.sinkListener);
                }
                finally {
                    this.trpDynamicOptions.remove();
                    if (this.mapperLatencyTracker == null || !this.siddhiAppContext.isStatsEnabled()) continue;
                    this.mapperLatencyTracker.markOut();
                }
            }
        } else {
            try {
                this.trpDynamicOptions.set(new DynamicOptions(events[0]));
                if (this.mapperLatencyTracker != null && this.siddhiAppContext.isStatsEnabled()) {
                    this.mapperLatencyTracker.markIn();
                }
                this.mapAndSend(events, this.optionHolder, this.templateBuilderMap, this.sinkListener);
            }
            finally {
                this.trpDynamicOptions.remove();
                if (this.mapperLatencyTracker != null && this.siddhiAppContext.isStatsEnabled()) {
                    this.mapperLatencyTracker.markOut();
                }
            }
        }
    }

    final void mapAndSend(Event event) {
        try {
            this.trpDynamicOptions.set(new DynamicOptions(event));
            this.mapAndSend(event, this.optionHolder, this.templateBuilderMap, this.sinkListener);
        }
        finally {
            this.trpDynamicOptions.remove();
        }
    }

    public abstract void mapAndSend(Event[] var1, OptionHolder var2, Map<String, TemplateBuilder> var3, SinkListener var4);

    public abstract void mapAndSend(Event var1, OptionHolder var2, Map<String, TemplateBuilder> var3, SinkListener var4);

    public final String getType() {
        return this.type;
    }

    public final void setGroupDeterminer(OutputGroupDeterminer groupDeterminer) {
        this.groupDeterminer = groupDeterminer;
    }
}

