/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.trigger;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.Event;
import io.siddhi.core.stream.StreamJunction;
import io.siddhi.core.trigger.Trigger;
import io.siddhi.core.util.parser.helper.QueryParserHelper;
import io.siddhi.core.util.statistics.ThroughputTracker;
import io.siddhi.query.api.definition.TriggerDefinition;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class PeriodicTrigger
implements Trigger {
    private TriggerDefinition triggerDefinition;
    private SiddhiAppContext siddhiAppContext;
    private StreamJunction streamJunction;
    private ScheduledFuture scheduledFuture;
    private ThroughputTracker throughputTracker;

    @Override
    public void init(TriggerDefinition triggerDefinition, SiddhiAppContext siddhiAppContext, StreamJunction streamJunction) {
        this.triggerDefinition = triggerDefinition;
        this.siddhiAppContext = siddhiAppContext;
        this.streamJunction = streamJunction;
        if (siddhiAppContext.getStatisticsManager() != null) {
            this.throughputTracker = QueryParserHelper.createThroughputTracker(siddhiAppContext, triggerDefinition.getId(), "Trigger", null);
        }
    }

    @Override
    public TriggerDefinition getTriggerDefinition() {
        return this.triggerDefinition;
    }

    @Override
    public String getId() {
        return this.triggerDefinition.getId();
    }

    @Override
    public void start() {
        this.scheduledFuture = this.siddhiAppContext.getScheduledExecutorService().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long currentTime = PeriodicTrigger.this.siddhiAppContext.getTimestampGenerator().currentTime();
                if (PeriodicTrigger.this.throughputTracker != null && PeriodicTrigger.this.siddhiAppContext.isStatsEnabled()) {
                    PeriodicTrigger.this.throughputTracker.eventIn();
                }
                PeriodicTrigger.this.streamJunction.sendEvent(new Event(currentTime, new Object[]{currentTime}));
            }
        }, this.triggerDefinition.getAtEvery(), this.triggerDefinition.getAtEvery(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }
}

