/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.event.stream.holder;

import io.siddhi.core.event.stream.Operation;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.holder.StreamEventClonerHolder;
import io.siddhi.core.util.snapshot.SnapshotRequest;
import io.siddhi.core.util.snapshot.state.Snapshot;
import io.siddhi.core.util.snapshot.state.SnapshotStateList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;

public class SnapshotableStreamEventQueue
implements Iterator<StreamEvent>,
Serializable {
    private static final long serialVersionUID = 3185987841726255019L;
    protected StreamEvent first;
    protected StreamEvent previousToLastReturned;
    protected StreamEvent lastReturned;
    protected StreamEvent last;
    private int operationChangeLogThreshold;
    private transient StreamEventClonerHolder eventClonerHolder;
    private ArrayList<Operation> operationChangeLog = new ArrayList();
    private long operationChangeLogSize;
    private boolean forceFullSnapshot = true;
    private boolean isOperationLogEnabled = true;
    private int eventIndex = -1;

    public SnapshotableStreamEventQueue(StreamEventClonerHolder eventClonerHolder) {
        this(eventClonerHolder, Integer.MAX_VALUE);
    }

    public SnapshotableStreamEventQueue(StreamEventClonerHolder eventClonerHolder, int operationChangeLogThreshold) {
        this.eventClonerHolder = eventClonerHolder;
        this.operationChangeLogThreshold = operationChangeLogThreshold;
    }

    public void add(StreamEvent events) {
        if (!this.isFullSnapshot()) {
            if (this.isOperationLogEnabled) {
                this.operationChangeLog.add(new Operation(Operation.Operator.ADD, this.copyEvents(events)));
            }
            ++this.operationChangeLogSize;
        } else {
            this.operationChangeLog.clear();
            this.operationChangeLogSize = 0L;
            this.forceFullSnapshot = true;
        }
        if (this.first == null) {
            this.first = events;
        } else {
            this.last.setNext(events);
        }
        this.last = this.getLastEvent(events);
    }

    @Override
    public void remove() {
        if (this.lastReturned == null) {
            throw new IllegalStateException();
        }
        if (this.previousToLastReturned != null) {
            this.previousToLastReturned.setNext(this.lastReturned.getNext());
        } else {
            this.first = this.lastReturned.getNext();
            if (this.first == null) {
                this.last = null;
            }
        }
        this.lastReturned.setNext(null);
        this.lastReturned = null;
        if (!this.isFullSnapshot()) {
            if (this.isOperationLogEnabled) {
                this.operationChangeLog.add(new Operation(Operation.Operator.DELETE_BY_INDEX, this.eventIndex));
            }
            ++this.operationChangeLogSize;
        } else {
            this.operationChangeLog.clear();
            this.operationChangeLogSize = 0L;
            this.forceFullSnapshot = true;
        }
        --this.eventIndex;
    }

    private StreamEvent getLastEvent(StreamEvent complexEvents) {
        StreamEvent lastEvent;
        for (lastEvent = complexEvents; lastEvent != null && lastEvent.getNext() != null; lastEvent = lastEvent.getNext()) {
        }
        return lastEvent;
    }

    @Override
    public boolean hasNext() {
        if (this.lastReturned != null) {
            return this.lastReturned.getNext() != null;
        }
        if (this.previousToLastReturned != null) {
            return this.previousToLastReturned.getNext() != null;
        }
        return this.first != null;
    }

    @Override
    public StreamEvent next() {
        StreamEvent returnEvent;
        if (this.lastReturned != null) {
            returnEvent = this.lastReturned.getNext();
            this.previousToLastReturned = this.lastReturned;
        } else {
            returnEvent = this.previousToLastReturned != null ? this.previousToLastReturned.getNext() : this.first;
        }
        if (returnEvent == null) {
            throw new NoSuchElementException();
        }
        this.lastReturned = returnEvent;
        ++this.eventIndex;
        return returnEvent;
    }

    public void clear() {
        this.operationChangeLog.clear();
        this.operationChangeLogSize = 0L;
        this.forceFullSnapshot = true;
        this.previousToLastReturned = null;
        this.lastReturned = null;
        this.first = null;
        this.last = null;
        this.eventIndex = -1;
    }

    public void reset() {
        this.previousToLastReturned = null;
        this.lastReturned = null;
        this.eventIndex = -1;
    }

    public StreamEvent getFirst() {
        return this.first;
    }

    public StreamEvent getLast() {
        return this.last;
    }

    public StreamEvent poll() {
        this.reset();
        if (this.first != null) {
            StreamEvent firstEvent = this.first;
            this.first = this.first.getNext();
            firstEvent.setNext(null);
            if (!this.isFullSnapshot()) {
                if (this.isOperationLogEnabled) {
                    this.operationChangeLog.add(new Operation(Operation.Operator.REMOVE));
                }
                ++this.operationChangeLogSize;
            } else {
                this.operationChangeLog.clear();
                this.operationChangeLogSize = 0L;
                this.forceFullSnapshot = true;
            }
            return firstEvent;
        }
        return null;
    }

    public String toString() {
        return "EventQueue{first=" + this.first + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotableStreamEventQueue that = (SnapshotableStreamEventQueue)o;
        if (this.operationChangeLogThreshold != that.operationChangeLogThreshold) {
            return false;
        }
        if (this.operationChangeLogSize != that.operationChangeLogSize) {
            return false;
        }
        if (this.forceFullSnapshot != that.forceFullSnapshot) {
            return false;
        }
        if (this.isOperationLogEnabled != that.isOperationLogEnabled) {
            return false;
        }
        if (this.eventIndex != that.eventIndex) {
            return false;
        }
        if (this.first != null ? !this.first.equals(that.first) : that.first != null) {
            return false;
        }
        return this.operationChangeLog != null ? this.operationChangeLog.equals(that.operationChangeLog) : that.operationChangeLog == null;
    }

    public int hashCode() {
        int result = this.first != null ? this.first.hashCode() : 0;
        result = 31 * result + this.operationChangeLogThreshold;
        result = 31 * result + (this.operationChangeLog != null ? this.operationChangeLog.hashCode() : 0);
        result = 31 * result + (int)(this.operationChangeLogSize ^ this.operationChangeLogSize >>> 32);
        result = 31 * result + (this.forceFullSnapshot ? 1 : 0);
        result = 31 * result + (this.isOperationLogEnabled ? 1 : 0);
        result = 31 * result + this.eventIndex;
        return result;
    }

    public Snapshot getSnapshot() {
        if (this.isFullSnapshot()) {
            this.forceFullSnapshot = false;
            return new Snapshot(this.getFirst(), false);
        }
        Snapshot snapshot = new Snapshot(this.operationChangeLog, true);
        this.operationChangeLog = new ArrayList();
        return snapshot;
    }

    private boolean isFullSnapshot() {
        return this.operationChangeLogSize > 100L || this.operationChangeLogSize > (long)this.operationChangeLogThreshold || this.forceFullSnapshot || SnapshotRequest.isRequestForFullSnapshot();
    }

    public void restore(SnapshotStateList snapshotStatelist) {
        TreeMap<Long, Snapshot> revisions = snapshotStatelist.getSnapshotStates();
        Iterator<Map.Entry<Long, Snapshot>> itr = revisions.entrySet().iterator();
        this.isOperationLogEnabled = false;
        while (itr.hasNext()) {
            Map.Entry<Long, Snapshot> snapshotEntry = itr.next();
            if (!snapshotEntry.getValue().isIncrementalSnapshot()) {
                this.clear();
                this.add((StreamEvent)snapshotEntry.getValue().getState());
                this.forceFullSnapshot = false;
                continue;
            }
            ArrayList operations = (ArrayList)snapshotEntry.getValue().getState();
            block9: for (Operation op : operations) {
                switch (op.operation) {
                    case ADD: {
                        this.add((StreamEvent)op.parameters);
                        continue block9;
                    }
                    case REMOVE: {
                        this.poll();
                        continue block9;
                    }
                    case CLEAR: {
                        this.clear();
                        continue block9;
                    }
                    case OVERWRITE: {
                        int overwriteIndex = (Integer)((Object[])op.parameters)[0];
                        StreamEvent streamEvent = (StreamEvent)((Object[])op.parameters)[1];
                        while (this.hasNext()) {
                            this.next();
                            if (overwriteIndex != this.eventIndex) continue;
                            this.overwrite(streamEvent);
                            continue block9;
                        }
                        continue block9;
                    }
                    case DELETE_BY_OPERATOR: {
                        continue block9;
                    }
                    case DELETE_BY_INDEX: {
                        int deleteIndex = (Integer)op.parameters;
                        while (this.hasNext()) {
                            this.next();
                            if (deleteIndex != this.eventIndex) continue;
                            this.remove();
                            continue block9;
                        }
                        continue block9;
                    }
                }
            }
        }
        this.isOperationLogEnabled = true;
    }

    private StreamEvent copyEvents(StreamEvent events) {
        StreamEvent firstCopiedEvent;
        StreamEvent currentEvent = events;
        StreamEvent lastCopiedEvent = firstCopiedEvent = this.eventClonerHolder.getStreamEventCloner().copyStreamEvent(events);
        while (currentEvent.getNext() != null) {
            currentEvent = currentEvent.getNext();
            StreamEvent copiedStreamEvent = this.eventClonerHolder.getStreamEventCloner().copyStreamEvent(currentEvent);
            lastCopiedEvent.setNext(copiedStreamEvent);
            lastCopiedEvent = copiedStreamEvent;
        }
        return firstCopiedEvent;
    }

    public void overwrite(StreamEvent streamEvent) {
        if (!this.isFullSnapshot()) {
            if (this.isOperationLogEnabled) {
                this.operationChangeLog.add(new Operation(Operation.Operator.OVERWRITE, new Object[]{this.eventIndex, this.eventClonerHolder.getStreamEventCloner().copyStreamEvent(streamEvent)}));
            }
            ++this.operationChangeLogSize;
        } else {
            this.operationChangeLog.clear();
            this.operationChangeLogSize = 0L;
            this.forceFullSnapshot = true;
        }
        if (this.previousToLastReturned != null) {
            this.previousToLastReturned.setNext(streamEvent);
        } else {
            this.first = streamEvent;
        }
        StreamEvent next = this.lastReturned.getNext();
        if (next != null) {
            streamEvent.setNext(next);
        } else {
            this.last = streamEvent;
        }
        this.lastReturned = streamEvent;
    }
}

