/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.executor.incremental;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.HashMap;
import java.util.Map;

public class IncrementalShouldUpdateFunctionExecutor
extends FunctionExecutor<FunctionState> {
    @Override
    protected StateFactory<FunctionState> init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("shouldUpdate() function has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) {
            throw new OperationNotSupportedException("Parameter given for shouldUpdate() function has to be of type long, but found: " + attributeExpressionExecutors[0].getReturnType());
        }
        return () -> new FunctionState();
    }

    @Override
    protected Object execute(Object[] data, FunctionState state) {
        return null;
    }

    @Override
    protected Object execute(Object data, FunctionState state) {
        long timestamp = (Long)data;
        if (timestamp >= state.lastTimestamp) {
            state.lastTimestamp = timestamp;
            return true;
        }
        return false;
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.BOOL;
    }

    class FunctionState
    extends State {
        private long lastTimestamp = 0L;

        FunctionState() {
        }

        @Override
        public boolean canDestroy() {
            return this.lastTimestamp == 0L;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("lastTimestamp", this.lastTimestamp);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.lastTimestamp = (Long)state.get("lastTimestamp");
        }
    }
}

