/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.event;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class LastPerEventOutputRateLimiter
extends OutputRateLimiter<RateLimiterState> {
    private final Integer value;

    public LastPerEventOutputRateLimiter(String id, Integer value) {
        this.value = value;
    }

    @Override
    protected StateFactory<RateLimiterState> init() {
        return () -> new RateLimiterState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        ArrayList outputEventChunks = new ArrayList();
        RateLimiterState state = (RateLimiterState)this.stateHolder.getState();
        try {
            RateLimiterState rateLimiterState = state;
            synchronized (rateLimiterState) {
                while (complexEventChunk.hasNext()) {
                    Object object = complexEventChunk.next();
                    if (object.getType() != ComplexEvent.Type.CURRENT && object.getType() != ComplexEvent.Type.EXPIRED || ++state.counter != this.value) continue;
                    complexEventChunk.remove();
                    ComplexEventChunk<Object> lastPerEventChunk = new ComplexEventChunk<Object>(complexEventChunk.isBatch());
                    lastPerEventChunk.add(object);
                    state.counter = 0;
                    outputEventChunks.add(lastPerEventChunk);
                }
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    @Override
    public void partitionCreated() {
    }

    class RateLimiterState
    extends State {
        private volatile int counter = 0;

        RateLimiterState() {
        }

        @Override
        public boolean canDestroy() {
            return this.counter == 0;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("Counter", this.counter);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.counter = (Integer)state.get("Counter");
        }
    }
}

