/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.processor.stream.window;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.holder.SnapshotableStreamEventQueue;
import io.siddhi.core.event.stream.holder.StreamEventClonerHolder;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.processor.SchedulingProcessor;
import io.siddhi.core.query.processor.stream.window.SlidingFindableWindowProcessor;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.Scheduler;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.collection.operator.Operator;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.parser.OperatorParser;
import io.siddhi.core.util.snapshot.state.SnapshotStateList;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import io.siddhi.query.api.expression.Expression;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Extension(name="timeLength", namespace="", description="A sliding time window that, at a given time holds the last window.length events that arrived during last window.time period, and gets updated for every event arrival and expiry.", parameters={@Parameter(name="window.time", description="The sliding time period for which the window should hold events.", type={DataType.INT, DataType.LONG, DataType.TIME}), @Parameter(name="window.length", description="The number of events that should be be included in a sliding length window..", type={DataType.INT})}, examples={@Example(syntax="define stream cseEventStream (symbol string, price float, volume int);\ndefine window cseEventWindow (symbol string, price float, volume int) timeLength(2 sec, 10);\n@info(name = 'query0')\nfrom cseEventStream\ninsert into cseEventWindow;\n@info(name = 'query1')\nfrom cseEventWindow select symbol, price, volume\ninsert all events into outputStream;", description="window.timeLength(2 sec, 10) holds the last 10 events that arrived during last 2 seconds and gets updated for every event arrival and expiry.")})
public class TimeLengthWindowProcessor
extends SlidingFindableWindowProcessor<WindowState>
implements SchedulingProcessor {
    private long timeInMilliSeconds;
    private int length;
    private Scheduler scheduler;
    private SiddhiQueryContext siddhiQueryContext;

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        this.siddhiQueryContext = siddhiQueryContext;
        if (attributeExpressionExecutors.length != 2) throw new SiddhiAppValidationException("TimeLength window should only have two parameters (<int> windowTime,<int> windowLength), but found " + attributeExpressionExecutors.length + " input attributes");
        this.length = (Integer)((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue();
        if (!(attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor)) throw new SiddhiAppValidationException("TimeLength window should have constant parameter attributes but found a dynamic attribute " + attributeExpressionExecutors[0].getClass().getCanonicalName());
        if (attributeExpressionExecutors[0].getReturnType() == Attribute.Type.INT) {
            this.timeInMilliSeconds = ((Integer)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue()).intValue();
            return () -> new WindowState(this.streamEventClonerHolder);
        } else {
            if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) throw new SiddhiAppValidationException("TimeLength window's first parameter attribute should be either int or long, but found " + attributeExpressionExecutors[0].getReturnType());
            this.timeInMilliSeconds = (Long)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
        }
        return () -> new WindowState(this.streamEventClonerHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, WindowState state) {
        WindowState windowState = state;
        synchronized (windowState) {
            long currentTime = this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime();
            while (streamEventChunk.hasNext()) {
                StreamEvent expiredEvent;
                long timeDiff;
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                state.expiredEventQueue.reset();
                while (state.expiredEventQueue.hasNext() && (timeDiff = (expiredEvent = state.expiredEventQueue.next()).getTimestamp() - currentTime + this.timeInMilliSeconds) <= 0L) {
                    state.expiredEventQueue.remove();
                    state.count--;
                    expiredEvent.setTimestamp(currentTime);
                    streamEventChunk.insertBeforeCurrent(expiredEvent);
                }
                state.expiredEventQueue.reset();
                if (streamEvent.getType() == ComplexEvent.Type.CURRENT) {
                    StreamEvent clonedEvent = streamEventCloner.copyStreamEvent(streamEvent);
                    clonedEvent.setType(ComplexEvent.Type.EXPIRED);
                    if (state.count < this.length) {
                        state.count++;
                        state.expiredEventQueue.add(clonedEvent);
                    } else {
                        StreamEvent firstEvent = state.expiredEventQueue.poll();
                        if (firstEvent != null) {
                            firstEvent.setTimestamp(currentTime);
                            streamEventChunk.insertBeforeCurrent(firstEvent);
                            state.expiredEventQueue.add(clonedEvent);
                        }
                    }
                    this.scheduler.notifyAt(clonedEvent.getTimestamp() + this.timeInMilliSeconds);
                    continue;
                }
                streamEventChunk.remove();
            }
        }
        streamEventChunk.reset();
        if (streamEventChunk.hasNext()) {
            nextProcessor.process(streamEventChunk);
        }
    }

    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, WindowState state, SiddhiQueryContext siddhiQueryContext) {
        return OperatorParser.constructOperator(state.expiredEventQueue, condition, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition, StreamEventCloner streamEventCloner, WindowState state) {
        return ((Operator)compiledCondition).find(matchingEvent, state.expiredEventQueue, streamEventCloner);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }

    class WindowState
    extends State {
        private SnapshotableStreamEventQueue expiredEventQueue;
        private int count = 0;

        WindowState(StreamEventClonerHolder streamEventClonerHolder) {
            this.expiredEventQueue = new SnapshotableStreamEventQueue(streamEventClonerHolder);
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("ExpiredEventQueue", this.expiredEventQueue.getSnapshot());
            state.put("Count", this.count);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.expiredEventQueue.restore((SnapshotStateList)state.get("ExpiredEventQueue"));
            this.count = (Integer)state.get("ExpiredEventQueue");
        }

        @Override
        public boolean canDestroy() {
            return this.expiredEventQueue.getFirst() == null && this.count == 0;
        }
    }
}

