/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.aggregator.incremental;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.query.selector.attribute.aggregator.incremental.IncrementalAttributeAggregator;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.expression.Expression;

@Extension(name="min", namespace="incrementalAggregator", description="Returns the minimum value for all the events, in incremental event processing", parameters={@Parameter(name="arg", description="The value that needs to be compared to find the minimum value.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, returnAttributes={@ReturnAttribute(description="Returns the minimum value in the same data type as the input.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, examples={@Example(syntax=" define aggregation cseEventAggregation\n from cseEventStream\n select min(price) as minPrice,\n aggregate by timeStamp every sec ... hour;", description="min(price) returns the minimum price value for all the events based on their arrival and expiry. The minimum value is calculated for sec, min and hour durations.")})
public class MinIncrementalAttributeAggregator
extends IncrementalAttributeAggregator {
    private Attribute[] baseAttributes;
    private Expression[] baseAttributesInitialValues;
    private Attribute.Type returnType;

    @Override
    public void init(String attributeName, Attribute.Type attributeType) {
        if (attributeName == null) {
            throw new SiddhiAppCreationException("Min incremental attribute aggregation cannot be executed when no parameters are given");
        }
        if (!(attributeType.equals((Object)Attribute.Type.INT) || attributeType.equals((Object)Attribute.Type.LONG) || attributeType.equals((Object)Attribute.Type.DOUBLE) || attributeType.equals((Object)Attribute.Type.FLOAT))) {
            throw new SiddhiAppRuntimeException("Min aggregation cannot be executed on attribute type " + attributeType.toString());
        }
        this.baseAttributes = new Attribute[]{new Attribute("AGG_MIN_".concat(attributeName), attributeType)};
        this.baseAttributesInitialValues = new Expression[]{Expression.variable((String)attributeName)};
        this.returnType = attributeType;
    }

    @Override
    public Expression aggregate() {
        return Expression.variable((String)this.baseAttributes[0].getName());
    }

    @Override
    public Attribute[] getBaseAttributes() {
        return this.baseAttributes;
    }

    @Override
    public Expression[] getBaseAttributeInitialValues() {
        return this.baseAttributesInitialValues;
    }

    @Override
    public Expression[] getBaseAggregators() {
        Expression minAggregator = Expression.function((String)"min", (Expression[])new Expression[]{Expression.variable((String)this.getBaseAttributes()[0].getName())});
        return new Expression[]{minAggregator};
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

