/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.extension.holder;

import io.siddhi.core.config.SiddhiAppContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractExtensionHolder {
    private static final Logger log = Logger.getLogger(AbstractExtensionHolder.class);
    protected Map<String, Class> extensionMap = new HashMap<String, Class>();

    protected AbstractExtensionHolder(Class clazz, SiddhiAppContext siddhiAppContext) {
        Map<String, Class> extensions = siddhiAppContext.getSiddhiContext().getSiddhiExtensions();
        if (extensions != null) {
            for (String extensionKey : siddhiAppContext.getSiddhiContext().getSiddhiExtensions().keySet()) {
                Class extension = extensions.get(extensionKey);
                if (!clazz.isAssignableFrom(extension)) continue;
                if (this.extensionMap.containsKey(extensionKey)) {
                    log.error((Object)("Extension class " + extension.getName() + " not loaded, as there is already an matching extension '" + extensionKey + "' implemented as " + this.extensionMap.get(extensionKey).getName()));
                    continue;
                }
                this.extensionMap.put(extensionKey, extension);
            }
        }
    }

    public Class getExtension(String namespace, String function) {
        if (!namespace.isEmpty()) {
            return this.extensionMap.get(namespace + ":" + function);
        }
        return this.extensionMap.get(function);
    }
}

