/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.parser;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.config.SiddhiContext;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.partition.PartitionRuntime;
import io.siddhi.core.query.QueryRuntime;
import io.siddhi.core.stream.StreamJunction;
import io.siddhi.core.util.ExceptionUtil;
import io.siddhi.core.util.IdGenerator;
import io.siddhi.core.util.SiddhiAppRuntimeBuilder;
import io.siddhi.core.util.ThreadBarrier;
import io.siddhi.core.util.parser.PartitionParser;
import io.siddhi.core.util.parser.QueryParser;
import io.siddhi.core.util.parser.helper.AnnotationHelper;
import io.siddhi.core.util.snapshot.SnapshotService;
import io.siddhi.core.util.timestamp.TimestampGeneratorImpl;
import io.siddhi.core.window.Window;
import io.siddhi.query.api.SiddhiApp;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.annotation.Annotation;
import io.siddhi.query.api.annotation.Element;
import io.siddhi.query.api.definition.AggregationDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.FunctionDefinition;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.definition.TableDefinition;
import io.siddhi.query.api.definition.TriggerDefinition;
import io.siddhi.query.api.definition.WindowDefinition;
import io.siddhi.query.api.exception.DuplicateAnnotationException;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import io.siddhi.query.api.execution.ExecutionElement;
import io.siddhi.query.api.execution.partition.Partition;
import io.siddhi.query.api.execution.query.Query;
import io.siddhi.query.api.execution.query.input.handler.StreamHandler;
import io.siddhi.query.api.execution.query.input.stream.JoinInputStream;
import io.siddhi.query.api.execution.query.input.stream.SingleInputStream;
import io.siddhi.query.api.execution.query.input.stream.StateInputStream;
import io.siddhi.query.api.expression.condition.In;
import io.siddhi.query.compiler.SiddhiCompiler;
import io.siddhi.query.compiler.exception.SiddhiParserException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class SiddhiAppParser {
    private static final Logger log = Logger.getLogger(SiddhiAppParser.class);

    public static SiddhiAppRuntimeBuilder parse(SiddhiApp siddhiApp, String siddhiAppString, SiddhiContext siddhiContext) {
        SiddhiAppContext siddhiAppContext = new SiddhiAppContext();
        siddhiAppContext.setSiddhiContext(siddhiContext);
        siddhiAppContext.setSiddhiAppString(siddhiAppString);
        try {
            Element statStateEnableElement;
            Element element = io.siddhi.query.api.util.AnnotationHelper.getAnnotationElement((String)"Name", null, (List)siddhiApp.getAnnotations());
            if (element != null) {
                siddhiAppContext.setName(element.getValue());
            } else {
                siddhiAppContext.setName(UUID.randomUUID().toString());
            }
            Annotation annotation = io.siddhi.query.api.util.AnnotationHelper.getAnnotation((String)"EnforceOrder", (List)siddhiApp.getAnnotations());
            if (annotation != null) {
                siddhiAppContext.setEnforceOrder(true);
            }
            if ((annotation = io.siddhi.query.api.util.AnnotationHelper.getAnnotation((String)"Async", (List)siddhiApp.getAnnotations())) != null) {
                throw new SiddhiAppCreationException("@Async not supported in SiddhiApp level, instead use @Async with streams", annotation.getQueryContextStartIndex(), annotation.getQueryContextEndIndex());
            }
            annotation = io.siddhi.query.api.util.AnnotationHelper.getAnnotation((String)"Statistics", (List)siddhiApp.getAnnotations());
            Object statisticsElements = new ArrayList();
            if (annotation != null) {
                statisticsElements = annotation.getElements();
            }
            if (siddhiContext.getStatisticsConfiguration() != null) {
                siddhiAppContext.setStatisticsManager(siddhiContext.getStatisticsConfiguration().getFactory().createStatisticsManager(siddhiContext.getStatisticsConfiguration().getMetricPrefix(), siddhiAppContext.getName(), (List<Element>)statisticsElements));
            }
            if ((statStateEnableElement = io.siddhi.query.api.util.AnnotationHelper.getAnnotationElement((String)"Statistics", (String)"enable", (List)siddhiApp.getAnnotations())) != null && Boolean.valueOf(statStateEnableElement.getValue()).booleanValue()) {
                siddhiAppContext.setStatsEnabled(true);
            } else {
                Element statStateElement = io.siddhi.query.api.util.AnnotationHelper.getAnnotationElement((String)"Statistics", null, (List)siddhiApp.getAnnotations());
                if (annotation != null && (statStateElement == null || Boolean.valueOf(statStateElement.getValue()).booleanValue())) {
                    siddhiAppContext.setStatsEnabled(true);
                }
            }
            Element statStateIncludElement = io.siddhi.query.api.util.AnnotationHelper.getAnnotationElement((String)"Statistics", (String)"include", (List)siddhiApp.getAnnotations());
            siddhiAppContext.setIncludedMetrics(AnnotationHelper.generateIncludedMetrics(statStateIncludElement));
            Element transportCreationEnabledElement = io.siddhi.query.api.util.AnnotationHelper.getAnnotationElement((String)"transportChannelCreationEnabled", null, (List)siddhiApp.getAnnotations());
            if (transportCreationEnabledElement == null) {
                siddhiAppContext.setTransportChannelCreationEnabled(true);
            } else {
                siddhiAppContext.setTransportChannelCreationEnabled(Boolean.valueOf(transportCreationEnabledElement.getValue()));
            }
            siddhiAppContext.setThreadBarrier(new ThreadBarrier());
            siddhiAppContext.setExecutorService(Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("Siddhi-" + siddhiAppContext.getName() + "-executor-thread-%d").build()));
            siddhiAppContext.setScheduledExecutorService(Executors.newScheduledThreadPool(5, new ThreadFactoryBuilder().setNameFormat("Siddhi-" + siddhiAppContext.getName() + "-scheduler-thread-%d").build()));
            annotation = io.siddhi.query.api.util.AnnotationHelper.getAnnotation((String)"Playback", (List)siddhiApp.getAnnotations());
            if (annotation != null) {
                String idleTime = null;
                String increment = null;
                TimestampGeneratorImpl timestampGenerator = new TimestampGeneratorImpl(siddhiAppContext);
                for (Element e : annotation.getElements()) {
                    if ("idle.time".equalsIgnoreCase(e.getKey())) {
                        idleTime = e.getValue();
                        continue;
                    }
                    if ("increment".equalsIgnoreCase(e.getKey())) {
                        increment = e.getValue();
                        continue;
                    }
                    throw new SiddhiAppValidationException("Playback annotation accepts only idle.time and increment but found " + e.getKey());
                }
                if (idleTime != null && increment == null) {
                    throw new SiddhiAppValidationException("Playback annotation requires both idle.time and increment but increment not found");
                }
                if (idleTime == null && increment != null) {
                    throw new SiddhiAppValidationException("Playback annotation requires both idle.time and increment but idle.time does not found");
                }
                if (idleTime != null) {
                    try {
                        timestampGenerator.setIdleTime(SiddhiCompiler.parseTimeConstantDefinition(idleTime).value());
                    }
                    catch (SiddhiParserException ex) {
                        throw new SiddhiParserException("Invalid idle.time constant '" + idleTime + "' in playback annotation", (Throwable)ex);
                    }
                    try {
                        timestampGenerator.setIncrementInMilliseconds(SiddhiCompiler.parseTimeConstantDefinition((String)increment).value());
                    }
                    catch (SiddhiParserException ex) {
                        throw new SiddhiParserException("Invalid increment constant '" + increment + "' in playback annotation", (Throwable)ex);
                    }
                }
                siddhiAppContext.setTimestampGenerator(timestampGenerator);
                siddhiAppContext.setPlayback(true);
            } else {
                siddhiAppContext.setTimestampGenerator(new TimestampGeneratorImpl(siddhiAppContext));
            }
            siddhiAppContext.setSnapshotService(new SnapshotService(siddhiAppContext));
            siddhiAppContext.setIdGenerator(new IdGenerator());
        }
        catch (DuplicateAnnotationException e) {
            throw new DuplicateAnnotationException(e.getMessageWithOutContext() + " for the same Siddhi app " + siddhiApp.toString(), (Throwable)e, e.getQueryContextStartIndex(), e.getQueryContextEndIndex(), siddhiAppContext.getName(), siddhiAppContext.getSiddhiAppString());
        }
        SiddhiAppRuntimeBuilder siddhiAppRuntimeBuilder = new SiddhiAppRuntimeBuilder(siddhiAppContext);
        SiddhiAppParser.defineStreamDefinitions(siddhiAppRuntimeBuilder, siddhiApp.getStreamDefinitionMap(), siddhiAppContext);
        SiddhiAppParser.defineTableDefinitions(siddhiAppRuntimeBuilder, siddhiApp.getTableDefinitionMap(), siddhiAppContext);
        SiddhiAppParser.defineWindowDefinitions(siddhiAppRuntimeBuilder, siddhiApp.getWindowDefinitionMap(), siddhiAppContext);
        SiddhiAppParser.defineFunctionDefinitions(siddhiAppRuntimeBuilder, siddhiApp.getFunctionDefinitionMap(), siddhiAppContext);
        SiddhiAppParser.defineAggregationDefinitions(siddhiAppRuntimeBuilder, siddhiApp.getAggregationDefinitionMap(), siddhiAppContext);
        List<String> findExecutedElements = SiddhiAppParser.getFindExecutedElements(siddhiApp);
        for (Window window : siddhiAppRuntimeBuilder.getWindowMap().values()) {
            try {
                window.init(siddhiAppRuntimeBuilder.getTableMap(), siddhiAppRuntimeBuilder.getWindowMap(), window.getWindowDefinition().getId(), findExecutedElements.contains(window.getWindowDefinition().getId()));
            }
            catch (Throwable t) {
                ExceptionUtil.populateQueryContext(t, (SiddhiElement)window.getWindowDefinition(), siddhiAppContext);
                throw t;
            }
        }
        int queryIndex = 1;
        int partitionIndex = 1;
        for (ExecutionElement executionElement : siddhiApp.getExecutionElementList()) {
            if (executionElement instanceof Query) {
                try {
                    QueryRuntime queryRuntime = QueryParser.parse((Query)executionElement, siddhiAppContext, siddhiAppRuntimeBuilder.getStreamDefinitionMap(), siddhiAppRuntimeBuilder.getTableDefinitionMap(), siddhiAppRuntimeBuilder.getWindowDefinitionMap(), siddhiAppRuntimeBuilder.getAggregationDefinitionMap(), siddhiAppRuntimeBuilder.getTableMap(), siddhiAppRuntimeBuilder.getAggregationMap(), siddhiAppRuntimeBuilder.getWindowMap(), siddhiAppRuntimeBuilder.getLockSynchronizer(), String.valueOf(queryIndex), false, "null");
                    siddhiAppRuntimeBuilder.addQuery(queryRuntime);
                    siddhiAppContext.addEternalReferencedHolder(queryRuntime);
                    ++queryIndex;
                    continue;
                }
                catch (Throwable t) {
                    ExceptionUtil.populateQueryContext(t, (SiddhiElement)((Query)executionElement), siddhiAppContext);
                    throw t;
                }
            }
            try {
                PartitionRuntime partitionRuntime = PartitionParser.parse(siddhiAppRuntimeBuilder, (Partition)executionElement, siddhiAppContext, queryIndex, partitionIndex);
                siddhiAppRuntimeBuilder.addPartition(partitionRuntime);
                queryIndex += ((Partition)executionElement).getQueryList().size();
                ++partitionIndex;
            }
            catch (Throwable t) {
                ExceptionUtil.populateQueryContext(t, (SiddhiElement)((Partition)executionElement), siddhiAppContext);
                throw t;
            }
        }
        SiddhiAppParser.defineTriggerDefinitions(siddhiAppRuntimeBuilder, siddhiApp.getTriggerDefinitionMap(), siddhiAppContext);
        return siddhiAppRuntimeBuilder;
    }

    private static List<String> getFindExecutedElements(SiddhiApp siddhiApp) {
        ArrayList<String> findExecutedElements = new ArrayList<String>();
        for (ExecutionElement executionElement : siddhiApp.getExecutionElementList()) {
            if (executionElement instanceof Query) {
                ArrayList streamHandlers = new ArrayList();
                if (((Query)executionElement).getInputStream() instanceof JoinInputStream) {
                    findExecutedElements.addAll(((Query)executionElement).getInputStream().getAllStreamIds());
                    streamHandlers.addAll(((SingleInputStream)((JoinInputStream)((Query)executionElement).getInputStream()).getLeftInputStream()).getStreamHandlers());
                    streamHandlers.addAll(((SingleInputStream)((JoinInputStream)((Query)executionElement).getInputStream()).getRightInputStream()).getStreamHandlers());
                } else if (((Query)executionElement).getInputStream() instanceof SingleInputStream) {
                    streamHandlers.addAll(((SingleInputStream)((Query)executionElement).getInputStream()).getStreamHandlers());
                } else if (((Query)executionElement).getInputStream() instanceof StateInputStream) {
                    streamHandlers.addAll(((StateInputStream)((Query)executionElement).getInputStream()).getStreamHandlers());
                }
                for (StreamHandler streamHandler : streamHandlers) {
                    if (!(streamHandler instanceof In)) continue;
                    findExecutedElements.add(((In)streamHandler).getSourceId());
                }
                continue;
            }
            List queries = ((Partition)executionElement).getQueryList();
            for (Query query : queries) {
                ArrayList streamHandlers = new ArrayList();
                if (query.getInputStream() instanceof JoinInputStream) {
                    findExecutedElements.addAll(query.getInputStream().getAllStreamIds());
                    streamHandlers.addAll(((SingleInputStream)((JoinInputStream)query.getInputStream()).getLeftInputStream()).getStreamHandlers());
                    streamHandlers.addAll(((SingleInputStream)((JoinInputStream)query.getInputStream()).getRightInputStream()).getStreamHandlers());
                } else if (query.getInputStream() instanceof SingleInputStream) {
                    streamHandlers.addAll(((SingleInputStream)query.getInputStream()).getStreamHandlers());
                } else if (query.getInputStream() instanceof StateInputStream) {
                    streamHandlers.addAll(((StateInputStream)query.getInputStream()).getStreamHandlers());
                }
                for (StreamHandler streamHandler : streamHandlers) {
                    if (!(streamHandler instanceof In)) continue;
                    findExecutedElements.add(((In)streamHandler).getSourceId());
                }
            }
        }
        return findExecutedElements;
    }

    private static void defineTriggerDefinitions(SiddhiAppRuntimeBuilder siddhiAppRuntimeBuilder, Map<String, TriggerDefinition> triggerDefinitionMap, SiddhiAppContext siddhiAppContext) {
        for (TriggerDefinition definition : triggerDefinitionMap.values()) {
            try {
                siddhiAppRuntimeBuilder.defineTrigger(definition);
            }
            catch (Throwable t) {
                ExceptionUtil.populateQueryContext(t, (SiddhiElement)definition, siddhiAppContext);
                throw t;
            }
        }
    }

    private static void defineFunctionDefinitions(SiddhiAppRuntimeBuilder siddhiAppRuntimeBuilder, Map<String, FunctionDefinition> functionDefinitionMap, SiddhiAppContext siddhiAppContext) {
        for (FunctionDefinition definition : functionDefinitionMap.values()) {
            try {
                siddhiAppRuntimeBuilder.defineFunction(definition);
            }
            catch (Throwable t) {
                ExceptionUtil.populateQueryContext(t, (SiddhiElement)definition, siddhiAppContext);
                throw t;
            }
        }
    }

    private static void defineStreamDefinitions(SiddhiAppRuntimeBuilder siddhiAppRuntimeBuilder, Map<String, StreamDefinition> streamDefinitionMap, SiddhiAppContext siddhiAppContext) {
        for (StreamDefinition definition : streamDefinitionMap.values()) {
            try {
                StreamJunction.OnErrorAction onErrorAction;
                Annotation onErrorAnnotation = io.siddhi.query.api.util.AnnotationHelper.getAnnotation((String)"OnError", (List)definition.getAnnotations());
                if (onErrorAnnotation != null && (onErrorAction = StreamJunction.OnErrorAction.valueOf(onErrorAnnotation.getElement("action").toUpperCase())) == StreamJunction.OnErrorAction.STREAM) {
                    StreamDefinition faultStreamDefinition = SiddhiAppParser.createFaultStreamDefinition(definition);
                    siddhiAppRuntimeBuilder.defineStream(faultStreamDefinition);
                }
                siddhiAppRuntimeBuilder.defineStream(definition);
            }
            catch (Throwable t) {
                ExceptionUtil.populateQueryContext(t, (SiddhiElement)definition, siddhiAppContext);
                throw t;
            }
        }
    }

    private static StreamDefinition createFaultStreamDefinition(StreamDefinition streamDefinition) {
        List attributeList = streamDefinition.getAttributeList();
        StreamDefinition faultStreamDefinition = new StreamDefinition();
        faultStreamDefinition.setId("!".concat(streamDefinition.getId()));
        for (Attribute attribute : attributeList) {
            faultStreamDefinition.attribute(attribute.getName(), attribute.getType());
        }
        faultStreamDefinition.attribute("_error", Attribute.Type.OBJECT);
        faultStreamDefinition.setQueryContextStartIndex(streamDefinition.getQueryContextStartIndex());
        faultStreamDefinition.setQueryContextEndIndex(streamDefinition.getQueryContextEndIndex());
        return faultStreamDefinition;
    }

    private static void defineTableDefinitions(SiddhiAppRuntimeBuilder siddhiAppRuntimeBuilder, Map<String, TableDefinition> tableDefinitionMap, SiddhiAppContext siddhiAppContext) {
        for (TableDefinition definition : tableDefinitionMap.values()) {
            try {
                siddhiAppRuntimeBuilder.defineTable(definition);
            }
            catch (Throwable t) {
                ExceptionUtil.populateQueryContext(t, (SiddhiElement)definition, siddhiAppContext);
                throw t;
            }
        }
    }

    private static void defineWindowDefinitions(SiddhiAppRuntimeBuilder siddhiAppRuntimeBuilder, Map<String, WindowDefinition> windowDefinitionMap, SiddhiAppContext siddhiAppContext) {
        for (WindowDefinition definition : windowDefinitionMap.values()) {
            try {
                siddhiAppRuntimeBuilder.defineWindow(definition);
            }
            catch (Throwable t) {
                ExceptionUtil.populateQueryContext(t, (SiddhiElement)definition, siddhiAppContext);
                throw t;
            }
        }
    }

    private static void defineAggregationDefinitions(SiddhiAppRuntimeBuilder siddhiAppRuntimeBuilder, Map<String, AggregationDefinition> aggregationDefinitionMap, SiddhiAppContext siddhiAppContext) {
        for (AggregationDefinition definition : aggregationDefinitionMap.values()) {
            try {
                siddhiAppRuntimeBuilder.defineAggregation(definition);
            }
            catch (Throwable t) {
                ExceptionUtil.populateQueryContext(t, (SiddhiElement)definition, siddhiAppContext);
                throw t;
            }
        }
    }
}

