/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.parser.helper;

import io.siddhi.query.api.annotation.Element;
import java.util.ArrayList;
import java.util.List;

public class AnnotationHelper {
    private static String createRegexFromGlob(String glob) {
        StringBuilder out = new StringBuilder();
        block6: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    out.append(".*");
                    continue block6;
                }
                case '?': {
                    out.append('.');
                    continue block6;
                }
                case '.': {
                    out.append("\\.");
                    continue block6;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block6;
                }
                default: {
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    public static List<String> generateIncludedMetrics(Element metrics) {
        ArrayList<String> regexs = new ArrayList<String>();
        if (metrics != null) {
            String[] metricStrings;
            for (String metricString : metricStrings = metrics.getValue().split(",")) {
                String metricStringTrim = metricString.trim();
                if (metricStringTrim.isEmpty()) continue;
                regexs.add(AnnotationHelper.createRegexFromGlob(metricStringTrim));
            }
        }
        if (regexs.size() == 0) {
            regexs.add(AnnotationHelper.createRegexFromGlob("*.*"));
        }
        return regexs;
    }
}

