/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.stream.output.sink;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.Event;
import io.siddhi.core.stream.output.sink.SinkHandlerCallback;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.snapshot.state.StateHolder;
import io.siddhi.query.api.definition.StreamDefinition;

public abstract class SinkHandler<S extends State> {
    private SinkHandlerCallback sinkHandlerCallback;
    private StateHolder<S> stateHolder;
    private String id;

    final void initSinkHandler(String siddhiAppName, StreamDefinition streamDefinition, SinkHandlerCallback sinkHandlerCallback, SiddhiAppContext siddhiAppContext) {
        this.sinkHandlerCallback = sinkHandlerCallback;
        StateFactory<S> stateFactory = this.init(streamDefinition, sinkHandlerCallback);
        this.id = siddhiAppName + "-" + streamDefinition.getId() + "-" + this.getClass().getName();
        this.stateHolder = siddhiAppContext.generateStateHolder(streamDefinition.getId() + "-" + this.getClass().getName(), stateFactory);
    }

    public abstract StateFactory<S> init(StreamDefinition var1, SinkHandlerCallback var2);

    public void handle(Event event) {
        S state = this.stateHolder.getState();
        try {
            this.handle(event, this.sinkHandlerCallback, state);
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    public void handle(Event[] events) {
        if (this.stateHolder != null) {
            S state = this.stateHolder.getState();
            try {
                this.handle(events, this.sinkHandlerCallback, state);
            }
            finally {
                this.stateHolder.returnState(state);
            }
        } else {
            this.handle(events, this.sinkHandlerCallback, null);
        }
    }

    public abstract void handle(Event var1, SinkHandlerCallback var2, S var3);

    public abstract void handle(Event[] var1, SinkHandlerCallback var2, S var3);

    public String getId() {
        return this.id;
    }
}

