/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.table.record;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.table.Table;
import io.siddhi.core.table.record.ExpressionVisitor;
import io.siddhi.core.table.record.UpdateOrInsertReducer;
import io.siddhi.core.util.ExceptionUtil;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.parser.ExpressionParser;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.AttributeNotExistException;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import io.siddhi.query.api.expression.AttributeFunction;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.Variable;
import io.siddhi.query.api.expression.condition.And;
import io.siddhi.query.api.expression.condition.Compare;
import io.siddhi.query.api.expression.condition.In;
import io.siddhi.query.api.expression.condition.IsNull;
import io.siddhi.query.api.expression.condition.Not;
import io.siddhi.query.api.expression.condition.Or;
import io.siddhi.query.api.expression.constant.BoolConstant;
import io.siddhi.query.api.expression.constant.Constant;
import io.siddhi.query.api.expression.constant.DoubleConstant;
import io.siddhi.query.api.expression.constant.FloatConstant;
import io.siddhi.query.api.expression.constant.IntConstant;
import io.siddhi.query.api.expression.constant.LongConstant;
import io.siddhi.query.api.expression.constant.StringConstant;
import io.siddhi.query.api.expression.math.Add;
import io.siddhi.query.api.expression.math.Divide;
import io.siddhi.query.api.expression.math.Mod;
import io.siddhi.query.api.expression.math.Multiply;
import io.siddhi.query.api.expression.math.Subtract;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExpressionBuilder {
    private final Map<String, ExpressionExecutor> variableExpressionExecutorMap;
    private final MatchingMetaInfoHolder matchingMetaInfoHolder;
    private final UpdateOrInsertReducer updateOrInsertReducer;
    private final SiddhiQueryContext siddhiQueryContext;
    private final List<VariableExpressionExecutor> variableExpressionExecutors;
    private final Map<String, Table> tableMap;
    private final Expression expression;
    private ExpressionExecutor inMemorySetExpressionExecutor;

    ExpressionBuilder(Expression expression, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, UpdateOrInsertReducer updateOrInsertReducer, ExpressionExecutor inMemorySetExpressionExecutor, SiddhiQueryContext siddhiQueryContext) {
        this.expression = expression;
        this.matchingMetaInfoHolder = matchingMetaInfoHolder;
        this.updateOrInsertReducer = updateOrInsertReducer;
        this.inMemorySetExpressionExecutor = inMemorySetExpressionExecutor;
        this.siddhiQueryContext = siddhiQueryContext;
        this.variableExpressionExecutors = variableExpressionExecutors;
        this.tableMap = tableMap;
        this.variableExpressionExecutorMap = new HashMap<String, ExpressionExecutor>();
    }

    public MatchingMetaInfoHolder getMatchingMetaInfoHolder() {
        return this.matchingMetaInfoHolder;
    }

    public SiddhiQueryContext getSiddhiQueryContext() {
        return this.siddhiQueryContext;
    }

    public List<VariableExpressionExecutor> getVariableExpressionExecutors() {
        return this.variableExpressionExecutors;
    }

    public Map<String, Table> getTableMap() {
        return this.tableMap;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public UpdateOrInsertReducer getUpdateOrInsertReducer() {
        return this.updateOrInsertReducer;
    }

    public ExpressionExecutor getInMemorySetExpressionExecutor() {
        return this.inMemorySetExpressionExecutor;
    }

    Map<String, ExpressionExecutor> getVariableExpressionExecutorMap() {
        return this.variableExpressionExecutorMap;
    }

    public void build(ExpressionVisitor expressionVisitor) {
        this.buildVariableExecutors(this.expression, expressionVisitor);
    }

    private void buildVariableExecutors(Expression expression, ExpressionVisitor expressionVisitor) {
        block54: {
            try {
                if (expression instanceof And) {
                    expressionVisitor.beginVisitAnd();
                    expressionVisitor.beginVisitAndLeftOperand();
                    this.buildVariableExecutors(((And)expression).getLeftExpression(), expressionVisitor);
                    expressionVisitor.endVisitAndLeftOperand();
                    expressionVisitor.beginVisitAndRightOperand();
                    this.buildVariableExecutors(((And)expression).getRightExpression(), expressionVisitor);
                    expressionVisitor.endVisitAndRightOperand();
                    expressionVisitor.endVisitAnd();
                    break block54;
                }
                if (expression instanceof Or) {
                    expressionVisitor.beginVisitOr();
                    expressionVisitor.beginVisitOrLeftOperand();
                    this.buildVariableExecutors(((Or)expression).getLeftExpression(), expressionVisitor);
                    expressionVisitor.endVisitOrLeftOperand();
                    expressionVisitor.beginVisitOrRightOperand();
                    this.buildVariableExecutors(((Or)expression).getRightExpression(), expressionVisitor);
                    expressionVisitor.endVisitOrRightOperand();
                    expressionVisitor.endVisitOr();
                    break block54;
                }
                if (expression instanceof Not) {
                    expressionVisitor.beginVisitNot();
                    this.buildVariableExecutors(((Not)expression).getExpression(), expressionVisitor);
                    expressionVisitor.endVisitNot();
                    break block54;
                }
                if (expression instanceof Compare) {
                    expressionVisitor.beginVisitCompare(((Compare)expression).getOperator());
                    expressionVisitor.beginVisitCompareLeftOperand(((Compare)expression).getOperator());
                    this.buildVariableExecutors(((Compare)expression).getLeftExpression(), expressionVisitor);
                    expressionVisitor.endVisitCompareLeftOperand(((Compare)expression).getOperator());
                    expressionVisitor.beginVisitCompareRightOperand(((Compare)expression).getOperator());
                    this.buildVariableExecutors(((Compare)expression).getRightExpression(), expressionVisitor);
                    expressionVisitor.endVisitCompareRightOperand(((Compare)expression).getOperator());
                    expressionVisitor.endVisitCompare(((Compare)expression).getOperator());
                    break block54;
                }
                if (expression instanceof Add) {
                    expressionVisitor.beginVisitMath(ExpressionVisitor.MathOperator.ADD);
                    expressionVisitor.beginVisitMathLeftOperand(ExpressionVisitor.MathOperator.ADD);
                    this.buildVariableExecutors(((Add)expression).getLeftValue(), expressionVisitor);
                    expressionVisitor.endVisitMathLeftOperand(ExpressionVisitor.MathOperator.ADD);
                    expressionVisitor.beginVisitMathRightOperand(ExpressionVisitor.MathOperator.ADD);
                    this.buildVariableExecutors(((Add)expression).getRightValue(), expressionVisitor);
                    expressionVisitor.endVisitMathRightOperand(ExpressionVisitor.MathOperator.ADD);
                    expressionVisitor.endVisitMath(ExpressionVisitor.MathOperator.ADD);
                    break block54;
                }
                if (expression instanceof Subtract) {
                    expressionVisitor.beginVisitMath(ExpressionVisitor.MathOperator.SUBTRACT);
                    expressionVisitor.beginVisitMathLeftOperand(ExpressionVisitor.MathOperator.SUBTRACT);
                    this.buildVariableExecutors(((Subtract)expression).getLeftValue(), expressionVisitor);
                    expressionVisitor.endVisitMathLeftOperand(ExpressionVisitor.MathOperator.SUBTRACT);
                    expressionVisitor.beginVisitMathRightOperand(ExpressionVisitor.MathOperator.SUBTRACT);
                    this.buildVariableExecutors(((Subtract)expression).getRightValue(), expressionVisitor);
                    expressionVisitor.endVisitMathRightOperand(ExpressionVisitor.MathOperator.SUBTRACT);
                    expressionVisitor.endVisitMath(ExpressionVisitor.MathOperator.SUBTRACT);
                    break block54;
                }
                if (expression instanceof Divide) {
                    expressionVisitor.beginVisitMath(ExpressionVisitor.MathOperator.DIVIDE);
                    expressionVisitor.beginVisitMathLeftOperand(ExpressionVisitor.MathOperator.DIVIDE);
                    this.buildVariableExecutors(((Divide)expression).getLeftValue(), expressionVisitor);
                    expressionVisitor.endVisitMathLeftOperand(ExpressionVisitor.MathOperator.DIVIDE);
                    expressionVisitor.beginVisitMathRightOperand(ExpressionVisitor.MathOperator.DIVIDE);
                    this.buildVariableExecutors(((Divide)expression).getRightValue(), expressionVisitor);
                    expressionVisitor.endVisitMathRightOperand(ExpressionVisitor.MathOperator.DIVIDE);
                    expressionVisitor.endVisitMath(ExpressionVisitor.MathOperator.DIVIDE);
                    break block54;
                }
                if (expression instanceof Multiply) {
                    expressionVisitor.beginVisitMath(ExpressionVisitor.MathOperator.MULTIPLY);
                    expressionVisitor.beginVisitMathLeftOperand(ExpressionVisitor.MathOperator.MULTIPLY);
                    this.buildVariableExecutors(((Multiply)expression).getLeftValue(), expressionVisitor);
                    expressionVisitor.endVisitMathLeftOperand(ExpressionVisitor.MathOperator.MULTIPLY);
                    expressionVisitor.beginVisitMathRightOperand(ExpressionVisitor.MathOperator.MULTIPLY);
                    this.buildVariableExecutors(((Multiply)expression).getRightValue(), expressionVisitor);
                    expressionVisitor.endVisitMathRightOperand(ExpressionVisitor.MathOperator.MULTIPLY);
                    expressionVisitor.endVisitMath(ExpressionVisitor.MathOperator.MULTIPLY);
                    break block54;
                }
                if (expression instanceof Mod) {
                    expressionVisitor.beginVisitMath(ExpressionVisitor.MathOperator.MOD);
                    expressionVisitor.beginVisitMathLeftOperand(ExpressionVisitor.MathOperator.MOD);
                    this.buildVariableExecutors(((Mod)expression).getLeftValue(), expressionVisitor);
                    expressionVisitor.endVisitMathLeftOperand(ExpressionVisitor.MathOperator.MOD);
                    expressionVisitor.beginVisitMathRightOperand(ExpressionVisitor.MathOperator.MOD);
                    this.buildVariableExecutors(((Mod)expression).getRightValue(), expressionVisitor);
                    expressionVisitor.endVisitMathRightOperand(ExpressionVisitor.MathOperator.MOD);
                    expressionVisitor.endVisitMath(ExpressionVisitor.MathOperator.MOD);
                    break block54;
                }
                if (expression instanceof IsNull) {
                    IsNull isNull = (IsNull)expression;
                    if (isNull.getExpression() != null) {
                        expressionVisitor.beginVisitIsNull(null);
                        this.buildVariableExecutors(((IsNull)expression).getExpression(), expressionVisitor);
                        expressionVisitor.endVisitIsNull(null);
                    } else {
                        String streamId = isNull.getStreamId();
                        MetaStateEvent metaStateEvent = this.matchingMetaInfoHolder.getMetaStateEvent();
                        if (streamId == null) {
                            throw new SiddhiAppCreationException("IsNull does not support streamId being null");
                        }
                        AbstractDefinition definitionOutput = null;
                        for (MetaStreamEvent metaStreamEvent : metaStateEvent.getMetaStreamEvents()) {
                            AbstractDefinition definition = metaStreamEvent.getLastInputDefinition();
                            if (metaStreamEvent.getInputReferenceId() == null) {
                                if (!definition.getId().equals(streamId)) continue;
                                definitionOutput = definition;
                                break;
                            }
                            if (!metaStreamEvent.getInputReferenceId().equals(streamId)) continue;
                            definitionOutput = definition;
                            break;
                        }
                        if (definitionOutput != null) {
                            expressionVisitor.beginVisitIsNull(definitionOutput.getId());
                            expressionVisitor.endVisitIsNull(definitionOutput.getId());
                        } else {
                            expressionVisitor.beginVisitIsNull(null);
                            expressionVisitor.endVisitIsNull(null);
                        }
                    }
                    break block54;
                }
                if (expression instanceof In) {
                    expressionVisitor.beginVisitIn(((In)expression).getSourceId());
                    this.buildVariableExecutors(((In)expression).getExpression(), expressionVisitor);
                    expressionVisitor.endVisitIn(((In)expression).getSourceId());
                    break block54;
                }
                if (expression instanceof Constant) {
                    if (expression instanceof DoubleConstant) {
                        expressionVisitor.beginVisitConstant(((DoubleConstant)expression).getValue(), Attribute.Type.DOUBLE);
                        expressionVisitor.endVisitConstant(((DoubleConstant)expression).getValue(), Attribute.Type.DOUBLE);
                        break block54;
                    }
                    if (expression instanceof StringConstant) {
                        expressionVisitor.beginVisitConstant(((StringConstant)expression).getValue(), Attribute.Type.STRING);
                        expressionVisitor.endVisitConstant(((StringConstant)expression).getValue(), Attribute.Type.STRING);
                        break block54;
                    }
                    if (expression instanceof IntConstant) {
                        expressionVisitor.beginVisitConstant(((IntConstant)expression).getValue(), Attribute.Type.INT);
                        expressionVisitor.endVisitConstant(((IntConstant)expression).getValue(), Attribute.Type.INT);
                        break block54;
                    }
                    if (expression instanceof BoolConstant) {
                        expressionVisitor.beginVisitConstant(((BoolConstant)expression).getValue(), Attribute.Type.BOOL);
                        expressionVisitor.endVisitConstant(((BoolConstant)expression).getValue(), Attribute.Type.BOOL);
                        break block54;
                    }
                    if (expression instanceof FloatConstant) {
                        expressionVisitor.beginVisitConstant(((FloatConstant)expression).getValue(), Attribute.Type.FLOAT);
                        expressionVisitor.endVisitConstant(((FloatConstant)expression).getValue(), Attribute.Type.FLOAT);
                        break block54;
                    }
                    if (expression instanceof LongConstant) {
                        expressionVisitor.beginVisitConstant(((LongConstant)expression).getValue(), Attribute.Type.LONG);
                        expressionVisitor.endVisitConstant(((LongConstant)expression).getValue(), Attribute.Type.LONG);
                        break block54;
                    }
                    throw new OperationNotSupportedException("No constant exist with type " + expression.getClass().getName());
                }
                if (expression instanceof AttributeFunction) {
                    expressionVisitor.beginVisitAttributeFunction(((AttributeFunction)expression).getNamespace(), ((AttributeFunction)expression).getName());
                    Expression[] expressions = ((AttributeFunction)expression).getParameters();
                    if (expressions != null) {
                        for (int i = 0; i < expressions.length; ++i) {
                            expressionVisitor.beginVisitParameterAttributeFunction(i);
                            this.buildVariableExecutors(expressions[i], expressionVisitor);
                            expressionVisitor.endVisitParameterAttributeFunction(i);
                        }
                    }
                    expressionVisitor.endVisitAttributeFunction(((AttributeFunction)expression).getNamespace(), ((AttributeFunction)expression).getName());
                    break block54;
                }
                if (!(expression instanceof Variable)) break block54;
                Variable variable = (Variable)expression;
                String attributeName = variable.getAttributeName();
                Attribute.Type type = null;
                int streamEventChainIndex = this.matchingMetaInfoHolder.getCurrentState();
                if (variable.getStreamId() == null) {
                    MetaStreamEvent[] metaStreamEvents = this.matchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvents();
                    if (streamEventChainIndex == -1) {
                        AbstractDefinition definition;
                        String firstInput = null;
                        for (int i = 0; i < metaStreamEvents.length; ++i) {
                            MetaStreamEvent metaStreamEvent = metaStreamEvents[i];
                            definition = metaStreamEvent.getLastInputDefinition();
                            if (type == null) {
                                try {
                                    type = definition.getAttributeType(attributeName);
                                    firstInput = "Input Stream: " + definition.getId() + " with reference: " + metaStreamEvent.getInputReferenceId();
                                    streamEventChainIndex = i;
                                }
                                catch (AttributeNotExistException attributeNotExistException) {}
                                continue;
                            }
                            try {
                                definition.getAttributeType(attributeName);
                                throw new SiddhiAppValidationException(firstInput + " and Input Stream: " + definition.getId() + " with reference: " + metaStreamEvent.getInputReferenceId() + " contains attribute with same name '" + attributeName + "'");
                            }
                            catch (AttributeNotExistException attributeNotExistException) {
                                // empty catch block
                            }
                        }
                        if (streamEventChainIndex != -1) {
                            if (this.matchingMetaInfoHolder.getMatchingStreamEventIndex() == streamEventChainIndex) {
                                this.buildStreamVariableExecutor(variable, streamEventChainIndex, expressionVisitor, type);
                            } else {
                                this.buildStoreVariableExecutor(variable, expressionVisitor, type, this.matchingMetaInfoHolder.getStoreDefinition());
                            }
                        } else {
                            definition = this.matchingMetaInfoHolder.getMetaStateEvent().getOutputStreamDefinition();
                            try {
                                type = definition.getAttributeType(attributeName);
                                this.buildStoreVariableExecutor(variable, expressionVisitor, type, this.matchingMetaInfoHolder.getStoreDefinition());
                            }
                            catch (AttributeNotExistException i) {}
                        }
                        break block54;
                    }
                    MetaStreamEvent metaStreamEvent = this.matchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvent(this.matchingMetaInfoHolder.getCurrentState());
                    AbstractDefinition definition = metaStreamEvent.getLastInputDefinition();
                    try {
                        type = definition.getAttributeType(attributeName);
                    }
                    catch (AttributeNotExistException e) {
                        definition = this.matchingMetaInfoHolder.getMetaStateEvent().getOutputStreamDefinition();
                        try {
                            type = definition.getAttributeType(attributeName);
                            this.buildStoreVariableExecutor(variable, expressionVisitor, type, this.matchingMetaInfoHolder.getStoreDefinition());
                        }
                        catch (AttributeNotExistException e1) {
                            throw new SiddhiAppValidationException(e1.getMessageWithOutContext() + " Input Stream: " + definition.getId() + " with reference: " + metaStreamEvent.getInputReferenceId(), e1.getQueryContextStartIndex(), e1.getQueryContextEndIndex(), this.siddhiQueryContext.getSiddhiAppContext().getName(), this.siddhiQueryContext.getSiddhiAppContext().getSiddhiAppString());
                        }
                    }
                    if (this.matchingMetaInfoHolder.getCurrentState() == this.matchingMetaInfoHolder.getMatchingStreamEventIndex()) {
                        this.buildStreamVariableExecutor(variable, streamEventChainIndex, expressionVisitor, type);
                    } else {
                        this.buildStoreVariableExecutor(variable, expressionVisitor, type, this.matchingMetaInfoHolder.getStoreDefinition());
                    }
                    break block54;
                }
                MetaStreamEvent[] metaStreamEvents = this.matchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvents();
                int metaStreamEventsLength = metaStreamEvents.length;
                for (int i = 0; i < metaStreamEventsLength; ++i) {
                    MetaStreamEvent metaStreamEvent = metaStreamEvents[i];
                    AbstractDefinition definition = metaStreamEvent.getLastInputDefinition();
                    if (metaStreamEvent.getInputReferenceId() == null) {
                        if (!definition.getId().equals(variable.getStreamId())) continue;
                        type = definition.getAttributeType(attributeName);
                        streamEventChainIndex = i;
                        break;
                    }
                    if (!metaStreamEvent.getInputReferenceId().equals(variable.getStreamId())) continue;
                    type = definition.getAttributeType(attributeName);
                    streamEventChainIndex = i;
                    break;
                }
                if (this.matchingMetaInfoHolder.getMatchingStreamEventIndex() == streamEventChainIndex) {
                    this.buildStreamVariableExecutor(variable, streamEventChainIndex, expressionVisitor, type);
                } else {
                    this.buildStoreVariableExecutor(variable, expressionVisitor, type, this.matchingMetaInfoHolder.getStoreDefinition());
                }
            }
            catch (Throwable t) {
                ExceptionUtil.populateQueryContext(t, (SiddhiElement)expression, this.siddhiQueryContext.getSiddhiAppContext());
                throw t;
            }
        }
    }

    private void buildStoreVariableExecutor(Variable variable, ExpressionVisitor expressionVisitor, Attribute.Type type, AbstractDefinition storeDefinition) {
        expressionVisitor.beginVisitStoreVariable(storeDefinition.getId(), variable.getAttributeName(), type);
        expressionVisitor.endVisitStoreVariable(storeDefinition.getId(), variable.getAttributeName(), type);
    }

    private void buildStreamVariableExecutor(Variable variable, int streamEventChainIndex, ExpressionVisitor expressionVisitor, Attribute.Type type) {
        String id = variable.getAttributeName();
        if (variable.getStreamId() != null) {
            id = variable.getStreamId() + "." + id;
        }
        expressionVisitor.beginVisitStreamVariable(id, variable.getStreamId(), variable.getAttributeName(), type);
        if (!this.variableExpressionExecutorMap.containsKey(id)) {
            ExpressionExecutor variableExpressionExecutor = ExpressionParser.parseExpression((Expression)variable, this.matchingMetaInfoHolder.getMetaStateEvent(), streamEventChainIndex, this.tableMap, this.variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, this.siddhiQueryContext);
            this.variableExpressionExecutorMap.put(id, variableExpressionExecutor);
        }
        expressionVisitor.endVisitStreamVariable(id, variable.getStreamId(), variable.getAttributeName(), type);
    }
}

