/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.collection.executor;

import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.table.CacheTable;
import io.siddhi.core.table.holder.IndexedEventHolder;
import io.siddhi.core.util.collection.executor.CollectionExecutor;
import io.siddhi.query.api.expression.condition.Compare;
import java.util.Collection;

public class CompareCollectionExecutor
implements CollectionExecutor {
    private final String attribute;
    private final Compare.Operator operator;
    private final ExpressionExecutor valueExpressionExecutor;
    protected ExpressionExecutor expressionExecutor;
    protected int storeEventIndex;
    private CacheTable cacheTable;

    public CompareCollectionExecutor(ExpressionExecutor expressionExecutor, int storeEventIndex, String attribute, Compare.Operator operator, ExpressionExecutor valueExpressionExecutor, CacheTable cacheTable) {
        this.expressionExecutor = expressionExecutor;
        this.storeEventIndex = storeEventIndex;
        this.attribute = attribute;
        this.operator = operator;
        this.valueExpressionExecutor = valueExpressionExecutor;
        this.cacheTable = cacheTable;
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder, StreamEventCloner storeEventCloner) {
        ComplexEventChunk<StreamEvent> returnEventChunk = new ComplexEventChunk<StreamEvent>();
        Collection<StreamEvent> storeEventSet = this.findEvents(matchingEvent, indexedEventHolder);
        if (storeEventSet == null) {
            Collection<StreamEvent> storeEvents = indexedEventHolder.getAllEvents();
            for (StreamEvent storeEvent : storeEvents) {
                matchingEvent.setEvent(this.storeEventIndex, storeEvent);
                if (((Boolean)this.expressionExecutor.execute(matchingEvent)).booleanValue()) {
                    if (storeEventCloner != null) {
                        returnEventChunk.add(storeEventCloner.copyStreamEvent(storeEvent));
                    } else {
                        returnEventChunk.add(storeEvent);
                    }
                }
                matchingEvent.setEvent(this.storeEventIndex, null);
            }
            return (StreamEvent)returnEventChunk.getFirst();
        }
        for (StreamEvent storeEvent : storeEventSet) {
            if (this.cacheTable != null) {
                this.cacheTable.updateCachePolicyAttribute(storeEvent);
            }
            if (storeEventCloner != null) {
                returnEventChunk.add(storeEventCloner.copyStreamEvent(storeEvent));
                continue;
            }
            returnEventChunk.add(storeEvent);
        }
        return (StreamEvent)returnEventChunk.getFirst();
    }

    public ExpressionExecutor getValueExpressionExecutor() {
        return this.valueExpressionExecutor;
    }

    @Override
    public Collection<StreamEvent> findEvents(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        if (this.operator == Compare.Operator.NOT_EQUAL) {
            return null;
        }
        return indexedEventHolder.findEvents(this.attribute, this.operator, this.valueExpressionExecutor.execute(matchingEvent));
    }

    @Override
    public boolean contains(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        return indexedEventHolder.containsEventSet(this.attribute, this.operator, this.valueExpressionExecutor.execute(matchingEvent));
    }

    @Override
    public void delete(StateEvent deletingEvent, IndexedEventHolder indexedEventHolder) {
        indexedEventHolder.delete(this.attribute, this.operator, this.valueExpressionExecutor.execute(deletingEvent));
    }

    @Override
    public CollectionExecutor.Cost getDefaultCost() {
        if (this.operator == Compare.Operator.EQUAL) {
            return CollectionExecutor.Cost.SINGLE_RETURN_INDEX_MATCHING;
        }
        if (this.operator == Compare.Operator.NOT_EQUAL) {
            return CollectionExecutor.Cost.EXHAUSTIVE;
        }
        return CollectionExecutor.Cost.MULTI_RETURN_INDEX_MATCHING;
    }

    public String getAttribute() {
        return this.attribute;
    }
}

