/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util;

import com.google.common.collect.TreeMultimap;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.util.Schedulable;
import io.siddhi.core.util.ThreadBarrier;
import io.siddhi.core.util.extension.holder.ExternalReferencedHolder;
import io.siddhi.core.util.lock.LockWrapper;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateHolder;
import io.siddhi.core.util.statistics.LatencyTracker;
import io.siddhi.core.util.statistics.metrics.Level;
import io.siddhi.core.util.timestamp.TimestampGeneratorImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class Scheduler
implements ExternalReferencedHolder {
    private static final Logger log = Logger.getLogger(Scheduler.class);
    private final ThreadBarrier threadBarrier;
    private final Schedulable singleThreadEntryValve;
    private final Semaphore mutex;
    protected String queryName;
    private SiddhiQueryContext siddhiQueryContext;
    private LockWrapper lockWrapper;
    private ScheduledExecutorService scheduledExecutorService;
    private StreamEventFactory streamEventFactory;
    private LatencyTracker latencyTracker;
    private StateHolder<SchedulerState> stateHolder;
    private boolean stop;

    public Scheduler(Schedulable singleThreadEntryValve, SiddhiQueryContext siddhiQueryContext) {
        this.threadBarrier = siddhiQueryContext.getSiddhiAppContext().getThreadBarrier();
        this.siddhiQueryContext = siddhiQueryContext;
        this.singleThreadEntryValve = singleThreadEntryValve;
        this.scheduledExecutorService = siddhiQueryContext.getSiddhiAppContext().getScheduledExecutorService();
        this.mutex = new Semaphore(1);
        siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().addTimeChangeListener(new TimestampGeneratorImpl.TimeChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void onTimeChange(long currentTimestamp) {
                Map allStates = Scheduler.this.stateHolder.getAllStates();
                try {
                    TreeMultimap sortedExpires = TreeMultimap.create();
                    for (Map.Entry allStatesEntry : allStates.entrySet()) {
                        for (Map.Entry stateEntry : allStatesEntry.getValue().entrySet()) {
                            Long lastTime = (Long)((SchedulerState)stateEntry.getValue()).toNotifyQueue.peek();
                            if (lastTime == null || lastTime > currentTimestamp) continue;
                            sortedExpires.put((Object)lastTime, stateEntry.getValue());
                        }
                    }
                    for (Map.Entry<String, Map<String, Object>> entry : sortedExpires.entries()) {
                        try {
                            SiddhiAppContext.startPartitionFlow(((SchedulerState)((Object)entry.getValue())).key);
                            Scheduler.this.sendTimerEvents((SchedulerState)((Object)entry.getValue()));
                        }
                        finally {
                            SiddhiAppContext.stopPartitionFlow();
                        }
                    }
                }
                finally {
                    Scheduler.this.stateHolder.returnAllStates(allStates);
                }
            }
        });
    }

    public void init(LockWrapper lockWrapper, String queryName) {
        this.lockWrapper = lockWrapper;
        this.queryName = queryName;
        String id = "Scheduler_" + queryName + "_" + this.siddhiQueryContext.generateNewId();
        this.stateHolder = this.siddhiQueryContext.generateStateHolder(id, false, () -> new SchedulerState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAt(long time) {
        SchedulerState state = this.stateHolder.getState();
        try {
            state.toNotifyQueue.put(time);
            this.schedule(time, state, false);
        }
        catch (InterruptedException e) {
            if (!this.scheduledExecutorService.isShutdown()) {
                log.error((Object)("Error when adding time:" + time + " to toNotifyQueue at Scheduler"), (Throwable)e);
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule(long time, SchedulerState state, boolean force) {
        if (!(this.siddhiQueryContext.getSiddhiAppContext().isPlayback() || state.running || state.toNotifyQueue.size() != 1 && !force)) {
            try {
                this.mutex.acquire();
                if (!state.running) {
                    state.running = true;
                    long timeDiff = time - this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime();
                    if (timeDiff > 0L) {
                        state.scheduledFuture = this.scheduledExecutorService.schedule(state.eventCaller, timeDiff, TimeUnit.MILLISECONDS);
                    } else {
                        state.scheduledFuture = this.scheduledExecutorService.schedule(state.eventCaller, 0L, TimeUnit.MILLISECONDS);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error((Object)"Error when scheduling System Time Based Scheduler", (Throwable)e);
            }
            finally {
                this.mutex.release();
            }
        }
    }

    public void setStreamEventFactory(StreamEventFactory streamEventFactory) {
        this.streamEventFactory = streamEventFactory;
    }

    public void setLatencyTracker(LatencyTracker latencyTracker) {
        this.latencyTracker = latencyTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTimerEvents(SchedulerState state) {
        Long toNotifyTime = (Long)state.toNotifyQueue.peek();
        long currentTime = this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime();
        while (toNotifyTime != null && toNotifyTime - currentTime <= 0L) {
            block12: {
                state.toNotifyQueue.poll();
                StreamEvent timerEvent = this.streamEventFactory.newInstance();
                timerEvent.setType(ComplexEvent.Type.TIMER);
                timerEvent.setTimestamp(toNotifyTime);
                if (this.lockWrapper != null) {
                    this.lockWrapper.lock();
                }
                this.threadBarrier.enter();
                try {
                    ComplexEventChunk<StreamEvent> streamEventChunk = new ComplexEventChunk<StreamEvent>();
                    streamEventChunk.add(timerEvent);
                    if (Level.BASIC.compareTo(this.siddhiQueryContext.getSiddhiAppContext().getRootMetricsLevel()) <= 0 && this.latencyTracker != null) {
                        try {
                            this.latencyTracker.markIn();
                            this.singleThreadEntryValve.process(streamEventChunk);
                            break block12;
                        }
                        finally {
                            this.latencyTracker.markOut();
                        }
                    }
                    this.singleThreadEntryValve.process(streamEventChunk);
                }
                catch (Throwable t) {
                    log.error((Object)("Error while sending timer events, " + t.getMessage()), t);
                }
                finally {
                    if (this.lockWrapper != null) {
                        this.lockWrapper.unlock();
                    }
                    this.threadBarrier.exit();
                }
            }
            toNotifyTime = (Long)state.toNotifyQueue.peek();
            currentTime = this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToLiveMode() {
        Map allStates = this.stateHolder.getAllStates();
        try {
            for (Map.Entry<String, Map<String, SchedulerState>> allStatesEntry : allStates.entrySet()) {
                for (Map.Entry<String, SchedulerState> stateEntry : allStatesEntry.getValue().entrySet()) {
                    Long toNotifyTime = (Long)stateEntry.getValue().toNotifyQueue.peek();
                    if (toNotifyTime == null) continue;
                    SiddhiAppContext.startPartitionFlow(allStatesEntry.getKey());
                    SiddhiAppContext.startGroupByFlow(stateEntry.getKey());
                    try {
                        this.schedule(toNotifyTime, stateEntry.getValue(), true);
                    }
                    finally {
                        SiddhiAppContext.stopGroupByFlow();
                        SiddhiAppContext.stopPartitionFlow();
                    }
                }
            }
        }
        finally {
            this.stateHolder.returnAllStates(allStates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToPlayBackMode() {
        Map allStates = this.stateHolder.getAllStates();
        try {
            for (Map.Entry<String, Map<String, SchedulerState>> allStatesEntry : allStates.entrySet()) {
                for (Map.Entry<String, SchedulerState> stateEntry : allStatesEntry.getValue().entrySet()) {
                    if (stateEntry.getValue().scheduledFuture != null) {
                        stateEntry.getValue().scheduledFuture.cancel(true);
                    }
                    stateEntry.getValue().running = false;
                }
            }
        }
        finally {
            this.stateHolder.returnAllStates(allStates);
        }
    }

    @Override
    public void stop() {
        this.stop = true;
    }

    @Override
    public void start() {
        this.stop = false;
    }

    class SchedulerState
    extends State
    implements Comparable {
        private final BlockingQueue<Long> toNotifyQueue = new LinkedBlockingQueue<Long>();
        private final String key = SiddhiAppContext.getPartitionFlowId();
        private volatile boolean running = false;
        private EventCaller eventCaller;
        private ScheduledFuture scheduledFuture;

        public SchedulerState() {
            this.eventCaller = new EventCaller(this, this.key);
        }

        @Override
        public boolean canDestroy() {
            return this.toNotifyQueue.isEmpty() && (this.scheduledFuture == null || this.scheduledFuture.isDone());
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("ToNotifyQueue", this.toNotifyQueue);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            BlockingQueue restoreToNotifyQueue = (BlockingQueue)state.get("ToNotifyQueue");
            for (Long time : restoreToNotifyQueue) {
                Scheduler.this.notifyAt(time);
            }
        }

        public int compareTo(Object o) {
            return 0;
        }
    }

    private class EventCaller
    implements Runnable {
        private SchedulerState state;
        private String key;

        public EventCaller(SchedulerState state, String key) {
            this.state = state;
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            block14: {
                if (Scheduler.this.stop) {
                    return;
                }
                SiddhiAppContext.startPartitionFlow(this.key);
                try {
                    if (!Scheduler.this.siddhiQueryContext.getSiddhiAppContext().isPlayback()) {
                        Scheduler.this.sendTimerEvents(this.state);
                        Long toNotifyTime = (Long)this.state.toNotifyQueue.peek();
                        long currentTime = Scheduler.this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime();
                        if (toNotifyTime != null) {
                            this.state.scheduledFuture = Scheduler.this.scheduledExecutorService.schedule(this, toNotifyTime - currentTime, TimeUnit.MILLISECONDS);
                            break block14;
                        }
                        try {
                            Scheduler.this.mutex.acquire();
                            this.state.running = false;
                            if (this.state.toNotifyQueue.peek() != null) {
                                this.state.running = true;
                                this.state.scheduledFuture = Scheduler.this.scheduledExecutorService.schedule(this, 0L, TimeUnit.MILLISECONDS);
                            }
                            break block14;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            log.error((Object)"Error when scheduling System Time Based Scheduler", (Throwable)e);
                            break block14;
                        }
                        finally {
                            Scheduler.this.mutex.release();
                        }
                    }
                    this.state.running = false;
                }
                catch (Throwable t) {
                    log.error((Object)("Error while executing Scheduled Timer Event Caller, " + t.getMessage()), t);
                }
                finally {
                    SiddhiAppContext.stopPartitionFlow();
                }
            }
        }
    }
}

