/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.snapshot;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.query.output.ratelimit.snapshot.SnapshotOutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.WrappedSnapshotOutputRateLimiter;
import io.siddhi.core.util.Scheduler;
import io.siddhi.core.util.parser.SchedulerParser;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AggregationWindowedPerSnapshotOutputRateLimiter
extends SnapshotOutputRateLimiter<AggregationRateLimiterState> {
    protected final Long value;
    protected Comparator<ComplexEvent> comparator;
    protected List<Integer> aggregateAttributePositionList;
    protected Scheduler scheduler;

    protected AggregationWindowedPerSnapshotOutputRateLimiter(Long value, final List<Integer> aggregateAttributePositionList, WrappedSnapshotOutputRateLimiter wrappedSnapshotOutputRateLimiter, boolean groupBy, SiddhiQueryContext siddhiQueryContext) {
        super(wrappedSnapshotOutputRateLimiter, siddhiQueryContext, groupBy);
        this.value = value;
        this.aggregateAttributePositionList = aggregateAttributePositionList;
        Collections.sort(aggregateAttributePositionList);
        this.comparator = new Comparator<ComplexEvent>(){
            Integer[] aggregateAttributePositions;
            int ignoreIndexLength;
            {
                this.aggregateAttributePositions = aggregateAttributePositionList.toArray(new Integer[aggregateAttributePositionList.size()]);
                this.ignoreIndexLength = this.aggregateAttributePositions.length;
            }

            @Override
            public int compare(ComplexEvent event1, ComplexEvent event2) {
                int ignoreIndex = 0;
                int ignoreIndexPosition = this.aggregateAttributePositions[0];
                Object[] data = event1.getOutputData();
                for (int i = 0; i < data.length; ++i) {
                    if (ignoreIndexPosition == i) {
                        if (++ignoreIndex == this.ignoreIndexLength) {
                            ignoreIndexPosition = -1;
                            continue;
                        }
                        ignoreIndexPosition = this.aggregateAttributePositions[i];
                        continue;
                    }
                    if (data[i].equals(event2.getOutputData()[i])) continue;
                    return 1;
                }
                return 0;
            }
        };
    }

    @Override
    protected StateFactory<AggregationRateLimiterState> init() {
        this.scheduler = SchedulerParser.parse(this, this.siddhiQueryContext);
        this.scheduler.setStreamEventFactory(new StreamEventFactory(0, 0, 0));
        this.scheduler.init(this.lockWrapper, this.siddhiQueryContext.getName());
        return () -> new AggregationRateLimiterState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        LinkedList<ComplexEventChunk> outputEventChunks = new LinkedList<ComplexEventChunk>();
        AggregationRateLimiterState state = (AggregationRateLimiterState)this.stateHolder.getState();
        try {
            AggregationRateLimiterState aggregationRateLimiterState = state;
            synchronized (aggregationRateLimiterState) {
                block5: while (complexEventChunk.hasNext()) {
                    Object event = complexEventChunk.next();
                    if (event.getType() == ComplexEvent.Type.TIMER) {
                        this.tryFlushEvents(outputEventChunks, (ComplexEvent)event, state);
                        continue;
                    }
                    complexEventChunk.remove();
                    this.tryFlushEvents(outputEventChunks, (ComplexEvent)event, state);
                    if (event.getType() == ComplexEvent.Type.CURRENT) {
                        state.eventList.add(event);
                        for (Integer position : this.aggregateAttributePositionList) {
                            state.aggregateAttributeValueMap.put(position, event.getOutputData()[position]);
                        }
                        continue;
                    }
                    if (event.getType() == ComplexEvent.Type.EXPIRED) {
                        Iterator iterator = state.eventList.iterator();
                        while (iterator.hasNext()) {
                            ComplexEvent complexEvent = (ComplexEvent)iterator.next();
                            if (this.comparator.compare((ComplexEvent)event, complexEvent) != 0) continue;
                            iterator.remove();
                            for (Integer position : this.aggregateAttributePositionList) {
                                state.aggregateAttributeValueMap.put(position, event.getOutputData()[position]);
                            }
                            continue block5;
                        }
                        continue;
                    }
                    if (event.getType() != ComplexEvent.Type.RESET) continue;
                    state.eventList.clear();
                    state.aggregateAttributeValueMap.clear();
                }
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
        this.sendToCallBacks(outputEventChunks);
    }

    private void tryFlushEvents(List<ComplexEventChunk> outputEventChunks, ComplexEvent event, AggregationRateLimiterState state) {
        if (event.getTimestamp() >= state.scheduledTime) {
            ComplexEventChunk<ComplexEvent> outputEventChunk = new ComplexEventChunk<ComplexEvent>();
            for (ComplexEvent originalComplexEvent : state.eventList) {
                ComplexEvent eventCopy = this.cloneComplexEvent(originalComplexEvent);
                for (Integer position : this.aggregateAttributePositionList) {
                    eventCopy.getOutputData()[position.intValue()] = state.aggregateAttributeValueMap.get(position);
                }
                outputEventChunk.add(eventCopy);
            }
            outputEventChunks.add(outputEventChunk);
            state.scheduledTime += this.value.longValue();
            this.scheduler.notifyAt(state.scheduledTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void partitionCreated() {
        AggregationRateLimiterState state = (AggregationRateLimiterState)this.stateHolder.getState();
        try {
            AggregationRateLimiterState aggregationRateLimiterState = state;
            synchronized (aggregationRateLimiterState) {
                long currentTime = System.currentTimeMillis();
                state.scheduledTime = currentTime + this.value;
                this.scheduler.notifyAt(state.scheduledTime);
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    class AggregationRateLimiterState
    extends State {
        protected long scheduledTime;
        private List<ComplexEvent> eventList = new LinkedList<ComplexEvent>();
        private Map<Integer, Object> aggregateAttributeValueMap;

        public AggregationRateLimiterState() {
            this.aggregateAttributeValueMap = new HashMap<Integer, Object>(AggregationWindowedPerSnapshotOutputRateLimiter.this.aggregateAttributePositionList.size());
        }

        @Override
        public boolean canDestroy() {
            return this.aggregateAttributeValueMap.isEmpty() && this.eventList.isEmpty() && this.scheduledTime == 0L;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("EventList", this.eventList);
            state.put("AggregateAttributeValueMap", this.aggregateAttributeValueMap);
            state.put("ScheduledTime", this.scheduledTime);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.eventList = (List)state.get("EventList");
            this.aggregateAttributeValueMap = (Map)state.get("AdgregateAttributeValueMap");
            this.scheduledTime = (Long)state.get("ScheduledTime");
        }
    }
}

