/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.processor.stream.window;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.holder.SnapshotableStreamEventQueue;
import io.siddhi.core.event.stream.holder.StreamEventClonerHolder;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.processor.stream.window.BatchingFindableWindowProcessor;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.collection.operator.Operator;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.parser.OperatorParser;
import io.siddhi.core.util.snapshot.state.SnapshotStateList;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.expression.Expression;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class EmptyWindowProcessor
extends BatchingFindableWindowProcessor<WindowState> {
    private boolean outputExpectsExpiredEvents;
    private SiddhiQueryContext siddhiQueryContext;

    @Override
    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, StreamEventClonerHolder streamEventClonerHolder, boolean outputExpectsExpiredEvents, boolean findToBeExecuted, SiddhiQueryContext siddhiQueryContext) {
        this.outputExpectsExpiredEvents = outputExpectsExpiredEvents;
        this.siddhiQueryContext = siddhiQueryContext;
        return () -> new WindowState(streamEventClonerHolder, false, outputExpectsExpiredEvents, findToBeExecuted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, WindowState state) {
        LinkedList<ComplexEventChunk> streamEventChunks = new LinkedList<ComplexEventChunk>();
        WindowState windowState = state;
        synchronized (windowState) {
            ComplexEventChunk<StreamEvent> outputStreamEventChunk = new ComplexEventChunk<StreamEvent>();
            long currentTime = this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime();
            while (streamEventChunk.hasNext()) {
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                streamEventChunk.remove();
                outputStreamEventChunk.add(streamEvent);
                if (this.outputExpectsExpiredEvents) {
                    StreamEvent expiredEvent = streamEventCloner.copyStreamEvent(streamEvent);
                    expiredEvent.setType(ComplexEvent.Type.EXPIRED);
                    expiredEvent.setTimestamp(currentTime);
                    outputStreamEventChunk.add(expiredEvent);
                }
                StreamEvent resetEvent = streamEventCloner.copyStreamEvent(streamEvent);
                resetEvent.setType(ComplexEvent.Type.RESET);
                resetEvent.setTimestamp(currentTime);
                outputStreamEventChunk.add(resetEvent);
                if (outputStreamEventChunk.getFirst() == null) continue;
                streamEventChunks.add(outputStreamEventChunk);
                outputStreamEventChunk = new ComplexEventChunk();
            }
        }
        nextProcessor.process(streamEventChunks);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, WindowState state, SiddhiQueryContext siddhiQueryContext) {
        return OperatorParser.constructOperator(state.expiredEventQueue, condition, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition, StreamEventCloner streamEventCloner, WindowState state) {
        return ((Operator)compiledCondition).find(matchingEvent, state.expiredEventQueue, streamEventCloner);
    }

    class WindowState
    extends State {
        private SnapshotableStreamEventQueue expiredEventQueue = null;

        public WindowState(StreamEventClonerHolder streamEventClonerHolder, boolean isStreamCurrentEvents, boolean outputExpectsExpiredEvents, boolean findToBeExecuted) {
            if (outputExpectsExpiredEvents || findToBeExecuted) {
                this.expiredEventQueue = new SnapshotableStreamEventQueue(streamEventClonerHolder);
            }
        }

        @Override
        public boolean canDestroy() {
            return this.expiredEventQueue == null || this.expiredEventQueue.getFirst() == null;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("ExpiredEventQueue", this.expiredEventQueue != null ? this.expiredEventQueue.getSnapshot() : null);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            if (this.expiredEventQueue != null) {
                this.expiredEventQueue.clear();
                this.expiredEventQueue.restore((SnapshotStateList)state.get("ExpiredEventQueue"));
            }
        }
    }
}

