/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util;

import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.query.api.aggregation.TimePeriod;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class IncrementalTimeConverterUtil {
    public static long getNextEmitTime(long currentTime, TimePeriod.Duration duration, String timeZone) {
        switch (duration) {
            case SECONDS: {
                return currentTime - currentTime % 1000L + 1000L;
            }
            case MINUTES: {
                return currentTime - currentTime % 60000L + 60000L;
            }
            case HOURS: {
                return IncrementalTimeConverterUtil.getNextEmitTimeForHour(currentTime, timeZone);
            }
            case DAYS: {
                return IncrementalTimeConverterUtil.getNextEmitTimeForDay(currentTime, timeZone);
            }
            case MONTHS: {
                return IncrementalTimeConverterUtil.getNextEmitTimeForMonth(currentTime, timeZone);
            }
            case YEARS: {
                return IncrementalTimeConverterUtil.getNextEmitTimeForYear(currentTime, timeZone);
            }
        }
        throw new SiddhiAppRuntimeException("Undefined duration " + duration.toString());
    }

    public static long getStartTimeOfAggregates(long currentTime, TimePeriod.Duration duration, String timeZone) {
        switch (duration) {
            case SECONDS: {
                return currentTime - currentTime % (long)IncrementalTimeConverterUtil.getMillisecondsPerDuration(duration);
            }
            case MINUTES: {
                return currentTime - currentTime % (long)IncrementalTimeConverterUtil.getMillisecondsPerDuration(duration);
            }
            case HOURS: {
                return IncrementalTimeConverterUtil.getStartTimeOfAggregatesForHour(currentTime, timeZone);
            }
            case DAYS: {
                return IncrementalTimeConverterUtil.getStartTimeOfAggregatesForDay(currentTime, timeZone);
            }
            case MONTHS: {
                return IncrementalTimeConverterUtil.getStartTimeOfAggregatesForMonth(currentTime, timeZone);
            }
            case YEARS: {
                return IncrementalTimeConverterUtil.getStartTimeOfAggregatesForYear(currentTime, timeZone);
            }
        }
        throw new SiddhiAppRuntimeException("Undefined duration " + duration.toString());
    }

    public static long getPreviousStartTime(long currentStartTime, TimePeriod.Duration duration) {
        switch (duration) {
            case SECONDS: {
                return currentStartTime - (long)IncrementalTimeConverterUtil.getMillisecondsPerDuration(duration);
            }
            case MINUTES: {
                return currentStartTime - (long)IncrementalTimeConverterUtil.getMillisecondsPerDuration(duration);
            }
            case HOURS: {
                return currentStartTime - (long)IncrementalTimeConverterUtil.getMillisecondsPerDuration(duration);
            }
            case DAYS: {
                return currentStartTime - (long)IncrementalTimeConverterUtil.getMillisecondsPerDuration(duration);
            }
            case MONTHS: {
                return IncrementalTimeConverterUtil.getStartTimeOfPreviousMonth(currentStartTime);
            }
            case YEARS: {
                return IncrementalTimeConverterUtil.getStartTimeOfPreviousYear(currentStartTime);
            }
        }
        throw new SiddhiAppRuntimeException("Undefined duration " + duration.toString());
    }

    private static long getNextEmitTimeForHour(long currentTime, String timeZone) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTime), ZoneId.of(timeZone));
        if (zonedDateTime.getHour() == 23) {
            if (zonedDateTime.getDayOfMonth() + 1 > zonedDateTime.getMonth().length(zonedDateTime.getYear() % 4 == 0)) {
                if (zonedDateTime.getMonthValue() == 12) {
                    return ZonedDateTime.of(zonedDateTime.getYear() + 1, 1, 1, 0, 0, 0, 0, ZoneId.of(timeZone)).toEpochSecond() * 1000L;
                }
                return ZonedDateTime.of(zonedDateTime.getYear(), zonedDateTime.getMonthValue() + 1, 1, 0, 0, 0, 0, ZoneId.of(timeZone)).toEpochSecond() * 1000L;
            }
            return ZonedDateTime.of(zonedDateTime.getYear(), zonedDateTime.getMonthValue(), zonedDateTime.getDayOfMonth() + 1, 0, 0, 0, 0, ZoneId.of(timeZone)).toEpochSecond() * 1000L;
        }
        return ZonedDateTime.of(zonedDateTime.getYear(), zonedDateTime.getMonthValue(), zonedDateTime.getDayOfMonth(), zonedDateTime.getHour() + 1, 0, 0, 0, ZoneId.of(timeZone)).toEpochSecond() * 1000L;
    }

    private static long getNextEmitTimeForDay(long currentTime, String timeZone) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTime), ZoneId.of(timeZone));
        if (zonedDateTime.getDayOfMonth() + 1 > zonedDateTime.getMonth().length(zonedDateTime.getYear() % 4 == 0)) {
            if (zonedDateTime.getMonthValue() == 12) {
                return ZonedDateTime.of(zonedDateTime.getYear() + 1, 1, 1, 0, 0, 0, 0, ZoneId.of(timeZone)).toEpochSecond() * 1000L;
            }
            return ZonedDateTime.of(zonedDateTime.getYear(), zonedDateTime.getMonthValue() + 1, 1, 0, 0, 0, 0, ZoneId.of(timeZone)).toEpochSecond() * 1000L;
        }
        return ZonedDateTime.of(zonedDateTime.getYear(), zonedDateTime.getMonthValue(), zonedDateTime.getDayOfMonth() + 1, 0, 0, 0, 0, ZoneId.of(timeZone)).toEpochSecond() * 1000L;
    }

    private static long getNextEmitTimeForMonth(long currentTime, String timeZone) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTime), ZoneId.of(timeZone));
        if (zonedDateTime.getMonthValue() == 12) {
            return ZonedDateTime.of(zonedDateTime.getYear() + 1, 1, 1, 0, 0, 0, 0, ZoneId.of(timeZone)).toEpochSecond() * 1000L;
        }
        return ZonedDateTime.of(zonedDateTime.getYear(), zonedDateTime.getMonthValue() + 1, 1, 0, 0, 0, 0, ZoneId.of(timeZone)).toEpochSecond() * 1000L;
    }

    private static long getNextEmitTimeForYear(long currentTime, String timeZone) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTime), ZoneId.of(timeZone));
        return ZonedDateTime.of(zonedDateTime.getYear() + 1, 1, 1, 0, 0, 0, 0, ZoneId.of(timeZone)).toEpochSecond() * 1000L;
    }

    private static long getStartTimeOfAggregatesForHour(long currentTime, String timeZone) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTime), ZoneId.of(timeZone));
        return ZonedDateTime.of(zonedDateTime.getYear(), zonedDateTime.getMonthValue(), zonedDateTime.getDayOfMonth(), zonedDateTime.getHour(), 0, 0, 0, ZoneId.of(timeZone)).toEpochSecond() * 1000L;
    }

    private static long getStartTimeOfAggregatesForDay(long currentTime, String timeZone) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTime), ZoneId.of(timeZone));
        return ZonedDateTime.of(zonedDateTime.getYear(), zonedDateTime.getMonthValue(), zonedDateTime.getDayOfMonth(), 0, 0, 0, 0, ZoneId.of(timeZone)).toEpochSecond() * 1000L;
    }

    private static long getStartTimeOfAggregatesForMonth(long currentTime, String timeZone) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTime), ZoneId.of(timeZone));
        return ZonedDateTime.of(zonedDateTime.getYear(), zonedDateTime.getMonthValue(), 1, 0, 0, 0, 0, ZoneId.of(timeZone)).toEpochSecond() * 1000L;
    }

    private static long getStartTimeOfAggregatesForYear(long currentTime, String timeZone) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTime), ZoneId.of(timeZone));
        return ZonedDateTime.of(zonedDateTime.getYear(), 1, 1, 0, 0, 0, 0, ZoneId.of(timeZone)).toEpochSecond() * 1000L;
    }

    private static long getStartTimeOfPreviousMonth(long currentEmitTime) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentEmitTime), ZoneId.of("GMT"));
        int givenMonth = zonedDateTime.getMonthValue();
        int givenYear = zonedDateTime.getYear();
        if (givenMonth == 1) {
            return ZonedDateTime.of(--givenYear, 12, 1, 0, 0, 0, 0, ZoneId.of("GMT")).toEpochSecond() * 1000L;
        }
        return ZonedDateTime.of(givenYear, --givenMonth, 1, 0, 0, 0, 0, ZoneId.of("GMT")).toEpochSecond() * 1000L;
    }

    private static long getStartTimeOfPreviousYear(long currentEmitTime) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentEmitTime), ZoneId.of("GMT"));
        int givenYear = zonedDateTime.getYear();
        return ZonedDateTime.of(--givenYear, 1, 1, 0, 0, 0, 0, ZoneId.of("GMT")).toEpochSecond() * 1000L;
    }

    public static int getMillisecondsPerDuration(TimePeriod.Duration duration) {
        switch (duration) {
            case SECONDS: {
                return 1000;
            }
            case MINUTES: {
                return 60000;
            }
            case HOURS: {
                return 3600000;
            }
            case DAYS: {
                return 86400000;
            }
        }
        throw new SiddhiAppRuntimeException("Cannot provide number of milliseconds per duration " + duration + ".Number of milliseconds are only define for SECONDS, MINUTES, HOURS and DAYS");
    }
}

