/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.snapshot.state;

import io.siddhi.core.util.snapshot.state.PartitionStateHolder;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.snapshot.state.StateHolder;
import java.util.Map;

public class PartitionSyncStateHolder
implements StateHolder {
    private PartitionStateHolder partitionStateHolder;

    public PartitionSyncStateHolder(StateFactory stateFactory) {
        this.partitionStateHolder = new PartitionStateHolder(stateFactory);
    }

    public synchronized State getState() {
        State state = this.partitionStateHolder.getState();
        ++state.activeUseCount;
        return state;
    }

    public synchronized void returnState(State state) {
        --state.activeUseCount;
        this.partitionStateHolder.returnState(state);
    }

    public synchronized Map<String, Map<String, State>> getAllStates() {
        Map<String, Map<String, State>> states = this.partitionStateHolder.getAllStates();
        for (Map<String, State> groupByStates : states.values()) {
            for (State state : groupByStates.values()) {
                ++state.activeUseCount;
            }
        }
        return states;
    }

    public synchronized Map<String, State> getAllGroupByStates() {
        Map<String, State> groupByStates = this.partitionStateHolder.getAllGroupByStates();
        for (State state : groupByStates.values()) {
            ++state.activeUseCount;
        }
        return groupByStates;
    }

    public synchronized State cleanGroupByStates() {
        return this.partitionStateHolder.cleanGroupByStates();
    }

    public synchronized void returnGroupByStates(Map states) {
        for (State state : states.values()) {
            --state.activeUseCount;
        }
        this.partitionStateHolder.returnGroupByStates(states);
    }

    public synchronized void returnAllStates(Map states) {
        for (Map groupByStates : states.values()) {
            for (State state : groupByStates.values()) {
                --state.activeUseCount;
            }
        }
        this.partitionStateHolder.returnAllStates(states);
    }
}

