/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.processor.filter;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.query.api.definition.Attribute;
import java.util.List;

public class FilterProcessor
implements Processor {
    protected Processor next;
    private ExpressionExecutor conditionExecutor;

    public FilterProcessor(ExpressionExecutor conditionExecutor) {
        if (!Attribute.Type.BOOL.equals((Object)conditionExecutor.getReturnType())) {
            throw new OperationNotSupportedException("Return type of " + conditionExecutor.toString() + " should be of type BOOL. Actual type: " + conditionExecutor.getReturnType().toString());
        }
        this.conditionExecutor = conditionExecutor;
    }

    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        while (complexEventChunk.hasNext()) {
            Object complexEvent = complexEventChunk.next();
            Object result = this.conditionExecutor.execute((ComplexEvent)complexEvent);
            if (result != null && ((Boolean)result).booleanValue()) continue;
            complexEventChunk.remove();
        }
        if (complexEventChunk.getFirst() != null) {
            this.next.process(complexEventChunk);
        }
    }

    @Override
    public void process(List<ComplexEventChunk> complexEventChunks) {
        ComplexEventChunk complexEventChunk = new ComplexEventChunk();
        for (ComplexEventChunk streamEventChunk : complexEventChunks) {
            complexEventChunk.addAll(streamEventChunk);
        }
        this.process(complexEventChunk);
    }

    @Override
    public Processor getNextProcessor() {
        return this.next;
    }

    @Override
    public void setNextProcessor(Processor processor) {
        this.next = processor;
    }

    @Override
    public void setToLast(Processor processor) {
        if (this.next == null) {
            this.next = processor;
        } else {
            this.next.setToLast(processor);
        }
    }
}

