/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.stream.input.source;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.exception.MappingFailedException;
import io.siddhi.core.stream.input.InputHandler;
import io.siddhi.core.stream.input.source.AttributeMapping;
import io.siddhi.core.stream.input.source.InputEventHandler;
import io.siddhi.core.stream.input.source.InputEventHandlerCallback;
import io.siddhi.core.stream.input.source.PassThroughSourceHandler;
import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.core.stream.input.source.SourceHandler;
import io.siddhi.core.stream.input.source.SourceSyncCallback;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.error.handler.model.ErroneousEvent;
import io.siddhi.core.util.error.handler.util.ErrorOccurrence;
import io.siddhi.core.util.error.handler.util.ErrorStoreHelper;
import io.siddhi.core.util.parser.helper.QueryParserHelper;
import io.siddhi.core.util.statistics.LatencyTracker;
import io.siddhi.core.util.statistics.ReceivedEventCounter;
import io.siddhi.core.util.statistics.ThroughputTracker;
import io.siddhi.core.util.statistics.metrics.Level;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.query.api.definition.StreamDefinition;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class SourceMapper
implements SourceEventListener {
    private static final Logger log = Logger.getLogger(SourceMapper.class);
    private final ThreadLocal<Object[]> trpProperties = new ThreadLocal();
    private final ThreadLocal<String[]> trpSyncProperties = new ThreadLocal();
    protected String sourceType;
    protected OptionHolder sourceOptionHolder;
    private InputEventHandler inputEventHandler;
    private StreamDefinition streamDefinition;
    private String mapType;
    private List<AttributeMapping> transportMappings;
    private SourceHandler sourceHandler;
    private SiddhiAppContext siddhiAppContext;
    private ThroughputTracker throughputTracker;
    private LatencyTracker mapperLatencyTracker;
    private int loggingDuration = 1;
    private boolean logEventCount = false;
    private ReceivedEventCounter receivedEventCounter;
    private boolean firstRun = true;

    public final void init(StreamDefinition streamDefinition, String mapType, OptionHolder mapOptionHolder, List<AttributeMapping> attributeMappings, String sourceType, SourceSyncCallback sourceSyncCallback, List<AttributeMapping> transportMappings, SourceHandler sourceHandler, OptionHolder sourceOptionHolder, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        this.streamDefinition = streamDefinition;
        this.mapType = mapType;
        this.sourceType = sourceType;
        this.transportMappings = transportMappings;
        this.sourceOptionHolder = sourceOptionHolder;
        if (sourceHandler != null) {
            sourceHandler.initSourceHandler(siddhiAppContext.getName(), sourceSyncCallback, streamDefinition, siddhiAppContext);
        }
        this.sourceHandler = sourceHandler;
        this.siddhiAppContext = siddhiAppContext;
        if (siddhiAppContext.getStatisticsManager() != null) {
            this.throughputTracker = QueryParserHelper.createThroughputTracker(siddhiAppContext, streamDefinition.getId(), "Sources", sourceType);
            this.mapperLatencyTracker = QueryParserHelper.createLatencyTracker(siddhiAppContext, streamDefinition.getId(), "SourceMappers", sourceType + "." + mapType);
        }
        if (configReader != null && configReader.getAllConfigs().size() != 0 && configReader.getAllConfigs().containsKey("enableLoggingEventCount") && configReader.getAllConfigs().get("enableLoggingEventCount").toLowerCase().equals("true")) {
            this.logEventCount = true;
            this.receivedEventCounter = new ReceivedEventCounter();
            if (configReader.getAllConfigs().containsKey("loggingDuration")) {
                this.loggingDuration = Integer.parseInt(configReader.getAllConfigs().get("loggingDuration"));
            }
            this.receivedEventCounter.init(siddhiAppContext, streamDefinition, this.loggingDuration);
        }
        this.init(streamDefinition, mapOptionHolder, attributeMappings, configReader, siddhiAppContext);
    }

    public abstract void init(StreamDefinition var1, OptionHolder var2, List<AttributeMapping> var3, ConfigReader var4, SiddhiAppContext var5);

    public abstract Class[] getSupportedInputEventClasses();

    public final void setInputHandler(InputHandler inputHandler) {
        InputEventHandlerCallback inputEventHandlerCallback;
        if (this.sourceHandler != null) {
            this.sourceHandler.setInputHandler(inputHandler);
            inputEventHandlerCallback = this.sourceHandler;
        } else {
            inputEventHandlerCallback = new PassThroughSourceHandler(inputHandler);
        }
        this.inputEventHandler = new InputEventHandler(inputHandler, this.transportMappings, this.trpProperties, this.trpSyncProperties, this.sourceType, this.mapperLatencyTracker, this.siddhiAppContext, inputEventHandlerCallback);
    }

    @Override
    public final void onEvent(Object eventObject, String[] transportProperties) {
        Object[] transportPropertyObjects = this.convertToObjectArray(transportProperties);
        this.onEvent(eventObject, transportPropertyObjects, null);
    }

    @Override
    public final void onEvent(Object eventObject, Object[] transportProperties) {
        this.onEvent(eventObject, transportProperties, null);
    }

    @Override
    public final void onEvent(Object eventObject, String[] transportProperties, String[] transportSyncProperties) {
        Object[] transportPropertyObjects = this.convertToObjectArray(transportProperties);
        this.onEvent(eventObject, transportPropertyObjects, transportSyncProperties);
    }

    private Object[] convertToObjectArray(String[] transportProperties) {
        Object[] transportPropertyObjects = null;
        if (transportProperties != null) {
            transportPropertyObjects = new Object[transportProperties.length];
            for (String transportProperty : transportProperties) {
                transportPropertyObjects[i] = transportProperty;
            }
        }
        return transportPropertyObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onEvent(Object eventObject, Object[] transportProperties, String[] transportSyncProperties) {
        block20: {
            try {
                if (eventObject == null) break block20;
                if (!this.allowNullInTransportProperties() && transportProperties != null) {
                    for (Object property : transportProperties) {
                        if (property != null) continue;
                        log.error((Object)("Dropping event " + eventObject.toString() + " belonging to stream " + this.streamDefinition.getId() + " as it contains null transport properties and system is configured to not allow null transport properties. You can configure it via source mapper if the respective mapper type allows it. Refer mapper documentation to verify supportability"));
                        return;
                    }
                }
                this.trpProperties.set(transportProperties);
                if (transportSyncProperties != null) {
                    this.trpSyncProperties.set(transportSyncProperties);
                }
                try {
                    if (this.throughputTracker != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                        this.throughputTracker.eventIn();
                    }
                    if (this.throughputTracker != null && Level.DETAIL.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                        this.mapperLatencyTracker.markIn();
                    }
                    this.mapAndProcess(eventObject, this.inputEventHandler);
                    if (this.logEventCount) {
                        if (this.firstRun) {
                            this.receivedEventCounter.scheduleEventCounterLogger();
                            this.firstRun = false;
                        }
                        this.receivedEventCounter.countEvents(eventObject);
                    }
                }
                finally {
                    if (this.throughputTracker != null && Level.DETAIL.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                        this.mapperLatencyTracker.markOut();
                    }
                }
            }
            catch (MappingFailedException e) {
                ErrorStoreHelper.storeErroneousEvent(this.siddhiAppContext.getSiddhiContext().getErrorStore(), ErrorOccurrence.BEFORE_SOURCE_MAPPING, this.siddhiAppContext.getName(), e.getFailures(), this.streamDefinition.getId());
                log.error((Object)("Error while processing '" + eventObject + "', for the input Mapping '" + this.mapType + "' for the stream '" + this.streamDefinition.getId() + "'."), (Throwable)e);
            }
            catch (InterruptedException | RuntimeException e) {
                ErroneousEvent erroneousEvent = new ErroneousEvent(eventObject, e, "Error while processing '" + eventObject + "', for the input Mapping '" + this.mapType + "' for the stream '" + this.streamDefinition.getId() + "'.");
                ErrorStoreHelper.storeErroneousEvent(this.siddhiAppContext.getSiddhiContext().getErrorStore(), ErrorOccurrence.BEFORE_SOURCE_MAPPING, this.siddhiAppContext.getName(), Collections.singletonList(erroneousEvent), this.streamDefinition.getId());
                log.error((Object)("Error while processing '" + eventObject + "', for the input Mapping '" + this.mapType + "' for the stream '" + this.streamDefinition.getId() + "'."), (Throwable)e);
            }
            finally {
                this.trpProperties.remove();
                if (transportSyncProperties != null) {
                    this.trpSyncProperties.remove();
                }
            }
        }
    }

    public SourceHandler getHandler() {
        return this.sourceHandler;
    }

    @Override
    public final StreamDefinition getStreamDefinition() {
        return this.streamDefinition;
    }

    public long getEventCount() {
        return this.inputEventHandler.getEventCount();
    }

    protected abstract void mapAndProcess(Object var1, InputEventHandler var2) throws MappingFailedException, InterruptedException;

    protected abstract boolean allowNullInTransportProperties();
}

