/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.error.handler.util;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.Event;
import io.siddhi.core.util.error.handler.model.ErroneousEvent;
import io.siddhi.core.util.error.handler.store.ErrorStore;
import io.siddhi.core.util.error.handler.util.ErroneousEventType;
import io.siddhi.core.util.error.handler.util.ErrorOccurrence;
import java.util.List;

public class ErrorStoreHelper {
    private ErrorStoreHelper() {
    }

    public static void storeErroneousEvent(ErrorStore errorStore, ErrorOccurrence occurrence, String siddhiAppName, Object erroneousEvent, String streamName) {
        if (errorStore != null && erroneousEvent != null) {
            if (occurrence == ErrorOccurrence.BEFORE_SOURCE_MAPPING && erroneousEvent instanceof List) {
                errorStore.saveBeforeSourceMappingError(siddhiAppName, (List)erroneousEvent, streamName);
            } else if (occurrence == ErrorOccurrence.STORE_ON_SINK_ERROR) {
                errorStore.saveOnSinkError(siddhiAppName, (ErroneousEvent)erroneousEvent, ErrorStoreHelper.getErroneousEventType(((ErroneousEvent)erroneousEvent).getEvent()), streamName);
            } else if (occurrence == ErrorOccurrence.STORE_ON_STREAM_ERROR) {
                errorStore.saveOnStreamError(siddhiAppName, (ErroneousEvent)erroneousEvent, ErrorStoreHelper.getErroneousEventType(((ErroneousEvent)erroneousEvent).getEvent()), streamName);
            }
        }
    }

    private static ErroneousEventType getErroneousEventType(Object event) {
        if (event instanceof ComplexEvent) {
            return ErroneousEventType.COMPLEX_EVENT;
        }
        if (event instanceof Event) {
            return ErroneousEventType.EVENT;
        }
        if (event instanceof Event[]) {
            return ErroneousEventType.EVENT_ARRAY;
        }
        if (event instanceof List) {
            return ErroneousEventType.EVENT_LIST;
        }
        return ErroneousEventType.PAYLOAD_STRING;
    }
}

