/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core;

import io.siddhi.core.SiddhiAppRuntime;
import io.siddhi.core.config.SiddhiContext;
import io.siddhi.core.config.StatisticsConfiguration;
import io.siddhi.core.exception.CannotRestoreSiddhiAppStateException;
import io.siddhi.core.stream.input.source.SourceHandlerManager;
import io.siddhi.core.stream.output.sink.SinkHandlerManager;
import io.siddhi.core.table.record.RecordTableHandlerManager;
import io.siddhi.core.util.SiddhiAppRuntimeBuilder;
import io.siddhi.core.util.config.ConfigManager;
import io.siddhi.core.util.error.handler.store.ErrorStore;
import io.siddhi.core.util.parser.SiddhiAppParser;
import io.siddhi.core.util.persistence.IncrementalPersistenceStore;
import io.siddhi.core.util.persistence.PersistenceStore;
import io.siddhi.query.api.SiddhiApp;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.definition.TableDefinition;
import io.siddhi.query.compiler.SiddhiCompiler;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class SiddhiManager {
    private static final Logger log = Logger.getLogger(SiddhiManager.class);
    private SiddhiContext siddhiContext;
    private ConcurrentMap<String, SiddhiAppRuntime> siddhiAppRuntimeMap = new ConcurrentHashMap<String, SiddhiAppRuntime>();

    public SiddhiManager() {
        this.siddhiContext = new SiddhiContext();
    }

    public Map<String, Object> getAttributes() {
        return this.siddhiContext.getAttributes();
    }

    public void setAttribute(String key, Object value) {
        this.siddhiContext.setAttribute(key, value);
    }

    public SiddhiAppRuntime createSiddhiAppRuntime(SiddhiApp siddhiApp) {
        return this.createSiddhiAppRuntime(siddhiApp, null);
    }

    private SiddhiAppRuntime createSiddhiAppRuntime(SiddhiApp siddhiApp, String siddhiAppString) {
        SiddhiAppRuntimeBuilder siddhiAppRuntimeBuilder = SiddhiAppParser.parse(siddhiApp, siddhiAppString, this.siddhiContext);
        siddhiAppRuntimeBuilder.setSiddhiAppRuntimeMap(this.siddhiAppRuntimeMap);
        SiddhiAppRuntime siddhiAppRuntime = siddhiAppRuntimeBuilder.build();
        this.siddhiAppRuntimeMap.put(siddhiAppRuntime.getName(), siddhiAppRuntime);
        return siddhiAppRuntime;
    }

    public SiddhiAppRuntime createSiddhiAppRuntime(String siddhiApp) {
        String updatedSiddhiApp = SiddhiCompiler.updateVariables((String)siddhiApp);
        return this.createSiddhiAppRuntime(SiddhiCompiler.parse((String)updatedSiddhiApp), updatedSiddhiApp);
    }

    public SiddhiAppRuntime createSandboxSiddhiAppRuntime(String siddhiApp) {
        String updatedSiddhiApp = SiddhiCompiler.updateVariables((String)siddhiApp);
        return this.createSiddhiAppRuntime(this.removeSourceSinkAndStoreAnnotations(SiddhiCompiler.parse((String)updatedSiddhiApp)), updatedSiddhiApp);
    }

    public SiddhiAppRuntime createSandboxSiddhiAppRuntime(SiddhiApp siddhiApp) {
        return this.createSiddhiAppRuntime(this.removeSourceSinkAndStoreAnnotations(siddhiApp), null);
    }

    private SiddhiApp removeSourceSinkAndStoreAnnotations(SiddhiApp siddhiApp) {
        for (StreamDefinition streamDefinition : siddhiApp.getStreamDefinitionMap().values()) {
            streamDefinition.getAnnotations().removeIf(annotation -> (annotation.getName().equalsIgnoreCase("Source") || annotation.getName().equalsIgnoreCase("Sink")) && !annotation.getElement("type").equalsIgnoreCase("inMemory"));
        }
        for (TableDefinition tableDefinition : siddhiApp.getTableDefinitionMap().values()) {
            tableDefinition.getAnnotations().removeIf(annotation -> annotation.getName().equalsIgnoreCase("Store"));
        }
        return siddhiApp;
    }

    public SiddhiAppRuntime getSiddhiAppRuntime(String siddhiAppName) {
        return (SiddhiAppRuntime)this.siddhiAppRuntimeMap.get(siddhiAppName);
    }

    public void validateSiddhiApp(SiddhiApp siddhiApp) {
        this.validateSiddhiApp(siddhiApp, null);
    }

    private void validateSiddhiApp(SiddhiApp siddhiApp, String siddhiAppString) {
        SiddhiAppRuntime siddhiAppRuntime = SiddhiAppParser.parse(siddhiApp, siddhiAppString, this.siddhiContext).build();
        siddhiAppRuntime.start();
        siddhiAppRuntime.shutdown();
    }

    public void validateSiddhiApp(String siddhiApp) {
        String updatedSiddhiApp = SiddhiCompiler.updateVariables((String)siddhiApp);
        this.validateSiddhiApp(SiddhiCompiler.parse((String)updatedSiddhiApp), updatedSiddhiApp);
    }

    public void setPersistenceStore(PersistenceStore persistenceStore) {
        this.siddhiContext.setPersistenceStore(persistenceStore);
    }

    public void setErrorStore(ErrorStore errorStore) {
        this.siddhiContext.setErrorStore(errorStore);
    }

    public void setSinkHandlerManager(SinkHandlerManager sinkHandlerManager) {
        this.siddhiContext.setSinkHandlerManager(sinkHandlerManager);
    }

    public void setSourceHandlerManager(SourceHandlerManager sourceHandlerManager) {
        this.siddhiContext.setSourceHandlerManager(sourceHandlerManager);
    }

    public void setRecordTableHandlerManager(RecordTableHandlerManager recordTableHandlerManager) {
        this.siddhiContext.setRecordTableHandlerManager(recordTableHandlerManager);
    }

    public void setConfigManager(ConfigManager configManager) {
        this.siddhiContext.setConfigManager(configManager);
    }

    public void setExtension(String name, Class clazz) {
        Class previousClass = this.siddhiContext.getSiddhiExtensions().put(name, clazz);
        if (previousClass != null) {
            log.warn((Object)("Dropping extension '" + previousClass + "' as '" + clazz + "' is loaded with the same namespace and name '" + name + "'"));
        }
    }

    public Map<String, Class> getExtensions() {
        return this.siddhiContext.getSiddhiExtensions();
    }

    public void removeExtension(String name) {
        this.siddhiContext.getSiddhiExtensions().remove(name);
    }

    public void setDataSource(String dataSourceName, DataSource dataSource) {
        this.siddhiContext.addSiddhiDataSource(dataSourceName, dataSource);
    }

    public void setStatisticsConfiguration(StatisticsConfiguration statisticsConfiguration) {
        this.siddhiContext.setStatisticsConfiguration(statisticsConfiguration);
    }

    public ConcurrentMap<String, SiddhiAppRuntime> getSiddhiAppRuntimeMap() {
        return this.siddhiAppRuntimeMap;
    }

    public void shutdown() {
        ArrayList siddhiAppNames = new ArrayList(this.siddhiAppRuntimeMap.keySet());
        for (String siddhiAppName : siddhiAppNames) {
            ((SiddhiAppRuntime)this.siddhiAppRuntimeMap.get(siddhiAppName)).shutdown();
        }
    }

    public void persist() {
        for (SiddhiAppRuntime siddhiAppRuntime : this.siddhiAppRuntimeMap.values()) {
            siddhiAppRuntime.persist();
        }
    }

    public void restoreLastState() {
        for (SiddhiAppRuntime siddhiAppRuntime : this.siddhiAppRuntimeMap.values()) {
            try {
                siddhiAppRuntime.restoreLastRevision();
            }
            catch (CannotRestoreSiddhiAppStateException e) {
                log.error((Object)("Error in restoring Siddhi app " + siddhiAppRuntime.getName()), (Throwable)e);
            }
        }
    }

    public String getLastRevision(String siddhiAppName) {
        return this.siddhiContext.getPersistenceStore().getLastRevision(siddhiAppName);
    }

    public void setIncrementalPersistenceStore(IncrementalPersistenceStore incrementalPersistenceStore) {
        this.siddhiContext.setIncrementalPersistenceStore(incrementalPersistenceStore);
    }
}

