/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.processor.stream.window;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiOnDemandQueryContext;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.holder.SnapshotableStreamEventQueue;
import io.siddhi.core.event.stream.holder.StreamEventClonerHolder;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.processor.stream.window.BatchingFindableWindowProcessor;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.collection.operator.Operator;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.parser.ExpressionParser;
import io.siddhi.core.util.parser.OperatorParser;
import io.siddhi.core.util.parser.helper.QueryParserHelper;
import io.siddhi.core.util.snapshot.state.SnapshotStateList;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.compiler.SiddhiCompiler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Extension(name="expressionBatch", namespace="", description="A batch window that dynamically shrink and grow based on the `expression`, it holds events until the `expression` is satisfied, and expires all when the `expression` is not satisfied.When a string is passed as the `expression` it is evaluated from the `first` (oldest) to the `last` (latest/current).\n**Note**: All the events in window are reevaluated only when the given `expression` is changed.", parameters={@Parameter(name="expression", description="The expression to retain events.", type={DataType.STRING, DataType.BOOL}, dynamic=true), @Parameter(name="include.triggering.event", description="Include the event triggered the expiry in to the current event batch.", type={DataType.BOOL}, optional=true, defaultValue="false", dynamic=true), @Parameter(name="stream.current.event", description="Let the window stream the current events out as and when they arrive to the window while expiring them in batches.", type={DataType.BOOL}, optional=true, defaultValue="false")}, parameterOverloads={@ParameterOverload(parameterNames={"expression"}), @ParameterOverload(parameterNames={"expression", "include.triggering.event"}), @ParameterOverload(parameterNames={"expression", "include.triggering.event", "stream.current.event"})}, examples={@Example(syntax="@info(name = 'query1')\nfrom StockEventWindow#window.expressionBatch('count()<=20')\nselect symbol, sum(price) as price\ninsert into OutputStream ;", description="Retain and output 20 events at a time as batch."), @Example(syntax="@info(name = 'query1')\nfrom StockEventWindow#window.expressionBatch(\n       'sum(price) < 100 and eventTimestamp(last) - eventTimestamp(first) < 3000')\nselect symbol, sum(price) as price\ninsert into OutputStream ;", description="Retain and output events having their sum(price) < 100, and the `last` and `first` events are within 3 second difference as a batch."), @Example(syntax="@info(name = 'query1')\nfrom StockEventWindow#window.expressionBatch(\n       'last.symbol==first.symbol')\nselect symbol, sum(price) as price\ninsert into OutputStream ;", description="Output events as a batch when a new symbol type arrives."), @Example(syntax="@info(name = 'query1')\nfrom StockEventWindow#window.expressionBatch(\n       'flush', true)\nselect symbol, sum(price) as price\ninsert into OutputStream ;", description="Output events as a batch when a flush attribute becomes `true`, the output batch will also contain the triggering event."), @Example(syntax="@info(name = 'query1')\nfrom StockEventWindow#window.expressionBatch(\n       'flush', false, true)\nselect symbol, sum(price) as price\ninsert into OutputStream ;", description="Arriving events are emitted as soon as they are arrived, and the retained events are expired when flush attribute becomes `true`, and the output batch will not contain the triggering event.")})
public class ExpressionBatchWindowProcessor
extends BatchingFindableWindowProcessor<WindowState> {
    private ExpressionExecutor expressionExecutor;
    private List<VariableExpressionExecutor> variableExpressionExecutors;
    private boolean init = false;
    private ExpressionExecutor expressionStringExecutor = null;
    private String expressionString = null;
    private boolean includeTriggeringEvent = false;
    private ExpressionExecutor includeTriggeringEventExecutor = null;
    private Boolean streamInputEvents = false;

    @Override
    protected StateFactory init(MetaStreamEvent metaStreamEvent, AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, StreamEventClonerHolder streamEventClonerHolder, boolean outputExpectsExpiredEvents, boolean findToBeExecuted, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor) {
            this.expressionString = (String)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
            this.constructExpression(metaStreamEvent, siddhiQueryContext);
        } else {
            for (Attribute attribute : inputDefinition.getAttributeList()) {
                metaStreamEvent.addData(attribute);
            }
            this.expressionStringExecutor = attributeExpressionExecutors[0];
        }
        if (attributeExpressionExecutors.length > 1) {
            if (attributeExpressionExecutors[1] instanceof ConstantExpressionExecutor) {
                this.includeTriggeringEvent = (Boolean)((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue();
            } else {
                this.includeTriggeringEventExecutor = attributeExpressionExecutors[1];
            }
            if (attributeExpressionExecutors.length > 2 && attributeExpressionExecutors[2] instanceof ConstantExpressionExecutor) {
                this.streamInputEvents = (Boolean)((ConstantExpressionExecutor)attributeExpressionExecutors[2]).getValue();
            }
        }
        return () -> new WindowState();
    }

    @Override
    protected StateFactory<WindowState> init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, StreamEventClonerHolder streamEventClonerHolder, boolean outputExpectsExpiredEvents, boolean findToBeExecuted, SiddhiQueryContext siddhiQueryContext) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, WindowState state) {
        if (this.expressionStringExecutor == null && !this.init) {
            MetaStateEvent metaStateEvent = new MetaStateEvent(new MetaStreamEvent[]{this.metaStreamEvent, this.metaStreamEvent, this.metaStreamEvent});
            QueryParserHelper.updateVariablePosition(metaStateEvent, this.variableExpressionExecutors);
            this.init = true;
        }
        ArrayList<ComplexEventChunk<StreamEvent>> streamEventChunks = new ArrayList<ComplexEventChunk<StreamEvent>>();
        WindowState windowState = state;
        synchronized (windowState) {
            long l = this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime();
            while (streamEventChunk.hasNext()) {
                String expressionStringNew;
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                streamEventChunk.remove();
                if (this.expressionStringExecutor != null && !(expressionStringNew = (String)this.expressionStringExecutor.execute(streamEvent)).equals(this.expressionString)) {
                    this.expressionString = expressionStringNew;
                    this.processAllExpiredEvents(streamEventCloner, state, l, streamEventChunks);
                }
                if (!this.streamInputEvents.booleanValue()) {
                    this.processStreamEvent(state, l, streamEvent, streamEventCloner, streamEventChunks);
                    continue;
                }
                this.processStreamEventAsStream(state, l, streamEvent, streamEventCloner, streamEventChunks, true);
            }
        }
        for (ComplexEventChunk complexEventChunk : streamEventChunks) {
            nextProcessor.process(complexEventChunk);
        }
    }

    private MetaStateEvent constructExpression(MetaStreamEvent metaStreamEvent, SiddhiQueryContext siddhiQueryContext) {
        Expression expression = SiddhiCompiler.parseExpression((String)this.expressionString);
        MetaStreamEventWrapper metaStreamEventFirst = new MetaStreamEventWrapper(metaStreamEvent);
        ((MetaStreamEvent)metaStreamEventFirst).setInputReferenceId("first");
        MetaStreamEventWrapper metaStreamEventLast = new MetaStreamEventWrapper(metaStreamEvent);
        ((MetaStreamEvent)metaStreamEventLast).setInputReferenceId("last");
        MetaStateEvent metaStateEvent = new MetaStateEvent(new MetaStreamEvent[]{metaStreamEvent, metaStreamEventFirst, metaStreamEventLast});
        this.variableExpressionExecutors = new ArrayList<VariableExpressionExecutor>();
        SiddhiOnDemandQueryContext exprQueryContext = new SiddhiOnDemandQueryContext(siddhiQueryContext.getSiddhiAppContext(), siddhiQueryContext.getName(), this.expressionString);
        this.expressionExecutor = ExpressionParser.parseExpression(expression, metaStateEvent, 0, new HashMap<String, Table>(), this.variableExpressionExecutors, false, 0, ProcessingMode.SLIDE, true, exprQueryContext);
        if (this.expressionExecutor.getReturnType() != Attribute.Type.BOOL) {
            throw new SiddhiAppRuntimeException("Expression ('" + this.expressionString + "') does not return Bool");
        }
        return metaStateEvent;
    }

    private void processAllExpiredEvents(StreamEventCloner streamEventCloner, WindowState state, long currentTime, List<ComplexEventChunk<StreamEvent>> streamEventChunks) {
        MetaStateEvent metaStateEvent = this.constructExpression(this.metaStreamEvent, this.siddhiQueryContext);
        QueryParserHelper.updateVariablePosition(metaStateEvent, this.variableExpressionExecutors);
        if (!this.streamInputEvents.booleanValue()) {
            state.currentEventQueue.clear();
            for (StreamEvent expiredEvent = state.currentEventQueue.getFirst(); expiredEvent != null; expiredEvent = expiredEvent.getNext()) {
                StreamEvent aExpiredEvent = expiredEvent;
                aExpiredEvent.setNext(null);
                this.processStreamEvent(state, currentTime, aExpiredEvent, streamEventCloner, streamEventChunks);
            }
            state.currentEventQueue.reset();
        } else {
            state.expiredEventQueue.clear();
            for (StreamEvent expiredEvent = state.expiredEventQueue.getFirst(); expiredEvent != null; expiredEvent = expiredEvent.getNext()) {
                StreamEvent aExpiredEvent = expiredEvent;
                aExpiredEvent.setNext(null);
                this.processStreamEventAsStream(state, currentTime, aExpiredEvent, streamEventCloner, streamEventChunks, false);
            }
            state.expiredEventQueue.reset();
        }
    }

    private void processStreamEvent(WindowState state, long currentTime, StreamEvent streamEvent, StreamEventCloner streamEventCloner, List<ComplexEventChunk<StreamEvent>> streamEventChunks) {
        StateEvent stateEventCurrent = new StateEvent(3, 0);
        stateEventCurrent.setEvent(0, streamEvent);
        if (state.currentEventQueue.getFirst() != null) {
            stateEventCurrent.setEvent(1, state.currentEventQueue.getFirst());
        } else {
            stateEventCurrent.setEvent(1, streamEvent);
        }
        stateEventCurrent.setEvent(2, streamEvent);
        if (!((Boolean)this.expressionExecutor.execute(stateEventCurrent)).booleanValue()) {
            StreamEvent expiredEvent;
            stateEventCurrent.setType(ComplexEvent.Type.RESET);
            this.expressionExecutor.execute(stateEventCurrent);
            stateEventCurrent.setType(ComplexEvent.Type.CURRENT);
            this.expressionExecutor.execute(stateEventCurrent);
            ComplexEventChunk<StreamEvent> outputStreamEventChunk = new ComplexEventChunk<StreamEvent>();
            state.expiredEventQueue.reset();
            if (state.expiredEventQueue.getFirst() != null) {
                while (state.expiredEventQueue.hasNext()) {
                    expiredEvent = state.expiredEventQueue.next();
                    expiredEvent.setTimestamp(currentTime);
                }
                outputStreamEventChunk.add(state.expiredEventQueue.getFirst());
                state.expiredEventQueue.clear();
            }
            if (state.currentEventQueue.getFirst() != null) {
                while (state.currentEventQueue.hasNext()) {
                    StreamEvent currentEvent = state.currentEventQueue.next();
                    currentEvent.setTimestamp(currentTime);
                    StreamEvent expiredEvent2 = streamEventCloner.copyStreamEvent(currentEvent);
                    expiredEvent2.setType(ComplexEvent.Type.EXPIRED);
                    state.expiredEventQueue.add(expiredEvent2);
                }
                outputStreamEventChunk.add(state.currentEventQueue.getFirst());
                state.currentEventQueue.clear();
                if (this.includeTriggeringEventExecutor != null && ((Boolean)this.includeTriggeringEventExecutor.execute(streamEvent)).booleanValue() || this.includeTriggeringEvent) {
                    outputStreamEventChunk.add(streamEvent);
                    expiredEvent = streamEventCloner.copyStreamEvent(streamEvent);
                    expiredEvent.setTimestamp(currentTime);
                    expiredEvent.setType(ComplexEvent.Type.EXPIRED);
                    state.expiredEventQueue.add(expiredEvent);
                } else {
                    state.currentEventQueue.add(streamEvent);
                }
            } else {
                expiredEvent = streamEventCloner.copyStreamEvent(streamEvent);
                expiredEvent.setType(ComplexEvent.Type.EXPIRED);
                expiredEvent.setTimestamp(currentTime);
                outputStreamEventChunk.add(expiredEvent);
                streamEvent.setTimestamp(currentTime);
                outputStreamEventChunk.add(streamEvent);
            }
            streamEventChunks.add(outputStreamEventChunk);
        } else {
            state.currentEventQueue.add(streamEvent);
        }
    }

    private void processStreamEventAsStream(WindowState state, long currentTime, StreamEvent streamEvent, StreamEventCloner streamEventCloner, List<ComplexEventChunk<StreamEvent>> streamEventChunks, boolean output) {
        StateEvent stateEventCurrent = new StateEvent(3, 0);
        stateEventCurrent.setEvent(0, streamEvent);
        if (state.expiredEventQueue.getFirst() != null) {
            stateEventCurrent.setEvent(1, state.expiredEventQueue.getFirst());
        } else {
            stateEventCurrent.setEvent(1, streamEvent);
        }
        stateEventCurrent.setEvent(2, streamEvent);
        ComplexEventChunk<StreamEvent> outputStreamEventChunk = new ComplexEventChunk<StreamEvent>();
        if (output && state.currentEventQueue.getFirst() != null) {
            outputStreamEventChunk.add(state.currentEventQueue.getFirst());
            state.currentEventQueue.clear();
        }
        if (!((Boolean)this.expressionExecutor.execute(stateEventCurrent)).booleanValue()) {
            stateEventCurrent.setType(ComplexEvent.Type.RESET);
            this.expressionExecutor.execute(stateEventCurrent);
            stateEventCurrent.setType(ComplexEvent.Type.CURRENT);
            this.expressionExecutor.execute(stateEventCurrent);
            state.expiredEventQueue.reset();
            if (state.expiredEventQueue.getFirst() != null) {
                StreamEvent expiredEvent;
                while (state.expiredEventQueue.hasNext()) {
                    expiredEvent = state.expiredEventQueue.next();
                    expiredEvent.setTimestamp(currentTime);
                }
                expiredEvent = streamEventCloner.copyStreamEvent(streamEvent);
                expiredEvent.setType(ComplexEvent.Type.EXPIRED);
                if (this.includeTriggeringEventExecutor != null && ((Boolean)this.includeTriggeringEventExecutor.execute(streamEvent)).booleanValue() || this.includeTriggeringEvent) {
                    outputStreamEventChunk.add(streamEvent);
                    if (output) {
                        outputStreamEventChunk.add(state.expiredEventQueue.getFirst());
                        expiredEvent.setTimestamp(currentTime);
                        outputStreamEventChunk.add(expiredEvent);
                    } else {
                        state.currentEventQueue.add(state.expiredEventQueue.getFirst());
                        state.currentEventQueue.add(expiredEvent);
                    }
                    state.expiredEventQueue.clear();
                } else {
                    if (output) {
                        outputStreamEventChunk.add(state.expiredEventQueue.getFirst());
                    } else {
                        state.currentEventQueue.add(state.expiredEventQueue.getFirst());
                    }
                    outputStreamEventChunk.add(streamEvent);
                    state.expiredEventQueue.clear();
                    state.expiredEventQueue.add(expiredEvent);
                }
            } else if (output) {
                StreamEvent expiredEvent = streamEventCloner.copyStreamEvent(streamEvent);
                expiredEvent.setType(ComplexEvent.Type.EXPIRED);
                expiredEvent.setTimestamp(currentTime);
                outputStreamEventChunk.add(expiredEvent);
                streamEvent.setTimestamp(currentTime);
                outputStreamEventChunk.add(streamEvent);
            } else {
                state.currentEventQueue.add(streamEvent);
            }
            if (output) {
                streamEventChunks.add(outputStreamEventChunk);
            }
        } else {
            StreamEvent expiredEvent = streamEventCloner.copyStreamEvent(streamEvent);
            expiredEvent.setType(ComplexEvent.Type.EXPIRED);
            state.expiredEventQueue.add(expiredEvent);
            if (output) {
                outputStreamEventChunk.add(streamEvent);
                streamEventChunks.add(outputStreamEventChunk);
            }
        }
    }

    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, WindowState state, SiddhiQueryContext siddhiQueryContext) {
        return OperatorParser.constructOperator(state.currentEventQueue, condition, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition, StreamEventCloner streamEventCloner, WindowState state) {
        return ((Operator)compiledCondition).find(matchingEvent, state.currentEventQueue, streamEventCloner);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    class MetaStreamEventWrapper
    extends MetaStreamEvent {
        private MetaStreamEvent metaStreamEvent;
        private String inputReferenceId;

        public MetaStreamEventWrapper(MetaStreamEvent metaStreamEvent) {
            this.metaStreamEvent = metaStreamEvent;
        }

        @Override
        public List<Attribute> getBeforeWindowData() {
            return this.metaStreamEvent.getBeforeWindowData();
        }

        @Override
        public List<Attribute> getOnAfterWindowData() {
            return this.metaStreamEvent.getOnAfterWindowData();
        }

        @Override
        public List<Attribute> getOutputData() {
            return this.metaStreamEvent.getOutputData();
        }

        @Override
        public void initializeOnAfterWindowData() {
            this.metaStreamEvent.initializeOnAfterWindowData();
        }

        @Override
        public void initializeAfterWindowData() {
            this.metaStreamEvent.initializeAfterWindowData();
        }

        @Override
        public int addData(Attribute attribute) {
            return this.metaStreamEvent.addData(attribute);
        }

        @Override
        public void addOutputData(Attribute attribute) {
            this.metaStreamEvent.addOutputData(attribute);
        }

        @Override
        public void addOutputDataAllowingDuplicate(Attribute attribute) {
            this.metaStreamEvent.addOutputDataAllowingDuplicate(attribute);
        }

        @Override
        public List<AbstractDefinition> getInputDefinitions() {
            return this.metaStreamEvent.getInputDefinitions();
        }

        @Override
        public void addInputDefinition(AbstractDefinition inputDefinition) {
            this.metaStreamEvent.addInputDefinition(inputDefinition);
        }

        @Override
        public String getInputReferenceId() {
            return this.inputReferenceId;
        }

        @Override
        public void setInputReferenceId(String inputReferenceId) {
            this.inputReferenceId = inputReferenceId;
        }

        @Override
        public void setOutputDefinition(StreamDefinition streamDefinition) {
            this.metaStreamEvent.setOutputDefinition(streamDefinition);
        }

        @Override
        public StreamDefinition getOutputStreamDefinition() {
            return this.metaStreamEvent.getOutputStreamDefinition();
        }

        @Override
        public MetaStreamEvent.EventType getEventType() {
            return this.metaStreamEvent.getEventType();
        }

        @Override
        public void setEventType(MetaStreamEvent.EventType eventType) {
            this.metaStreamEvent.setEventType(eventType);
        }

        @Override
        public AbstractDefinition getLastInputDefinition() {
            return this.metaStreamEvent.getLastInputDefinition();
        }

        @Override
        public boolean isMultiValue() {
            return this.metaStreamEvent.isMultiValue();
        }

        @Override
        public void setMultiValue(boolean multiValue) {
            this.metaStreamEvent.setMultiValue(multiValue);
        }

        @Override
        public MetaStreamEvent clone() {
            return this.metaStreamEvent.clone();
        }
    }

    class WindowState
    extends State {
        private SnapshotableStreamEventQueue currentEventQueue;
        private SnapshotableStreamEventQueue expiredEventQueue;

        WindowState() {
            this.currentEventQueue = new SnapshotableStreamEventQueue(ExpressionBatchWindowProcessor.this.streamEventClonerHolder);
            this.expiredEventQueue = new SnapshotableStreamEventQueue(ExpressionBatchWindowProcessor.this.streamEventClonerHolder);
        }

        @Override
        public boolean canDestroy() {
            return this.currentEventQueue.getFirst() == null && this.expiredEventQueue.getFirst() == null;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("CurrentEventQueue", this.currentEventQueue.getSnapshot());
            state.put("ExpiredEventQueue", this.expiredEventQueue.getSnapshot());
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.currentEventQueue.clear();
            this.currentEventQueue.restore((SnapshotStateList)state.get("CurrentEventQueue"));
            this.expiredEventQueue.restore((SnapshotStateList)state.get("ExpiredEventQueue"));
        }
    }
}

