/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.aggregator;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.extension.validator.InputParameterValidator;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.snapshot.state.StateHolder;

public abstract class AttributeAggregatorExecutor<S extends State>
implements ExpressionExecutor {
    protected ExpressionExecutor[] attributeExpressionExecutors;
    private int attributeSize;
    private StateHolder<S> stateHolder;

    public void initAggregator(ExpressionExecutor[] attributeExpressionExecutors, ProcessingMode processingMode, boolean outputExpectsExpiredEvents, ConfigReader configReader, boolean groupBy, SiddhiQueryContext siddhiQueryContext) {
        try {
            this.attributeExpressionExecutors = attributeExpressionExecutors;
            this.attributeSize = attributeExpressionExecutors.length;
            InputParameterValidator.validateExpressionExecutors(this, attributeExpressionExecutors);
            StateFactory<S> stateFactory = this.init(attributeExpressionExecutors, processingMode, outputExpectsExpiredEvents, configReader, siddhiQueryContext);
            this.stateHolder = siddhiQueryContext.generateStateHolder(this.getClass().getName(), groupBy, stateFactory, true);
        }
        catch (Throwable t) {
            throw new SiddhiAppCreationException(t);
        }
    }

    @Override
    public Object execute(ComplexEvent event) {
        if (this.attributeSize > 1) {
            return this.processAttributeArray(event);
        }
        if (this.attributeSize == 1) {
            return this.processAttribute(event);
        }
        return this.processNoAttribute(event);
    }

    private Object processAttributeArray(ComplexEvent event) {
        Object[] data = new Object[this.attributeSize];
        for (int i = 0; i < this.attributeSize; ++i) {
            data[i] = this.attributeExpressionExecutors[i].execute(event);
        }
        switch (event.getType()) {
            case CURRENT: {
                return this.processAdd(data);
            }
            case EXPIRED: {
                return this.processRemove(data);
            }
            case RESET: {
                return this.processReset();
            }
        }
        return null;
    }

    private Object processAttribute(ComplexEvent event) {
        switch (event.getType()) {
            case CURRENT: {
                return this.processAdd(this.attributeExpressionExecutors[0].execute(event));
            }
            case EXPIRED: {
                return this.processRemove(this.attributeExpressionExecutors[0].execute(event));
            }
            case RESET: {
                return this.processReset();
            }
        }
        return null;
    }

    private Object processNoAttribute(ComplexEvent event) {
        switch (event.getType()) {
            case CURRENT: {
                return this.processAdd(null);
            }
            case EXPIRED: {
                return this.processRemove(null);
            }
            case RESET: {
                return this.processReset();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processAdd(Object data) {
        S state = this.stateHolder.getState();
        try {
            Object object = this.processAdd(data, state);
            return object;
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processRemove(Object data) {
        S state = this.stateHolder.getState();
        try {
            Object object = this.processRemove(data, state);
            return object;
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processAdd(Object[] data) {
        S state = this.stateHolder.getState();
        try {
            Object object = this.processAdd(data, state);
            return object;
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processRemove(Object[] data) {
        S state = this.stateHolder.getState();
        try {
            Object object = this.processRemove(data, state);
            return object;
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    private Object processReset() {
        S state = this.stateHolder.cleanGroupByStates();
        if (state != null) {
            return this.reset(state);
        }
        return null;
    }

    protected abstract StateFactory<S> init(ExpressionExecutor[] var1, ProcessingMode var2, boolean var3, ConfigReader var4, SiddhiQueryContext var5);

    public abstract Object processAdd(Object var1, S var2);

    public abstract Object processAdd(Object[] var1, S var2);

    public abstract Object processRemove(Object var1, S var2);

    public abstract Object processRemove(Object[] var1, S var2);

    public abstract Object reset(S var1);
}

