/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.stream.input.source;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.Event;
import io.siddhi.core.exception.MappingFailedException;
import io.siddhi.core.stream.input.source.AttributeMapping;
import io.siddhi.core.stream.input.source.InputEventHandler;
import io.siddhi.core.stream.input.source.SourceMapper;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.error.handler.model.ErroneousEvent;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.query.api.definition.StreamDefinition;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

@Extension(name="passThrough", namespace="sourceMapper", description="Pass-through mapper passed events (Event[]) through without any mapping or modifications.", examples={@Example(syntax="@source(type='tcp', @map(type='passThrough'))\ndefine stream BarStream (symbol string, price float, volume long);", description="In this example BarStream uses passThrough inputmapper which passes the received Siddhi event directly without any transformation into source.")})
public class PassThroughSourceMapper
extends SourceMapper {
    private static final Logger LOG = Logger.getLogger(PassThroughSourceMapper.class);

    @Override
    public void init(StreamDefinition streamDefinition, OptionHolder optionHolder, List<AttributeMapping> attributeMappingList, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
    }

    @Override
    public Class[] getSupportedInputEventClasses() {
        return new Class[]{Event.class, Event[].class, Object[].class};
    }

    @Override
    protected void mapAndProcess(Object eventObject, InputEventHandler inputEventHandler) throws MappingFailedException, InterruptedException {
        if (eventObject != null) {
            if (eventObject instanceof Event[]) {
                inputEventHandler.sendEvents((Event[])eventObject);
            } else if (eventObject instanceof Event) {
                inputEventHandler.sendEvent((Event)eventObject);
            } else if (eventObject instanceof Object[]) {
                Event event = new Event(-1L, (Object[])eventObject);
                inputEventHandler.sendEvent(event);
            } else {
                throw new MappingFailedException(Collections.singletonList(new ErroneousEvent(eventObject, "Event object must be either Event[], Event or Object[] but found " + eventObject.getClass().getCanonicalName())));
            }
        }
    }

    @Override
    protected boolean allowNullInTransportProperties() {
        return false;
    }
}

