/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.table.record;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.event.state.MetaStateEventAttribute;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.state.StateEventFactory;
import io.siddhi.core.event.state.populater.StateEventPopulatorFactory;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.stream.window.QueryableProcessor;
import io.siddhi.core.query.selector.QuerySelector;
import io.siddhi.core.table.CacheTable;
import io.siddhi.core.table.CacheTableFIFO;
import io.siddhi.core.table.CacheTableLFU;
import io.siddhi.core.table.CacheTableLRU;
import io.siddhi.core.table.CompiledUpdateSet;
import io.siddhi.core.table.InMemoryTable;
import io.siddhi.core.table.Table;
import io.siddhi.core.table.record.AbstractRecordTable;
import io.siddhi.core.table.record.ExpressionBuilder;
import io.siddhi.core.table.record.RecordIterator;
import io.siddhi.core.table.record.RecordStoreCompiledCondition;
import io.siddhi.core.table.record.RecordTableCompiledUpdateSet;
import io.siddhi.core.table.record.UpdateOrInsertReducer;
import io.siddhi.core.util.OnDemandQueryRuntimeUtil;
import io.siddhi.core.util.cache.CacheExpirer;
import io.siddhi.core.util.cache.CacheUtils;
import io.siddhi.core.util.collection.AddingStreamEventExtractor;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.CompiledSelection;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.parser.ExpressionParser;
import io.siddhi.core.util.parser.OnDemandQueryParser;
import io.siddhi.core.util.parser.SelectorParser;
import io.siddhi.core.util.parser.helper.QueryParserHelper;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.annotation.Annotation;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.TableDefinition;
import io.siddhi.query.api.execution.query.OnDemandQuery;
import io.siddhi.query.api.execution.query.input.store.InputStore;
import io.siddhi.query.api.execution.query.output.stream.OutputStream;
import io.siddhi.query.api.execution.query.output.stream.ReturnStream;
import io.siddhi.query.api.execution.query.output.stream.UpdateSet;
import io.siddhi.query.api.execution.query.selection.OrderByAttribute;
import io.siddhi.query.api.execution.query.selection.OutputAttribute;
import io.siddhi.query.api.execution.query.selection.Selector;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.Variable;
import io.siddhi.query.api.expression.constant.Constant;
import io.siddhi.query.api.util.AnnotationHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public abstract class AbstractQueryableRecordTable
extends AbstractRecordTable
implements QueryableProcessor {
    private static final Logger log = Logger.getLogger(AbstractQueryableRecordTable.class);
    public static ThreadLocal<Boolean> queryStoreWithoutCheckingCache = ThreadLocal.withInitial(() -> Boolean.FALSE);
    protected StateEvent findMatchingEvent;
    protected Selector selectorForTestOnDemandQuery;
    protected SiddhiQueryContext siddhiQueryContextForTestOnDemandQuery;
    protected MatchingMetaInfoHolder matchingMetaInfoHolderForTestOnDemandQuery;
    protected StateEvent containsMatchingEvent;
    private int maxCacheSize;
    private long purgeInterval;
    private boolean cacheEnabled = false;
    private boolean cacheExpiryEnabled = false;
    private InMemoryTable cacheTable;
    private CompiledCondition compiledConditionForCaching;
    private CompiledSelection compiledSelectionForCaching;
    private Attribute[] outputAttributesForCaching;
    private ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private long storeSizeLastCheckedTime;
    private long storeSizeCheckInterval;
    private long retentionPeriod;
    private long cacheLastReloadTime;
    private CompiledSelection compiledSelectionForSelectAll;
    private int storeTableSize = -1;

    @Override
    public void initCache(TableDefinition tableDefinition, SiddhiAppContext siddhiAppContext, StreamEventCloner storeEventCloner, ConfigReader configReader) {
        String[] annotationNames = new String[]{"Store", "Cache"};
        Annotation cacheTableAnnotation = AnnotationHelper.getAnnotation((String[])annotationNames, (List)tableDefinition.getAnnotations());
        if (cacheTableAnnotation != null) {
            this.cacheEnabled = true;
            this.maxCacheSize = Integer.parseInt(cacheTableAnnotation.getElement("Size"));
            TableDefinition cacheTableDefinition = TableDefinition.id((String)tableDefinition.getId());
            for (Attribute attribute : tableDefinition.getAttributeList()) {
                cacheTableDefinition.attribute(attribute.getName(), attribute.getType());
            }
            for (Annotation annotation : tableDefinition.getAnnotations()) {
                if (annotation.getName().equalsIgnoreCase("Store")) continue;
                cacheTableDefinition.annotation(annotation);
            }
            String cachePolicy = cacheTableAnnotation.getElement("cache.policy");
            if (cachePolicy == null || cachePolicy.equalsIgnoreCase("FIFO")) {
                cachePolicy = "FIFO";
                this.cacheTable = new CacheTableFIFO();
            } else if (cachePolicy.equalsIgnoreCase("LRU")) {
                this.cacheTable = new CacheTableLRU();
            } else if (cachePolicy.equalsIgnoreCase("LFU")) {
                this.cacheTable = new CacheTableLFU();
            } else {
                throw new SiddhiAppCreationException(siddhiAppContext.getName() + " : Cache policy can only be one of FIFO, LRU, and LFU but given as " + cachePolicy);
            }
            if (cacheTableAnnotation.getElement("retention.period") != null) {
                this.cacheExpiryEnabled = true;
                this.retentionPeriod = Expression.Time.timeToLong((String)cacheTableAnnotation.getElement("retention.period"));
                this.purgeInterval = cacheTableAnnotation.getElement("purge.interval") == null ? this.retentionPeriod : Expression.Time.timeToLong((String)cacheTableAnnotation.getElement("purge.interval"));
                this.storeSizeCheckInterval = this.purgeInterval * 5L;
            } else {
                this.storeSizeCheckInterval = 10000L;
            }
            ((CacheTable)this.cacheTable).initCacheTable(cacheTableDefinition, configReader, siddhiAppContext, this.recordTableHandler, this.cacheExpiryEnabled, this.maxCacheSize, cachePolicy);
            SiddhiQueryContext siddhiQueryContext = new SiddhiQueryContext(siddhiAppContext, "table_cache_" + tableDefinition.getId());
            MatchingMetaInfoHolder matchingMetaInfoHolder = OnDemandQueryParser.generateMatchingMetaInfoHolderForCacheTable(tableDefinition);
            OnDemandQuery onDemandQuery = OnDemandQuery.query().from((InputStore)InputStore.store((String)tableDefinition.getId())).select(Selector.selector().limit((Constant)Expression.value((int)(this.maxCacheSize + 1))));
            ArrayList<VariableExpressionExecutor> variableExpressionExecutors = new ArrayList<VariableExpressionExecutor>();
            this.compiledConditionForCaching = this.compileCondition((Expression)Expression.value((boolean)true), matchingMetaInfoHolder, variableExpressionExecutors, this.tableMap, siddhiQueryContext);
            List<Attribute> expectedOutputAttributes = OnDemandQueryParser.buildExpectedOutputAttributes(onDemandQuery, this.tableMap, -1, matchingMetaInfoHolder, siddhiQueryContext);
            this.compiledSelectionForCaching = this.compileSelection(onDemandQuery.getSelector(), expectedOutputAttributes, matchingMetaInfoHolder, variableExpressionExecutors, this.tableMap, siddhiQueryContext);
            this.outputAttributesForCaching = expectedOutputAttributes.toArray(new Attribute[0]);
            QueryParserHelper.reduceMetaComplexEvent(matchingMetaInfoHolder.getMetaStateEvent());
            QueryParserHelper.updateVariablePosition(matchingMetaInfoHolder.getMetaStateEvent(), variableExpressionExecutors);
            this.compiledSelectionForSelectAll = this.generateCSForSelectAll();
        }
    }

    @Override
    protected void connectAndLoadCache() throws ConnectionUnavailableException {
        this.connect();
        if (this.cacheEnabled) {
            StreamEvent preLoadedData;
            ((CacheTable)this.cacheTable).deleteAll();
            StateEvent stateEventForCaching = new StateEvent(1, 0);
            queryStoreWithoutCheckingCache.set(Boolean.TRUE);
            try {
                preLoadedData = this.query(stateEventForCaching, this.compiledConditionForCaching, this.compiledSelectionForCaching, this.outputAttributesForCaching);
            }
            finally {
                queryStoreWithoutCheckingCache.set(Boolean.FALSE);
            }
            if (preLoadedData != null) {
                ((CacheTable)this.cacheTable).addStreamEventUptoMaxSize(preLoadedData);
            }
            if (this.cacheExpiryEnabled) {
                this.siddhiAppContext.getScheduledExecutorService().scheduleAtFixedRate(new CacheExpirer(this.retentionPeriod, this.cacheTable, this.tableMap, this, this.siddhiAppContext).generateCacheExpirer(), 0L, this.purgeInterval, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public StreamEvent query(StateEvent matchingEvent, CompiledCondition compiledCondition, CompiledSelection compiledSelection) throws ConnectionUnavailableException {
        return this.query(matchingEvent, compiledCondition, compiledSelection, null);
    }

    @Override
    public void add(ComplexEventChunk<StreamEvent> addingEventChunk) {
        if (this.cacheEnabled) {
            this.readWriteLock.writeLock().lock();
            try {
                ((CacheTable)this.cacheTable).addAndTrimUptoMaxSize(addingEventChunk);
                super.add(addingEventChunk);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        } else {
            super.add(addingEventChunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(ComplexEventChunk<StateEvent> deletingEventChunk, CompiledCondition compiledCondition) {
        if (this.cacheEnabled) {
            RecordStoreCompiledCondition compiledConditionTemp = (RecordStoreCompiledCondition)compiledCondition;
            CompiledConditionWithCache compiledConditionWithCache = (CompiledConditionWithCache)compiledConditionTemp.getCompiledCondition();
            RecordStoreCompiledCondition recordStoreCompiledCondition = new RecordStoreCompiledCondition(compiledConditionTemp.variableExpressionExecutorMap, compiledConditionWithCache.getStoreCompileCondition(), compiledConditionTemp.getSiddhiQueryContext());
            this.readWriteLock.writeLock().lock();
            try {
                this.cacheTable.delete(deletingEventChunk, compiledConditionWithCache.getCacheCompileCondition());
                super.delete(deletingEventChunk, (CompiledCondition)recordStoreCompiledCondition);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        } else {
            RecordStoreCompiledCondition recordStoreCompiledCondition = (RecordStoreCompiledCondition)compiledCondition;
            super.delete(deletingEventChunk, (CompiledCondition)recordStoreCompiledCondition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ComplexEventChunk<StateEvent> updatingEventChunk, CompiledCondition compiledCondition, CompiledUpdateSet compiledUpdateSet) {
        if (this.cacheEnabled) {
            RecordStoreCompiledCondition compiledConditionTemp = (RecordStoreCompiledCondition)compiledCondition;
            CompiledConditionWithCache compiledConditionWithCache = (CompiledConditionWithCache)compiledConditionTemp.getCompiledCondition();
            RecordStoreCompiledCondition recordStoreCompiledCondition = new RecordStoreCompiledCondition(compiledConditionTemp.variableExpressionExecutorMap, compiledConditionWithCache.getStoreCompileCondition(), compiledConditionTemp.getSiddhiQueryContext());
            CompiledUpdateSetWithCache compiledUpdateSetWithCache = (CompiledUpdateSetWithCache)compiledUpdateSet;
            RecordTableCompiledUpdateSet recordTableCompiledUpdateSet = (RecordTableCompiledUpdateSet)compiledUpdateSetWithCache.storeCompiledUpdateSet;
            this.readWriteLock.writeLock().lock();
            try {
                this.cacheTable.update(updatingEventChunk, compiledConditionWithCache.getCacheCompileCondition(), compiledUpdateSetWithCache.getCacheCompiledUpdateSet());
                super.update(updatingEventChunk, recordStoreCompiledCondition, recordTableCompiledUpdateSet);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        } else {
            RecordStoreCompiledCondition recordStoreCompiledCondition = (RecordStoreCompiledCondition)compiledCondition;
            RecordTableCompiledUpdateSet recordTableCompiledUpdateSet = (RecordTableCompiledUpdateSet)compiledUpdateSet;
            super.update(updatingEventChunk, recordStoreCompiledCondition, recordTableCompiledUpdateSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(StateEvent matchingEvent, CompiledCondition compiledCondition) throws ConnectionUnavailableException {
        this.containsMatchingEvent = matchingEvent;
        if (this.cacheEnabled) {
            RecordStoreCompiledCondition compiledConditionTemp = (RecordStoreCompiledCondition)compiledCondition;
            CompiledConditionWithCache compiledConditionWithCache = (CompiledConditionWithCache)compiledConditionTemp.getCompiledCondition();
            RecordStoreCompiledCondition recordStoreCompiledCondition = new RecordStoreCompiledCondition(compiledConditionTemp.variableExpressionExecutorMap, compiledConditionWithCache.getStoreCompileCondition(), compiledConditionTemp.getSiddhiQueryContext());
            this.readWriteLock.readLock().lock();
            try {
                if (this.cacheTable.contains(matchingEvent, compiledConditionWithCache.getCacheCompileCondition())) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = super.contains(matchingEvent, (CompiledCondition)recordStoreCompiledCondition);
                return bl;
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }
        return super.contains(matchingEvent, compiledCondition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateOrAdd(ComplexEventChunk<StateEvent> updateOrAddingEventChunk, CompiledCondition compiledCondition, CompiledUpdateSet compiledUpdateSet, AddingStreamEventExtractor addingStreamEventExtractor) {
        if (this.cacheEnabled) {
            RecordStoreCompiledCondition compiledConditionTemp = (RecordStoreCompiledCondition)compiledCondition;
            CompiledConditionWithCache compiledConditionWithCache = (CompiledConditionWithCache)compiledConditionTemp.getCompiledCondition();
            RecordStoreCompiledCondition recordStoreCompiledCondition = new RecordStoreCompiledCondition(compiledConditionTemp.variableExpressionExecutorMap, compiledConditionWithCache.getStoreCompileCondition(), compiledConditionTemp.getSiddhiQueryContext());
            CompiledUpdateSetWithCache compiledUpdateSetWithCache = (CompiledUpdateSetWithCache)compiledUpdateSet;
            RecordTableCompiledUpdateSet recordTableCompiledUpdateSet = (RecordTableCompiledUpdateSet)compiledUpdateSetWithCache.storeCompiledUpdateSet;
            this.readWriteLock.writeLock().lock();
            try {
                ((CacheTable)this.cacheTable).updateOrAddAndTrimUptoMaxSize(updateOrAddingEventChunk, compiledConditionWithCache.getCacheCompileCondition(), compiledUpdateSetWithCache.getCacheCompiledUpdateSet(), addingStreamEventExtractor, this.maxCacheSize);
                super.updateOrAdd(updateOrAddingEventChunk, recordStoreCompiledCondition, recordTableCompiledUpdateSet, addingStreamEventExtractor);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        } else {
            super.updateOrAdd(updateOrAddingEventChunk, compiledCondition, compiledUpdateSet, addingStreamEventExtractor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamEvent find(CompiledCondition compiledCondition, StateEvent matchingEvent) throws ConnectionUnavailableException {
        RecordStoreCompiledCondition recordStoreCompiledCondition;
        try {
            this.updateStoreTableSize();
        }
        catch (ConnectionUnavailableException e) {
            log.error((Object)e);
        }
        CompiledConditionWithCache compiledConditionWithCache = null;
        this.findMatchingEvent = matchingEvent;
        if (this.cacheEnabled) {
            RecordStoreCompiledCondition compiledConditionTemp = (RecordStoreCompiledCondition)compiledCondition;
            compiledConditionWithCache = (CompiledConditionWithCache)compiledConditionTemp.getCompiledCondition();
            recordStoreCompiledCondition = new RecordStoreCompiledCondition(compiledConditionTemp.variableExpressionExecutorMap, compiledConditionWithCache.getStoreCompileCondition(), compiledConditionTemp.getSiddhiQueryContext());
        } else {
            recordStoreCompiledCondition = (RecordStoreCompiledCondition)compiledCondition;
        }
        if (this.cacheEnabled) {
            this.readWriteLock.writeLock().lock();
            try {
                StreamEvent cacheResults;
                if (this.storeTableSize <= this.maxCacheSize) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this.siddhiAppContext.getName() + "-" + recordStoreCompiledCondition.getSiddhiQueryContext().getName() + ": store table size is smaller than max cache. Sending results from cache"));
                    }
                    StreamEvent streamEvent = cacheResults = this.cacheTable.find(compiledConditionWithCache.getCacheCompileCondition(), matchingEvent);
                    return streamEvent;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.siddhiAppContext.getName() + "-" + recordStoreCompiledCondition.getSiddhiQueryContext().getName() + ": store table size is bigger than cache."));
                }
                if (compiledConditionWithCache.isRouteToCache()) {
                    StreamEvent streamEvent;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this.siddhiAppContext.getName() + "-" + recordStoreCompiledCondition.getSiddhiQueryContext().getName() + ": cache constraints satisfied. Checking cache"));
                    }
                    if ((cacheResults = this.cacheTable.find(compiledConditionWithCache.getCacheCompileCondition(), matchingEvent)) != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(this.siddhiAppContext.getName() + "-" + recordStoreCompiledCondition.getSiddhiQueryContext().getName() + ": cache hit. Sending results from cache"));
                        }
                        StreamEvent streamEvent2 = cacheResults;
                        return streamEvent2;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this.siddhiAppContext.getName() + "-" + recordStoreCompiledCondition.getSiddhiQueryContext().getName() + ": cache miss. Loading from store"));
                    }
                    if ((streamEvent = super.find(recordStoreCompiledCondition, matchingEvent)) == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(this.siddhiAppContext.getName() + "-" + recordStoreCompiledCondition.getSiddhiQueryContext().getName() + ": store also miss. sending null"));
                        }
                        StreamEvent streamEvent3 = null;
                        return streamEvent3;
                    }
                    if (this.cacheTable.size() == this.maxCacheSize) {
                        ((CacheTable)this.cacheTable).deleteOneEntryUsingCachePolicy();
                    }
                    ((CacheTable)this.cacheTable).addStreamEventUptoMaxSize(streamEvent);
                    cacheResults = this.cacheTable.find(compiledConditionWithCache.getCacheCompileCondition(), matchingEvent);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this.siddhiAppContext.getName() + "-" + recordStoreCompiledCondition.getSiddhiQueryContext().getName() + ": sending results from cache after loading from store"));
                    }
                    StreamEvent streamEvent4 = cacheResults;
                    return streamEvent4;
                }
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.siddhiAppContext.getName() + "-" + recordStoreCompiledCondition.getSiddhiQueryContext().getName() + ": sending results from store"));
        }
        return super.find(recordStoreCompiledCondition, matchingEvent);
    }

    @Override
    public CompiledUpdateSet compileUpdateSet(UpdateSet updateSet, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, SiddhiQueryContext siddhiQueryContext) {
        CompiledUpdateSet recordTableCompiledUpdateSet = super.compileUpdateSet(updateSet, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
        if (this.cacheEnabled) {
            CompiledUpdateSet cacheCompileUpdateSet = this.cacheTable.compileUpdateSet(updateSet, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
            return new CompiledUpdateSetWithCache(recordTableCompiledUpdateSet, cacheCompileUpdateSet);
        }
        return recordTableCompiledUpdateSet;
    }

    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, SiddhiQueryContext siddhiQueryContext) {
        ExpressionExecutor inMemoryCompiledCondition = ExpressionParser.parseExpression(condition, matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(condition, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, new UpdateOrInsertReducer(inMemoryCompiledCondition, matchingMetaInfoHolder), null, siddhiQueryContext);
        CompiledCondition compileCondition = this.compileCondition(expressionBuilder);
        Map<String, ExpressionExecutor> expressionExecutorMap = expressionBuilder.getVariableExpressionExecutorMap();
        if (this.cacheEnabled) {
            CompiledConditionWithCache compiledConditionWithCache = new CompiledConditionWithCache(compileCondition, ((CacheTable)this.cacheTable).generateCacheCompileCondition(condition, matchingMetaInfoHolder, siddhiQueryContext, variableExpressionExecutors), siddhiQueryContext);
            return new RecordStoreCompiledCondition(expressionExecutorMap, compiledConditionWithCache, siddhiQueryContext);
        }
        return new RecordStoreCompiledCondition(expressionExecutorMap, compileCondition, siddhiQueryContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStoreTableSize() throws ConnectionUnavailableException {
        block7: {
            if (this.cacheEnabled && !queryStoreWithoutCheckingCache.get().booleanValue()) {
                this.readWriteLock.writeLock().lock();
                try {
                    if (this.storeTableSize != -1 && (this.cacheExpiryEnabled || this.storeSizeLastCheckedTime >= this.siddhiAppContext.getTimestampGenerator().currentTime() - this.storeSizeCheckInterval)) break block7;
                    StateEvent stateEventForCaching = new StateEvent(1, 0);
                    queryStoreWithoutCheckingCache.set(Boolean.TRUE);
                    try {
                        StreamEvent preLoadedData = this.query(stateEventForCaching, this.compiledConditionForCaching, this.compiledSelectionForCaching, this.outputAttributesForCaching);
                        this.storeTableSize = CacheUtils.findEventChunkSize(preLoadedData);
                        this.storeSizeLastCheckedTime = this.siddhiAppContext.getTimestampGenerator().currentTime();
                    }
                    finally {
                        queryStoreWithoutCheckingCache.set(Boolean.FALSE);
                    }
                }
                finally {
                    this.readWriteLock.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public StreamEvent query(StateEvent matchingEvent, CompiledCondition compiledCondition, CompiledSelection compiledSelection, Attribute[] outputAttributes) throws ConnectionUnavailableException {
        RecordStoreCompiledSelection recordStoreCompiledSelection;
        RecordStoreCompiledCondition recordStoreCompiledCondition;
        this.findMatchingEvent = matchingEvent;
        this.updateStoreTableSize();
        ComplexEventChunk<StreamEvent> streamEventComplexEventChunk = new ComplexEventChunk<StreamEvent>();
        CompiledConditionWithCache compiledConditionWithCache = null;
        CompiledSelectionWithCache compiledSelectionWithCache = null;
        if (this.cacheEnabled) {
            RecordStoreCompiledCondition compiledConditionTemp = (RecordStoreCompiledCondition)compiledCondition;
            compiledConditionWithCache = (CompiledConditionWithCache)compiledConditionTemp.getCompiledCondition();
            recordStoreCompiledCondition = new RecordStoreCompiledCondition(compiledConditionTemp.variableExpressionExecutorMap, compiledConditionWithCache.getStoreCompileCondition(), compiledConditionTemp.getSiddhiQueryContext());
            compiledSelectionWithCache = (CompiledSelectionWithCache)compiledSelection;
            recordStoreCompiledSelection = compiledSelectionWithCache.recordStoreCompiledSelection;
        } else {
            recordStoreCompiledSelection = (RecordStoreCompiledSelection)compiledSelection;
            recordStoreCompiledCondition = (RecordStoreCompiledCondition)compiledCondition;
        }
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        for (Map.Entry<String, ExpressionExecutor> entry : recordStoreCompiledCondition.variableExpressionExecutorMap.entrySet()) {
            parameterMap.put(entry.getKey(), entry.getValue().execute(matchingEvent));
        }
        for (Map.Entry<String, ExpressionExecutor> entry : recordStoreCompiledSelection.variableExpressionExecutorMap.entrySet()) {
            parameterMap.put(entry.getKey(), entry.getValue().execute(matchingEvent));
        }
        if (this.cacheEnabled) {
            this.readWriteLock.writeLock().lock();
            try {
                if (this.storeTableSize <= this.maxCacheSize && !queryStoreWithoutCheckingCache.get().booleanValue()) {
                    StreamEvent cacheResults = this.cacheTable.find(compiledConditionWithCache.getCacheCompileCondition(), matchingEvent);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this.siddhiAppContext.getName() + "-" + recordStoreCompiledCondition.getSiddhiQueryContext().getName() + ": store table size is smaller than max cache. Sending results from cache"));
                    }
                    if (cacheResults == null) {
                        StreamEvent streamEvent = null;
                        return streamEvent;
                    }
                    StreamEvent streamEvent = this.executeSelectorOnCacheResults(compiledSelectionWithCache, cacheResults, matchingEvent.getStreamEvent(0));
                    return streamEvent;
                }
                if (log.isDebugEnabled() && !queryStoreWithoutCheckingCache.get().booleanValue()) {
                    log.debug((Object)(this.siddhiAppContext.getName() + "-" + recordStoreCompiledCondition.getSiddhiQueryContext().getName() + ": store table size is bigger than cache."));
                }
                if (compiledConditionWithCache.isRouteToCache() && !queryStoreWithoutCheckingCache.get().booleanValue()) {
                    void var13_20;
                    StreamEvent cacheResults;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this.siddhiAppContext.getName() + "-" + recordStoreCompiledCondition.getSiddhiQueryContext().getName() + ": cache constraints satisfied. Checking cache"));
                    }
                    if ((cacheResults = this.cacheTable.find(compiledConditionWithCache.getCacheCompileCondition(), matchingEvent)) != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(this.siddhiAppContext.getName() + "-" + recordStoreCompiledCondition.getSiddhiQueryContext().getName() + ": cache hit. Sending results from cache"));
                        }
                        StreamEvent streamEvent = this.executeSelectorOnCacheResults(compiledSelectionWithCache, cacheResults, matchingEvent.getStreamEvent(0));
                        return streamEvent;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this.siddhiAppContext.getName() + "-" + recordStoreCompiledCondition.getSiddhiQueryContext().getName() + ": cache miss. Loading from store"));
                    }
                    if (this.recordTableHandler != null) {
                        Iterator<Object[]> iterator = this.recordTableHandler.query(matchingEvent.getTimestamp(), parameterMap, recordStoreCompiledCondition.getCompiledCondition(), this.compiledSelectionForSelectAll, outputAttributes);
                    } else {
                        RecordIterator<Object[]> recordIterator = this.query(parameterMap, recordStoreCompiledCondition.getCompiledCondition(), this.compiledSelectionForSelectAll, outputAttributes);
                    }
                    if (var13_20 == null || !var13_20.hasNext()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(this.siddhiAppContext.getName() + "-" + recordStoreCompiledCondition.getSiddhiQueryContext().getName() + ": store also miss. sending null"));
                        }
                        StreamEvent streamEvent = null;
                        return streamEvent;
                    }
                    Object[] recordSelectAll = (Object[])var13_20.next();
                    StreamEvent streamEvent = this.storeEventPool.newInstance();
                    streamEvent.setOutputData(new Object[outputAttributes.length]);
                    System.arraycopy(recordSelectAll, 0, streamEvent.getOutputData(), 0, recordSelectAll.length);
                    if (this.cacheTable.size() == this.maxCacheSize) {
                        ((CacheTable)this.cacheTable).deleteOneEntryUsingCachePolicy();
                    }
                    ((CacheTable)this.cacheTable).addStreamEventUptoMaxSize(streamEvent);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this.siddhiAppContext.getName() + "-" + recordStoreCompiledCondition.getSiddhiQueryContext().getName() + ": sending results from cache after loading from store"));
                    }
                    cacheResults = this.cacheTable.find(compiledConditionWithCache.getCacheCompileCondition(), matchingEvent);
                    StreamEvent streamEvent2 = this.executeSelectorOnCacheResults(compiledSelectionWithCache, cacheResults, matchingEvent.getStreamEvent(0));
                    return streamEvent2;
                }
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
        if (log.isDebugEnabled() && !queryStoreWithoutCheckingCache.get().booleanValue()) {
            log.debug((Object)(this.siddhiAppContext.getName() + "-" + recordStoreCompiledCondition.getSiddhiQueryContext().getName() + ": sending results from store"));
        }
        Iterator<Object[]> records = this.recordTableHandler != null ? this.recordTableHandler.query(matchingEvent.getTimestamp(), parameterMap, recordStoreCompiledCondition.getCompiledCondition(), recordStoreCompiledSelection.compiledSelection, outputAttributes) : this.query(parameterMap, recordStoreCompiledCondition.getCompiledCondition(), recordStoreCompiledSelection.compiledSelection, outputAttributes);
        this.addStreamEventToChunk(outputAttributes, streamEventComplexEventChunk, records);
        return streamEventComplexEventChunk.getFirst();
    }

    private CompiledSelection generateCSForSelectAll() {
        MetaStreamEvent metaStreamEventForSelectAll = new MetaStreamEvent();
        for (Attribute attribute : this.tableDefinition.getAttributeList()) {
            metaStreamEventForSelectAll.addOutputData(attribute);
        }
        metaStreamEventForSelectAll.addInputDefinition((AbstractDefinition)this.tableDefinition);
        MetaStateEvent metaStateEventForSelectAll = new MetaStateEvent(1);
        metaStateEventForSelectAll.addEvent(metaStreamEventForSelectAll);
        MatchingMetaInfoHolder matchingMetaInfoHolderForSlectAll = new MatchingMetaInfoHolder(metaStateEventForSelectAll, -1, 0, (AbstractDefinition)this.tableDefinition, (AbstractDefinition)this.tableDefinition, 0);
        ArrayList<OutputAttribute> outputAttributesAll = new ArrayList<OutputAttribute>();
        List attributeList = this.tableDefinition.getAttributeList();
        for (Attribute attribute : attributeList) {
            outputAttributesAll.add(new OutputAttribute(new Variable(attribute.getName())));
        }
        ArrayList<SelectAttributeBuilder> selectAttributeBuilders = new ArrayList<SelectAttributeBuilder>(outputAttributesAll.size());
        ArrayList<VariableExpressionExecutor> variableExpressionExecutors = new ArrayList<VariableExpressionExecutor>();
        for (OutputAttribute outputAttribute : outputAttributesAll) {
            ExpressionBuilder expressionBuilder = new ExpressionBuilder(outputAttribute.getExpression(), matchingMetaInfoHolderForSlectAll, variableExpressionExecutors, this.tableMap, null, null, null);
            selectAttributeBuilders.add(new SelectAttributeBuilder(expressionBuilder, outputAttribute.getRename()));
        }
        return this.compileSelection(selectAttributeBuilders, null, null, null, null, null);
    }

    private void addStreamEventToChunk(Attribute[] outputAttributes, ComplexEventChunk<StreamEvent> streamEventComplexEventChunk, Iterator<Object[]> records) {
        if (records != null) {
            while (records.hasNext()) {
                Object[] record = records.next();
                StreamEvent streamEvent = this.storeEventPool.newInstance();
                streamEvent.setOutputData(new Object[outputAttributes.length]);
                System.arraycopy(record, 0, streamEvent.getOutputData(), 0, record.length);
                streamEventComplexEventChunk.add(streamEvent);
            }
        }
    }

    private StreamEvent executeSelectorOnCacheResults(CompiledSelectionWithCache compiledSelectionWithCache, StreamEvent cacheResults, StreamEvent streamEvent) {
        StateEventFactory stateEventFactory = new StateEventFactory(compiledSelectionWithCache.metaStateEvent);
        return OnDemandQueryRuntimeUtil.executeSelectorAndReturnStreamEvent(stateEventFactory, streamEvent, cacheResults, compiledSelectionWithCache.getStoreEventIndex(), compiledSelectionWithCache.querySelector);
    }

    protected abstract RecordIterator<Object[]> query(Map<String, Object> var1, CompiledCondition var2, CompiledSelection var3, Attribute[] var4) throws ConnectionUnavailableException;

    @Override
    public CompiledSelection compileSelection(Selector selector, List<Attribute> expectedOutputAttributes, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, SiddhiQueryContext siddhiQueryContext) {
        ExpressionExecutor expressionExecutor;
        this.selectorForTestOnDemandQuery = selector;
        this.siddhiQueryContextForTestOnDemandQuery = siddhiQueryContext;
        this.matchingMetaInfoHolderForTestOnDemandQuery = matchingMetaInfoHolder;
        List outputAttributes = selector.getSelectionList();
        if (outputAttributes.size() == 0) {
            MetaStreamEvent metaStreamEvent = matchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvent(matchingMetaInfoHolder.getStoreEventIndex());
            List attributeList = metaStreamEvent.getLastInputDefinition().getAttributeList();
            Iterator iterator = attributeList.iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                outputAttributes.add(new OutputAttribute(new Variable(attribute.getName())));
            }
        }
        ArrayList<SelectAttributeBuilder> selectAttributeBuilders = new ArrayList<SelectAttributeBuilder>(outputAttributes.size());
        for (OutputAttribute outputAttribute : outputAttributes) {
            ExpressionBuilder expressionBuilder = new ExpressionBuilder(outputAttribute.getExpression(), matchingMetaInfoHolder, variableExpressionExecutors, tableMap, null, null, siddhiQueryContext);
            selectAttributeBuilders.add(new SelectAttributeBuilder(expressionBuilder, outputAttribute.getRename()));
        }
        MatchingMetaInfoHolder metaInfoHolderAfterSelect = new MatchingMetaInfoHolder(matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getMatchingStreamEventIndex(), matchingMetaInfoHolder.getStoreEventIndex(), matchingMetaInfoHolder.getMatchingStreamDefinition(), matchingMetaInfoHolder.getMatchingStreamDefinition(), matchingMetaInfoHolder.getCurrentState());
        ArrayList<ExpressionBuilder> groupByExpressionBuilders = null;
        if (selector.getGroupByList().size() != 0) {
            groupByExpressionBuilders = new ArrayList<ExpressionBuilder>(outputAttributes.size());
            for (Variable variable : selector.getGroupByList()) {
                groupByExpressionBuilders.add(new ExpressionBuilder((Expression)variable, metaInfoHolderAfterSelect, variableExpressionExecutors, tableMap, null, null, siddhiQueryContext));
            }
        }
        ExpressionBuilder havingExpressionBuilder = null;
        if (selector.getHavingExpression() != null) {
            havingExpressionBuilder = new ExpressionBuilder(selector.getHavingExpression(), metaInfoHolderAfterSelect, variableExpressionExecutors, tableMap, null, null, siddhiQueryContext);
        }
        ArrayList<OrderByAttributeBuilder> orderByAttributeBuilders = null;
        if (selector.getOrderByList().size() != 0) {
            orderByAttributeBuilders = new ArrayList<OrderByAttributeBuilder>(selector.getOrderByList().size());
            for (OrderByAttribute orderByAttribute : selector.getOrderByList()) {
                ExpressionBuilder expressionBuilder = new ExpressionBuilder((Expression)orderByAttribute.getVariable(), metaInfoHolderAfterSelect, variableExpressionExecutors, tableMap, null, null, siddhiQueryContext);
                orderByAttributeBuilders.add(new OrderByAttributeBuilder(expressionBuilder, orderByAttribute.getOrder()));
            }
        }
        Long limit = null;
        Long offset = null;
        if (selector.getLimit() != null && (limit = Long.valueOf(((Number)((ConstantExpressionExecutor)(expressionExecutor = ExpressionParser.parseExpression((Expression)selector.getLimit(), metaInfoHolderAfterSelect.getMetaStateEvent(), -2, tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext))).getValue()).longValue())) < 0L) {
            throw new SiddhiAppCreationException("'limit' cannot have negative value, but found '" + limit + "'", (SiddhiElement)selector, siddhiQueryContext.getSiddhiAppContext());
        }
        if (selector.getOffset() != null && (offset = Long.valueOf(((Number)((ConstantExpressionExecutor)(expressionExecutor = ExpressionParser.parseExpression((Expression)selector.getOffset(), metaInfoHolderAfterSelect.getMetaStateEvent(), -2, tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext))).getValue()).longValue())) < 0L) {
            throw new SiddhiAppCreationException("'offset' cannot have negative value, but found '" + offset + "'", (SiddhiElement)selector, siddhiQueryContext.getSiddhiAppContext());
        }
        CompiledSelection compiledSelection = this.compileSelection(selectAttributeBuilders, groupByExpressionBuilders, havingExpressionBuilder, orderByAttributeBuilders, limit, offset);
        HashMap<String, ExpressionExecutor> expressionExecutorMap = new HashMap<String, ExpressionExecutor>();
        if (selectAttributeBuilders.size() != 0) {
            for (SelectAttributeBuilder selectAttributeBuilder : selectAttributeBuilders) {
                expressionExecutorMap.putAll(selectAttributeBuilder.getExpressionBuilder().getVariableExpressionExecutorMap());
            }
        }
        if (groupByExpressionBuilders != null && groupByExpressionBuilders.size() != 0) {
            for (ExpressionBuilder groupByExpressionBuilder : groupByExpressionBuilders) {
                expressionExecutorMap.putAll(groupByExpressionBuilder.getVariableExpressionExecutorMap());
            }
        }
        if (havingExpressionBuilder != null) {
            expressionExecutorMap.putAll(havingExpressionBuilder.getVariableExpressionExecutorMap());
        }
        if (orderByAttributeBuilders != null && orderByAttributeBuilders.size() != 0) {
            for (OrderByAttributeBuilder orderByAttributeBuilder : orderByAttributeBuilders) {
                expressionExecutorMap.putAll(orderByAttributeBuilder.getExpressionBuilder().getVariableExpressionExecutorMap());
            }
        }
        if (this.cacheEnabled) {
            MetaStateEvent metaStateEventForCacheSelection = matchingMetaInfoHolder.getMetaStateEvent().clone();
            ReturnStream returnStream = new ReturnStream(OutputStream.OutputEventType.CURRENT_EVENTS);
            int metaPosition = -1;
            ArrayList<VariableExpressionExecutor> variableExpressionExecutorsForQuerySelector = new ArrayList<VariableExpressionExecutor>();
            QuerySelector querySelector = SelectorParser.parse(selector, (OutputStream)returnStream, metaStateEventForCacheSelection, tableMap, variableExpressionExecutorsForQuerySelector, metaPosition, ProcessingMode.BATCH, false, siddhiQueryContext);
            if (matchingMetaInfoHolder.getMetaStateEvent().getOutputDataAttributes().size() == 0) {
                for (MetaStateEventAttribute outputDataAttribute : metaStateEventForCacheSelection.getOutputDataAttributes()) {
                    matchingMetaInfoHolder.getMetaStateEvent().addOutputDataAllowingDuplicate(outputDataAttribute);
                }
            }
            QueryParserHelper.updateVariablePosition(metaStateEventForCacheSelection, variableExpressionExecutorsForQuerySelector);
            querySelector.setEventPopulator(StateEventPopulatorFactory.constructEventPopulator(metaStateEventForCacheSelection));
            RecordStoreCompiledSelection recordStoreCompiledSelection = new RecordStoreCompiledSelection(expressionExecutorMap, compiledSelection);
            CompiledSelectionWithCache compiledSelectionWithCache = new CompiledSelectionWithCache(recordStoreCompiledSelection, querySelector, metaStateEventForCacheSelection, matchingMetaInfoHolder.getStoreEventIndex(), variableExpressionExecutorsForQuerySelector);
            return compiledSelectionWithCache;
        }
        return new RecordStoreCompiledSelection(expressionExecutorMap, compiledSelection);
    }

    protected abstract CompiledSelection compileSelection(List<SelectAttributeBuilder> var1, List<ExpressionBuilder> var2, ExpressionBuilder var3, List<OrderByAttributeBuilder> var4, Long var5, Long var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void handleCacheExpiry(CompiledCondition cacheExpiryCompiledCondition, ComplexEventChunk<StateEvent> deleteEventChunk) {
        if (AbstractQueryableRecordTable.log.isDebugEnabled()) {
            AbstractQueryableRecordTable.log.debug((Object)(this.siddhiAppContext.getName() + ": CacheExpirer started"));
        }
        stateEventForCaching = new StateEvent(1, 0);
        this.readWriteLock.writeLock().lock();
        try {
            if (this.storeTableSize != -1 && this.storeSizeLastCheckedTime > this.siddhiAppContext.getTimestampGenerator().currentTime() - this.retentionPeriod * 10L) {
                if (AbstractQueryableRecordTable.log.isDebugEnabled()) {
                    AbstractQueryableRecordTable.log.debug((Object)(this.siddhiAppContext.getName() + ": checking size of store table"));
                }
                try {
                    if (this.storeTableSize <= this.maxCacheSize) {
                        AbstractQueryableRecordTable.queryStoreWithoutCheckingCache.set(Boolean.TRUE);
                        try {
                            if (this.cacheLastReloadTime >= this.siddhiAppContext.getTimestampGenerator().currentTime() + this.retentionPeriod) ** GOTO lbl45
                            loadedDataFromStore = this.query(stateEventForCaching, this.compiledConditionForCaching, this.compiledSelectionForCaching, this.outputAttributesForCaching);
                            this.clearCacheAndReload(loadedDataFromStore);
                            this.cacheLastReloadTime = this.siddhiAppContext.getTimestampGenerator().currentTime();
                        }
                        finally {
                            AbstractQueryableRecordTable.queryStoreWithoutCheckingCache.set(Boolean.FALSE);
                        }
                    }
                    this.cacheTable.delete(deleteEventChunk, cacheExpiryCompiledCondition);
                }
                catch (ConnectionUnavailableException e) {
                    throw new SiddhiAppRuntimeException(this.siddhiAppContext.getName() + ": " + e.getMessage());
                }
            } else {
                try {
                    AbstractQueryableRecordTable.queryStoreWithoutCheckingCache.set(Boolean.TRUE);
                    try {
                        loadedDataFromStore = this.query(stateEventForCaching, this.compiledConditionForCaching, this.compiledSelectionForCaching, this.outputAttributesForCaching);
                        this.storeTableSize = CacheUtils.findEventChunkSize(loadedDataFromStore);
                        this.storeSizeLastCheckedTime = this.siddhiAppContext.getTimestampGenerator().currentTime();
                    }
                    finally {
                        AbstractQueryableRecordTable.queryStoreWithoutCheckingCache.set(Boolean.FALSE);
                    }
                    if (this.storeTableSize <= this.maxCacheSize) {
                        if (this.cacheLastReloadTime < this.siddhiAppContext.getTimestampGenerator().currentTime() + this.retentionPeriod) {
                            this.clearCacheAndReload(loadedDataFromStore);
                            this.cacheLastReloadTime = this.siddhiAppContext.getTimestampGenerator().currentTime();
                        }
                    } else {
                        this.cacheTable.delete(deleteEventChunk, cacheExpiryCompiledCondition);
                    }
                }
                catch (Exception e) {
                    throw new SiddhiAppRuntimeException(this.siddhiAppContext.getName() + ": " + e.getMessage());
                }
            }
lbl45:
            // 5 sources

            if (AbstractQueryableRecordTable.log.isDebugEnabled()) {
                AbstractQueryableRecordTable.log.debug((Object)(this.siddhiAppContext.getName() + ": CacheExpirer ended"));
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private void clearCacheAndReload(StreamEvent loadedDataFromStore) {
        ((CacheTable)this.cacheTable).deleteAll();
        if (loadedDataFromStore != null) {
            ((CacheTable)this.cacheTable).addStreamEventUptoMaxSize(loadedDataFromStore);
        }
    }

    public class OrderByAttributeBuilder {
        private final ExpressionBuilder expressionBuilder;
        private final OrderByAttribute.Order order;

        public OrderByAttributeBuilder(ExpressionBuilder expressionBuilder, OrderByAttribute.Order order) {
            this.expressionBuilder = expressionBuilder;
            this.order = order;
        }

        public ExpressionBuilder getExpressionBuilder() {
            return this.expressionBuilder;
        }

        public OrderByAttribute.Order getOrder() {
            return this.order;
        }
    }

    public class SelectAttributeBuilder {
        private final ExpressionBuilder expressionBuilder;
        private final String rename;

        public SelectAttributeBuilder(ExpressionBuilder expressionBuilder, String rename) {
            this.expressionBuilder = expressionBuilder;
            this.rename = rename;
        }

        public ExpressionBuilder getExpressionBuilder() {
            return this.expressionBuilder;
        }

        public String getRename() {
            return this.rename;
        }
    }

    private class RecordStoreCompiledSelection
    implements CompiledSelection {
        private final Map<String, ExpressionExecutor> variableExpressionExecutorMap;
        private final CompiledSelection compiledSelection;

        RecordStoreCompiledSelection(Map<String, ExpressionExecutor> variableExpressionExecutorMap, CompiledSelection compiledSelection) {
            this.variableExpressionExecutorMap = variableExpressionExecutorMap;
            this.compiledSelection = compiledSelection;
        }
    }

    public class CompiledSelectionWithCache
    implements CompiledSelection {
        private QuerySelector querySelector;
        private MetaStateEvent metaStateEvent;
        private RecordStoreCompiledSelection recordStoreCompiledSelection;
        private int storeEventIndex;
        private List<VariableExpressionExecutor> variableExpressionExecutorsForQuerySelector;

        public CompiledSelectionWithCache(RecordStoreCompiledSelection recordStoreCompiledSelection, QuerySelector querySelector, MetaStateEvent metaStateEvent, int storeEventIndex, List<VariableExpressionExecutor> variableExpressionExecutors) {
            this.recordStoreCompiledSelection = recordStoreCompiledSelection;
            this.querySelector = querySelector;
            this.metaStateEvent = metaStateEvent;
            this.storeEventIndex = storeEventIndex;
            this.variableExpressionExecutorsForQuerySelector = variableExpressionExecutors;
        }

        public RecordStoreCompiledSelection getRecordStoreCompiledSelection() {
            return this.recordStoreCompiledSelection;
        }

        public QuerySelector getQuerySelector() {
            return this.querySelector;
        }

        public MetaStateEvent getMetaStateEvent() {
            return this.metaStateEvent;
        }

        public int getStoreEventIndex() {
            return this.storeEventIndex;
        }

        public List<VariableExpressionExecutor> getVariableExpressionExecutorsForQuerySelector() {
            return this.variableExpressionExecutorsForQuerySelector;
        }
    }

    private class CompiledConditionWithCache
    implements CompiledCondition {
        private CompiledCondition cacheCompileCondition;
        private CompiledCondition storeCompileCondition;
        private boolean routeToCache;
        private SiddhiQueryContext siddhiQueryContext;

        CompiledConditionWithCache(CompiledCondition storeCompileCondition, CacheTable.CacheCompiledConditionWithRouteToCache cacheCompiledConditionWithRouteToCache, SiddhiQueryContext siddhiQueryContext) {
            this.storeCompileCondition = storeCompileCondition;
            this.cacheCompileCondition = cacheCompiledConditionWithRouteToCache.getCacheCompiledCondition();
            this.routeToCache = cacheCompiledConditionWithRouteToCache.isRouteToCache();
            this.siddhiQueryContext = siddhiQueryContext;
        }

        CompiledCondition getStoreCompileCondition() {
            return this.storeCompileCondition;
        }

        boolean isRouteToCache() {
            return this.routeToCache;
        }

        CompiledCondition getCacheCompileCondition() {
            return this.cacheCompileCondition;
        }

        public SiddhiQueryContext getSiddhiQueryContext() {
            return this.siddhiQueryContext;
        }
    }

    private class CompiledUpdateSetWithCache
    implements CompiledUpdateSet {
        CompiledUpdateSet storeCompiledUpdateSet;
        CompiledUpdateSet cacheCompiledUpdateSet;

        public CompiledUpdateSetWithCache(CompiledUpdateSet storeCompiledUpdateSet, CompiledUpdateSet cacheCompiledUpdateSet) {
            this.storeCompiledUpdateSet = storeCompiledUpdateSet;
            this.cacheCompiledUpdateSet = cacheCompiledUpdateSet;
        }

        public CompiledUpdateSet getStoreCompiledUpdateSet() {
            return this.storeCompiledUpdateSet;
        }

        public CompiledUpdateSet getCacheCompiledUpdateSet() {
            return this.cacheCompiledUpdateSet;
        }
    }
}

