/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.table.record;

import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.state.StateEventFactory;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.query.api.definition.Attribute;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class UpdateOrInsertReducer
implements Serializable {
    private final StreamEventFactory streamEventFactory;
    private final StateEventFactory stateEventFactory;
    private final int storeEventIndex;
    private final int streamEventIndex;
    private final Map<String, Integer> attributeMap;
    private ExpressionExecutor inMemoryCompiledCondition;

    public UpdateOrInsertReducer(ExpressionExecutor inMemoryCompiledCondition, MatchingMetaInfoHolder matchingMetaInfoHolder) {
        this.inMemoryCompiledCondition = inMemoryCompiledCondition;
        this.streamEventFactory = new StreamEventFactory(matchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvent(matchingMetaInfoHolder.getStoreEventIndex()));
        this.stateEventFactory = new StateEventFactory(matchingMetaInfoHolder.getMetaStateEvent());
        this.storeEventIndex = matchingMetaInfoHolder.getStoreEventIndex();
        this.streamEventIndex = matchingMetaInfoHolder.getMatchingStreamEventIndex();
        this.attributeMap = new HashMap<String, Integer>();
        List attributeList = matchingMetaInfoHolder.getStoreDefinition().getAttributeList();
        for (int i = 0; i < attributeList.size(); ++i) {
            Attribute attribute = (Attribute)attributeList.get(i);
            this.attributeMap.put(attribute.getName(), i);
        }
    }

    public List<Object[]> reduceEventsForInsert(List<Object[]> failedRecords, Map<String, ExpressionExecutor> inMemorySetExecutors) {
        ComplexEventChunk<StreamEvent> toInsertEventChunk = new ComplexEventChunk<StreamEvent>();
        StateEvent joinEvent = this.stateEventFactory.newInstance();
        for (Object[] data : failedRecords) {
            StreamEvent failedEvent = this.streamEventFactory.newInstance();
            failedEvent.setOutputData(data);
            joinEvent.setEvent(this.streamEventIndex, failedEvent);
            boolean updated = false;
            toInsertEventChunk.reset();
            while (toInsertEventChunk.hasNext()) {
                StreamEvent toInsertEvent = (StreamEvent)toInsertEventChunk.next();
                joinEvent.setEvent(this.storeEventIndex, toInsertEvent);
                if (!((Boolean)this.inMemoryCompiledCondition.execute(joinEvent)).booleanValue()) continue;
                for (Map.Entry<String, ExpressionExecutor> entry : inMemorySetExecutors.entrySet()) {
                    toInsertEvent.setOutputData(entry.getValue().execute(failedEvent), this.attributeMap.get(entry.getKey()));
                }
                updated = true;
            }
            if (updated) continue;
            toInsertEventChunk.add(failedEvent);
        }
        LinkedList<Object[]> toInsertRecords = new LinkedList<Object[]>();
        toInsertEventChunk.reset();
        while (toInsertEventChunk.hasNext()) {
            StreamEvent streamEvent = (StreamEvent)toInsertEventChunk.next();
            toInsertRecords.add(streamEvent.getOutputData());
        }
        return toInsertRecords;
    }
}

