/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.parser;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.event.stream.converter.ZeroStreamEventConverter;
import io.siddhi.core.event.stream.holder.StreamEventClonerHolder;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.table.holder.EventHolder;
import io.siddhi.core.table.holder.IndexEventHolder;
import io.siddhi.core.table.holder.IndexEventHolderForCache;
import io.siddhi.core.table.holder.ListEventHolder;
import io.siddhi.core.table.holder.PrimaryKeyReferenceHolder;
import io.siddhi.query.api.annotation.Annotation;
import io.siddhi.query.api.annotation.Element;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import io.siddhi.query.api.util.AnnotationHelper;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class EventHolderPasser {
    private static final Logger log = Logger.getLogger(EventHolderPasser.class);

    public static EventHolder parse(AbstractDefinition tableDefinition, StreamEventFactory tableStreamEventFactory, SiddhiAppContext siddhiAppContext, boolean isCacheTable) {
        ZeroStreamEventConverter eventConverter = new ZeroStreamEventConverter();
        PrimaryKeyReferenceHolder[] primaryKeyReferenceHolders = null;
        HashMap<String, Integer> indexMetaData = new HashMap<String, Integer>();
        Annotation primaryKeyAnnotation = AnnotationHelper.getAnnotation((String)"PrimaryKey", (List)tableDefinition.getAnnotations());
        if (primaryKeyAnnotation != null) {
            if (primaryKeyAnnotation.getElements().size() == 0) {
                throw new SiddhiAppValidationException("PrimaryKey annotation contains " + primaryKeyAnnotation.getElements().size() + " element, at '" + tableDefinition.getId() + "'");
            }
            primaryKeyReferenceHolders = (PrimaryKeyReferenceHolder[])primaryKeyAnnotation.getElements().stream().map(element -> element.getValue().trim()).map(key -> new PrimaryKeyReferenceHolder((String)key, tableDefinition.getAttributePosition(key))).toArray(PrimaryKeyReferenceHolder[]::new);
        }
        for (Annotation indexAnnotation : AnnotationHelper.getAnnotations((String)"Index", (List)tableDefinition.getAnnotations())) {
            if (indexAnnotation.getElements().size() == 0) {
                throw new SiddhiAppValidationException("Index annotation of in-memory table should contain only one index element, but found " + indexAnnotation.getElements().size() + " element", indexAnnotation.getQueryContextStartIndex(), indexAnnotation.getQueryContextEndIndex());
            }
            if (indexAnnotation.getElements().size() > 1) {
                throw new SiddhiAppValidationException("Index annotation of the in-memory table should only contain one index element but found " + indexAnnotation.getElements().size() + " elements. To use multiple indexes, define multiple '@index(<index key>)' annotations with one index element per each index key", indexAnnotation.getQueryContextStartIndex(), indexAnnotation.getQueryContextEndIndex());
            }
            for (Element element2 : indexAnnotation.getElements()) {
                Integer previousValue = indexMetaData.put(element2.getValue().trim(), tableDefinition.getAttributePosition(element2.getValue().trim()));
                if (previousValue == null) continue;
                throw new SiddhiAppValidationException("Multiple Index annotations defined with same attribute '" + element2.getValue().trim() + "', at '" + tableDefinition.getId() + "'", indexAnnotation.getQueryContextStartIndex(), indexAnnotation.getQueryContextEndIndex());
            }
        }
        Annotation indexByAnnotation = AnnotationHelper.getAnnotation((String)"IndexBy", (List)tableDefinition.getAnnotations());
        if (indexByAnnotation != null) {
            throw new OperationNotSupportedException("IndexBy annotation is not supported anymore, please use @PrimaryKey or @Index annotations instead, at '" + tableDefinition.getId() + "'");
        }
        if (primaryKeyReferenceHolders != null || indexMetaData.size() > 0) {
            Attribute.Type type;
            boolean isNumeric = false;
            if (primaryKeyReferenceHolders != null && primaryKeyReferenceHolders.length == 1 && ((type = tableDefinition.getAttributeType(primaryKeyReferenceHolders[0].getPrimaryKeyAttribute())) == Attribute.Type.DOUBLE || type == Attribute.Type.FLOAT || type == Attribute.Type.INT || type == Attribute.Type.LONG)) {
                isNumeric = true;
            }
            if (isCacheTable) {
                return new IndexEventHolderForCache(tableStreamEventFactory, eventConverter, primaryKeyReferenceHolders, isNumeric, indexMetaData, tableDefinition, siddhiAppContext);
            }
            return new IndexEventHolder(tableStreamEventFactory, eventConverter, primaryKeyReferenceHolders, isNumeric, indexMetaData, tableDefinition, siddhiAppContext);
        }
        MetaStreamEvent metaStreamEvent = new MetaStreamEvent();
        for (Attribute attribute : tableDefinition.getAttributeList()) {
            metaStreamEvent.addOutputData(attribute);
        }
        StreamEventCloner streamEventCloner = new StreamEventCloner(metaStreamEvent, tableStreamEventFactory);
        return new ListEventHolder(tableStreamEventFactory, eventConverter, new StreamEventClonerHolder(streamEventCloner));
    }
}

