/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.parser;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.MetaComplexEvent;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.event.state.MetaStateEventAttribute;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.executor.condition.ConditionExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.selector.GroupByKeyGenerator;
import io.siddhi.core.query.selector.OrderByEventComparator;
import io.siddhi.core.query.selector.QuerySelector;
import io.siddhi.core.query.selector.attribute.processor.AttributeProcessor;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.parser.ExpressionParser;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.exception.DuplicateAttributeException;
import io.siddhi.query.api.execution.query.output.stream.OutputStream;
import io.siddhi.query.api.execution.query.selection.OutputAttribute;
import io.siddhi.query.api.execution.query.selection.Selector;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.Variable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SelectorParser {
    private static final ThreadLocal<String> containsAggregatorThreadLocal = new ThreadLocal();

    public static QuerySelector parse(Selector selector, OutputStream outputStream, MetaComplexEvent metaComplexEvent, Map<String, Table> tableMap, List<VariableExpressionExecutor> variableExpressionExecutors, int metaPosition, ProcessingMode processingMode, boolean outputExpectsExpiredEvents, SiddhiQueryContext siddhiQueryContext) {
        ExpressionExecutor expressionExecutor;
        boolean currentOn = false;
        boolean expiredOn = false;
        String id = null;
        if (outputStream.getOutputEventType() == OutputStream.OutputEventType.CURRENT_EVENTS || outputStream.getOutputEventType() == OutputStream.OutputEventType.ALL_EVENTS) {
            currentOn = true;
        }
        if (outputStream.getOutputEventType() == OutputStream.OutputEventType.EXPIRED_EVENTS || outputStream.getOutputEventType() == OutputStream.OutputEventType.ALL_EVENTS) {
            expiredOn = true;
        }
        boolean groupBy = !selector.getGroupByList().isEmpty();
        id = outputStream.getId();
        containsAggregatorThreadLocal.remove();
        QuerySelector querySelector = new QuerySelector(id, selector, currentOn, expiredOn, siddhiQueryContext);
        List<AttributeProcessor> attributeProcessors = SelectorParser.getAttributeProcessors(selector, id, metaComplexEvent, tableMap, variableExpressionExecutors, outputStream, metaPosition, processingMode, outputExpectsExpiredEvents, groupBy, siddhiQueryContext);
        querySelector.setAttributeProcessorList(attributeProcessors, "true".equals(containsAggregatorThreadLocal.get()));
        containsAggregatorThreadLocal.remove();
        ConditionExpressionExecutor havingCondition = SelectorParser.generateHavingExecutor(selector.getHavingExpression(), metaComplexEvent, tableMap, variableExpressionExecutors, siddhiQueryContext);
        querySelector.setHavingConditionExecutor(havingCondition, "true".equals(containsAggregatorThreadLocal.get()));
        containsAggregatorThreadLocal.remove();
        if (!selector.getGroupByList().isEmpty()) {
            List<Expression> groupByExpressionList = selector.getGroupByList().stream().map(groupByVariable -> groupByVariable).collect(Collectors.toList());
            querySelector.setGroupByKeyGenerator(new GroupByKeyGenerator(groupByExpressionList, metaComplexEvent, -1, null, variableExpressionExecutors, siddhiQueryContext));
        }
        if (!selector.getOrderByList().isEmpty()) {
            querySelector.setOrderByEventComparator(new OrderByEventComparator(selector.getOrderByList(), metaComplexEvent, -2, null, variableExpressionExecutors, siddhiQueryContext));
        }
        if (selector.getLimit() != null) {
            expressionExecutor = ExpressionParser.parseExpression((Expression)selector.getLimit(), metaComplexEvent, -2, tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
            containsAggregatorThreadLocal.remove();
            querySelector.setLimit(((Number)((ConstantExpressionExecutor)expressionExecutor).getValue()).longValue());
        }
        if (selector.getOffset() != null) {
            expressionExecutor = ExpressionParser.parseExpression((Expression)selector.getOffset(), metaComplexEvent, -2, tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
            containsAggregatorThreadLocal.remove();
            querySelector.setOffset(((Number)((ConstantExpressionExecutor)expressionExecutor).getValue()).longValue());
        }
        return querySelector;
    }

    private static List<AttributeProcessor> getAttributeProcessors(Selector selector, String id, MetaComplexEvent metaComplexEvent, Map<String, Table> tableMap, List<VariableExpressionExecutor> variableExpressionExecutors, OutputStream outputStream, int metaPosition, ProcessingMode processingMode, boolean outputExpectsExpiredEvents, boolean groupBy, SiddhiQueryContext siddhiQueryContext) {
        ArrayList<AttributeProcessor> attributeProcessorList = new ArrayList<AttributeProcessor>();
        StreamDefinition outputDefinition = StreamDefinition.id((String)id);
        outputDefinition.setQueryContextStartIndex(outputStream.getQueryContextStartIndex());
        outputDefinition.setQueryContextEndIndex(outputStream.getQueryContextEndIndex());
        List outputAttributes = selector.getSelectionList();
        if (selector.getSelectionList().size() == 0) {
            if (metaComplexEvent instanceof MetaStreamEvent) {
                List attributeList = ((MetaStreamEvent)metaComplexEvent).getLastInputDefinition().getAttributeList();
                for (Attribute attribute : attributeList) {
                    Variable variable = new Variable(attribute.getName());
                    variable.setQueryContextStartIndex(selector.getQueryContextStartIndex());
                    variable.setQueryContextEndIndex(selector.getQueryContextEndIndex());
                    OutputAttribute outputAttribute = new OutputAttribute(variable);
                    outputAttribute.setQueryContextStartIndex(selector.getQueryContextStartIndex());
                    outputAttribute.setQueryContextEndIndex(selector.getQueryContextEndIndex());
                    outputAttributes.add(outputAttribute);
                }
            } else {
                int position = 0;
                for (MetaStreamEvent metaStreamEvent : ((MetaStateEvent)metaComplexEvent).getMetaStreamEvents()) {
                    if (metaPosition == -1 || metaPosition == position) {
                        List attributeList = metaStreamEvent.getLastInputDefinition().getAttributeList();
                        for (Attribute attribute : attributeList) {
                            Variable variable = new Variable(attribute.getName());
                            variable.setQueryContextStartIndex(selector.getQueryContextStartIndex());
                            variable.setQueryContextEndIndex(selector.getQueryContextEndIndex());
                            OutputAttribute outputAttribute = new OutputAttribute(variable);
                            outputAttribute.setQueryContextStartIndex(selector.getQueryContextStartIndex());
                            outputAttribute.setQueryContextEndIndex(selector.getQueryContextEndIndex());
                            if (!outputAttributes.contains(outputAttribute)) {
                                outputAttributes.add(outputAttribute);
                                continue;
                            }
                            ArrayList<AbstractDefinition> definitions = new ArrayList<AbstractDefinition>();
                            for (MetaStreamEvent aMetaStreamEvent : ((MetaStateEvent)metaComplexEvent).getMetaStreamEvents()) {
                                definitions.add(aMetaStreamEvent.getLastInputDefinition());
                            }
                            throw new DuplicateAttributeException("Duplicate attribute exist in streams " + definitions, outputStream.getQueryContextStartIndex(), outputStream.getQueryContextEndIndex());
                        }
                    }
                    ++position;
                }
            }
        }
        int i = 0;
        for (OutputAttribute outputAttribute : outputAttributes) {
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(outputAttribute.getExpression(), metaComplexEvent, -1, tableMap, variableExpressionExecutors, groupBy, 0, processingMode, outputExpectsExpiredEvents, siddhiQueryContext);
            if (expressionExecutor instanceof VariableExpressionExecutor) {
                VariableExpressionExecutor executor = (VariableExpressionExecutor)expressionExecutor;
                if (metaComplexEvent instanceof MetaStateEvent) {
                    ((MetaStateEvent)metaComplexEvent).addOutputDataAllowingDuplicate(new MetaStateEventAttribute(executor.getAttribute(), executor.getPosition()));
                } else {
                    ((MetaStreamEvent)metaComplexEvent).addOutputDataAllowingDuplicate(executor.getAttribute());
                }
                outputDefinition.attribute(outputAttribute.getRename(), ((VariableExpressionExecutor)expressionExecutor).getAttribute().getType());
            } else {
                if (metaComplexEvent instanceof MetaStateEvent) {
                    ((MetaStateEvent)metaComplexEvent).addOutputDataAllowingDuplicate(null);
                } else {
                    ((MetaStreamEvent)metaComplexEvent).addOutputDataAllowingDuplicate(null);
                }
                AttributeProcessor attributeProcessor = new AttributeProcessor(expressionExecutor);
                attributeProcessor.setOutputPosition(i);
                attributeProcessorList.add(attributeProcessor);
                outputDefinition.attribute(outputAttribute.getRename(), attributeProcessor.getOutputType());
            }
            ++i;
        }
        metaComplexEvent.setOutputDefinition(outputDefinition);
        return attributeProcessorList;
    }

    private static ConditionExpressionExecutor generateHavingExecutor(Expression expression, MetaComplexEvent metaComplexEvent, Map<String, Table> tableMap, List<VariableExpressionExecutor> variableExpressionExecutors, SiddhiQueryContext siddhiQueryContext) {
        ConditionExpressionExecutor havingConditionExecutor = null;
        if (expression != null) {
            havingConditionExecutor = (ConditionExpressionExecutor)ExpressionParser.parseExpression(expression, metaComplexEvent, -2, tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
        }
        return havingConditionExecutor;
    }

    public static ThreadLocal<String> getContainsAggregatorThreadLocal() {
        return containsAggregatorThreadLocal;
    }
}

